/*
 * Decompiled with CFR 0.152.
 */
package javaforce;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Calendar;
import java.util.HashMap;
import javaforce.JF;

public class JFLog {
    private static HashMap<Integer, LogInstance> list = new HashMap();
    private static boolean useTimestamp = false;
    private static boolean showCause = false;
    private static long timestampBase;
    public static final int DEFAULT = 0;
    public static final int TRACE = 1;
    public static final int DEBUG = 2;
    public static final int INFO = 3;
    public static final int WARN = 4;
    public static final int ERROR = 5;
    private static final long KB = 1024L;
    private static final long GB = 0x40000000L;
    private static final long ms_per_day = 86400000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean init(int id, String filename, boolean append, PrintStream stdout) {
        JFLog.close(id);
        LogInstance log = new LogInstance();
        log.stdout = stdout;
        if (filename != null) {
            log.filename = filename.replaceAll("\\\\", "/");
            if (append) {
                File file = new File(filename);
                log.filesize = file.length();
            } else {
                log.filesize = 0L;
            }
            try {
                log.fos = new FileOutputStream(filename, append);
            }
            catch (Exception e) {
                System.out.println("Log:create file failed:" + filename);
                return false;
            }
        }
        HashMap<Integer, LogInstance> hashMap = list;
        synchronized (hashMap) {
            list.put(id, log);
        }
        return true;
    }

    public static boolean init(String filename, boolean stdout) {
        return JFLog.init(0, filename, false, stdout ? System.out : null);
    }

    public static boolean init(int id, String filename, boolean stdout) {
        return JFLog.init(id, filename, false, stdout ? System.out : null);
    }

    public static boolean append(String filename, boolean stdout) {
        return JFLog.init(0, filename, true, stdout ? System.out : null);
    }

    public static boolean append(int id, String filename, boolean stdout) {
        return JFLog.init(id, filename, true, stdout ? System.out : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setRetention(int id, int days) {
        LogInstance log;
        HashMap<Integer, LogInstance> hashMap = list;
        synchronized (hashMap) {
            log = list.get(id);
        }
        if (log == null) {
            return;
        }
        log.retention = days;
    }

    public static void setRetention(int days) {
        JFLog.setRetention(0, days);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setMaxFilesize(int id, long size) {
        LogInstance log;
        HashMap<Integer, LogInstance> hashMap = list;
        synchronized (hashMap) {
            log = list.get(id);
        }
        if (log == null) {
            return;
        }
        if (size < 1024L) {
            size = 1024L;
        }
        if (size > 0x40000000L) {
            size = 0x40000000L;
        }
        log.maxfilesize = size;
    }

    public static void setMaxFilesize(long size) {
        JFLog.setMaxFilesize(0, size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean close(int id) {
        LogInstance log;
        HashMap<Integer, LogInstance> hashMap = list;
        synchronized (hashMap) {
            log = list.get(id);
            if (log == null) {
                return false;
            }
            list.remove(id);
        }
        try {
            if (log.fos != null) {
                log.fos.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public static boolean close() {
        return JFLog.close(0);
    }

    public static void enableTimestamp(boolean state) {
        timestampBase = System.nanoTime() / 1000000L;
        useTimestamp = state;
    }

    public static void setShowCause(boolean state) {
        showCause = state;
    }

    public static boolean log(String msg) {
        return JFLog.log(0, msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean log(int id, String msg) {
        LogInstance log;
        Object object = list;
        synchronized (object) {
            log = list.get(id);
        }
        if (!useTimestamp) {
            Calendar cal = Calendar.getInstance();
            msg = String.format("[%1$04d/%2$02d/%3$02d %4$02d:%5$02d:%6$02d] %7$s%8$s", cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13), msg, JF.eol);
        } else {
            msg = String.format("[%1$d] %2$s%3$s", System.nanoTime() / 1000000L - timestampBase, msg, JF.eol);
        }
        if (log == null) {
            System.out.print(msg);
            return false;
        }
        if (!log.enabled) {
            return true;
        }
        object = log.lock;
        synchronized (object) {
            if (log.stdout != null) {
                log.stdout.print(msg);
            }
            if (log.fos == null) {
                return true;
            }
            try {
                log.fos.write(msg.getBytes());
                log.fos.flush();
            }
            catch (Exception e) {
                System.out.println("Log:write file failed:" + id);
                return false;
            }
            log.filesize += (long)msg.length();
            if (log.filesize > log.maxfilesize) {
                JFLog.rotate(id);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean rotate(int id) {
        LogInstance log;
        Object object = list;
        synchronized (object) {
            log = list.get(id);
        }
        if (log == null) {
            return false;
        }
        if (log.filename == null) {
            return false;
        }
        if (log.filesize == 0L) {
            return false;
        }
        object = log.lock;
        synchronized (object) {
            log.filesize = 0L;
            Calendar cal = Calendar.getInstance();
            Object tmp = String.format(".%1$04d-%2$02d-%3$02d-%4$02d-%5$02d-%6$02d", cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13));
            int idx = log.filename.lastIndexOf(46);
            tmp = idx == -1 ? log.filename + (String)tmp : log.filename.substring(0, idx) + (String)tmp + log.filename.substring(idx);
            try {
                log.fos.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            File file = new File(log.filename);
            file.renameTo(new File((String)tmp));
            if (log.retention != -1L) {
                File[] files = null;
                int fidx = log.filename.lastIndexOf(47);
                if (fidx == -1) {
                    files = new File(".").listFiles(new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            return name.startsWith(log.filename);
                        }
                    });
                } else {
                    String folder = log.filename.substring(0, fidx);
                    String filename = null;
                    filename = idx == -1 ? log.filename.substring(fidx + 1) : log.filename.substring(fidx + 1, idx);
                    final String fn = filename;
                    files = new File(folder).listFiles(new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            return name.startsWith(fn);
                        }
                    });
                }
                if (files != null) {
                    long timestamp = System.currentTimeMillis() - log.retention * 86400000L;
                    for (File logfile : files) {
                        if (logfile.lastModified() >= timestamp) continue;
                        logfile.delete();
                    }
                }
            }
            try {
                log.fos = new FileOutputStream(log.filename);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    public static boolean rotate() {
        return JFLog.rotate(0);
    }

    public static boolean log(Throwable t) {
        return JFLog.log(0, t);
    }

    public static boolean log(int id, Throwable t) {
        Throwable c;
        StringBuilder buf = new StringBuilder();
        buf.append(t.toString());
        buf.append(JF.eol);
        StackTraceElement[] ste = t.getStackTrace();
        int start = 0;
        if (t instanceof TraceException) {
            start = 1;
        }
        if (ste != null) {
            for (int a = start; a < ste.length; ++a) {
                buf.append("\tat ");
                buf.append(ste[a].toString());
                buf.append(JF.eol);
            }
        }
        boolean result = JFLog.log(id, buf.toString());
        if (showCause && (c = t.getCause()) != null) {
            JFLog.log(id, c);
        }
        return result;
    }

    public static boolean log(String msg, Throwable t) {
        return JFLog.log(0, msg, t);
    }

    public static boolean log(int id, String msg, Throwable t) {
        if (!JFLog.log(id, msg)) {
            return false;
        }
        return JFLog.log(id, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setEnabled(int id, boolean state) {
        HashMap<Integer, LogInstance> hashMap = list;
        synchronized (hashMap) {
            LogInstance log = list.get(id);
            if (log == null) {
                log = new LogInstance();
                list.put(id, log);
            }
            log.enabled = state;
        }
    }

    public static void setEnabled(boolean state) {
        JFLog.setEnabled(0, state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean write(int id, byte[] data, int off, int len) {
        LogInstance log;
        Object object = list;
        synchronized (object) {
            log = list.get(id);
        }
        if (log == null) {
            return false;
        }
        object = log.lock;
        synchronized (object) {
            try {
                log.fos.write(data, off, len);
                log.fos.flush();
                log.filesize += (long)len;
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public static boolean write(byte[] data, int off, int len) {
        return JFLog.write(0, data, off, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OutputStream getOutputStream(int id) {
        LogInstance log;
        HashMap<Integer, LogInstance> hashMap = list;
        synchronized (hashMap) {
            log = list.get(id);
        }
        if (log == null) {
            return null;
        }
        return log.fos;
    }

    public static OutputStream getOutputStream() {
        return JFLog.getOutputStream(0);
    }

    public static void logTrace(int id, String msg) {
        try {
            throw new TraceException(msg);
        }
        catch (Exception e) {
            JFLog.log(id, (Throwable)e);
            return;
        }
    }

    public static void logTrace(String msg) {
        try {
            throw new TraceException(msg);
        }
        catch (Exception e) {
            JFLog.log(0, (Throwable)e);
            return;
        }
    }

    private static class LogInstance {
        private Object lock = new Object();
        private FileOutputStream fos;
        private PrintStream stdout;
        private long filesize;
        private String filename;
        private boolean enabled = true;
        private long retention = -1L;
        private long maxfilesize = 0x100000L;

        private LogInstance() {
        }
    }

    private static class TraceException
    extends Exception {
        public TraceException(String msg) {
            super(msg);
        }
    }
}

