/*
 * Decompiled with CFR 0.152.
 */
package javaforce.ui;

import javaforce.ui.Component;
import javaforce.ui.Dimension;
import javaforce.ui.Image;
import javaforce.ui.LayoutMetrics;
import javaforce.ui.Point;
import javaforce.ui.ScrollBar;
import javaforce.ui.ScrollLink;

public class ScrollBox
extends Component
implements ScrollLink {
    private Image buffer;
    private ScrollBar vBar;
    private ScrollBar hBar;
    private LayoutMetrics cmp_metrics = new LayoutMetrics();
    private Component cmp;
    private int offx;
    private int offy;
    private ScrollLink link;
    private int clientWidth;
    private int clientHeight;
    private Dimension cmp_size;
    private static Point pt = new Point();

    public ScrollBox(Component cmp, int bars) {
        this.cmp = cmp;
        if ((bars & 2) != 0) {
            this.vBar = new ScrollBar(2);
            this.vBar.setChangeListener(bar -> {
                if (this.link != null) {
                    this.link.setClientY(this.vBar.getValue());
                } else {
                    this.offy = this.vBar.getValue();
                }
            });
        }
        if ((bars & 1) != 0) {
            this.hBar = new ScrollBar(1);
            this.hBar.setChangeListener(bar -> {
                if (this.link != null) {
                    this.link.setClientX(this.hBar.getValue());
                } else {
                    this.offx = this.hBar.getValue();
                }
            });
        }
        cmp.setBorderStyle(0);
        this.setBorderStyle(1);
        if (cmp instanceof ScrollLink) {
            this.link = (ScrollLink)((Object)cmp);
            this.link.setLink(this);
        }
        cmp.setParent(this);
    }

    public Component getComponent() {
        return this.cmp;
    }

    @Override
    public Dimension getMinSize() {
        return this.size;
    }

    @Override
    public void layout(LayoutMetrics metrics) {
        super.layout(metrics);
        this.cmp_metrics.setPosition(0, 0);
        this.cmp_size = this.cmp.getMinSize();
        boolean linked = this.link != null;
        this.clientWidth = this.getWidth();
        if (this.vBar != null) {
            this.clientWidth -= 16;
        }
        if (this.cmp_size.width < this.clientWidth) {
            this.cmp_size.width = this.clientWidth;
        }
        if (this.cmp_size.width > this.clientWidth && linked) {
            this.cmp_size.width = this.clientWidth;
        }
        this.clientHeight = this.getHeight();
        if (this.hBar != null) {
            this.clientHeight -= 16;
        }
        if (this.cmp_size.height < this.clientHeight) {
            this.cmp_size.height = this.clientHeight;
        }
        if (this.cmp_size.height > this.clientHeight && linked) {
            this.cmp_size.height = this.clientHeight;
        }
        this.cmp_metrics.setSize(this.cmp_size);
        this.cmp.layout(this.cmp_metrics);
        if (this.vBar != null) {
            this.cmp_metrics.setPosition(this.getX() + this.getWidth() - 16, this.getY());
            this.cmp_metrics.setSize(16, this.getHeight() - (this.hBar != null ? 16 : 0));
            this.vBar.layout(this.cmp_metrics);
        }
        if (this.hBar != null) {
            this.cmp_metrics.setPosition(this.getX(), this.getY() + this.getHeight() - 16);
            this.cmp_metrics.setSize(this.getWidth() - (this.vBar != null ? 16 : 0), 16);
            this.hBar.layout(this.cmp_metrics);
        }
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        if (this.vBar != null) {
            this.vBar.setSize(16, height - (this.hBar != null ? 16 : 0));
            this.vBar.setFullsize(this.cmp.getMinHeight());
            this.vBar.setViewsize(this.getHeight() - (this.hBar != null ? 16 : 0) - (this.getBorderStyle() != 0 ? 2 : 0));
        }
        if (this.hBar != null) {
            this.hBar.setSize(width - (this.vBar != null ? 16 : 0), 16);
            this.hBar.setFullsize(this.cmp.getMinWidth());
            this.hBar.setViewsize(this.getWidth() - (this.vBar != null ? 16 : 0) - (this.getBorderStyle() != 0 ? 2 : 0));
        }
    }

    public void setStepsize(int size) {
        if (this.vBar != null) {
            this.vBar.setStepsize(size);
        }
        if (this.hBar != null) {
            this.hBar.setStepsize(size);
        }
    }

    public void setFullsize(Dimension size) {
        if (size.width < this.clientWidth) {
            size.width = this.clientWidth;
        }
        if (size.height < this.clientHeight) {
            size.height = this.clientHeight;
        }
        if (this.vBar != null) {
            this.vBar.setFullsize(size.height);
        }
        if (this.hBar != null) {
            this.hBar.setFullsize(size.width);
        }
    }

    @Override
    public void render(Image image) {
        if (this.vBar != null) {
            this.vBar.render(image);
        }
        if (this.hBar != null) {
            this.hBar.render(image);
        }
        Dimension cmp_size = this.cmp.getMinSize();
        if (this.buffer == null) {
            this.buffer = new Image(cmp_size.width, cmp_size.height);
        }
        if (this.buffer.getWidth() != cmp_size.width || this.buffer.getHeight() != cmp_size.height) {
            this.buffer.setSize(cmp_size);
        }
        this.cmp.render(this.buffer);
        int sx = this.link == null ? this.offx : 0;
        int sy = this.link == null ? this.offy : 0;
        int sw = cmp_size.width;
        int sh = cmp_size.height;
        int dx = this.getX();
        int dy = this.getY();
        int dw = this.getWidth();
        int dh = this.getHeight();
        if (this.getBorderStyle() != 0) {
            image.setForeColor(this.getForeColor());
            image.setLineStyle(this.borderStyle);
            image.drawBox(dx, dy, dw, dh);
            image.setLineStyle(1);
            ++dx;
            ++dy;
            dw -= 2;
            dh -= 2;
        }
        if (this.vBar != null) {
            dw -= 16;
        }
        if (dw > sw) {
            dw = sw;
        }
        if (this.hBar != null) {
            dh -= 16;
        }
        if (dh > sh) {
            dh = sh;
        }
        image.putPixels(this.buffer.getBuffer(), dx, dy, dw, dh, sx + sy * sw, sw);
    }

    @Override
    public void setLayer(int layer) {
        super.setLayer(layer);
        if (this.vBar != null) {
            this.vBar.setLayer(layer);
        }
        if (this.hBar != null) {
            this.hBar.setLayer(layer);
        }
        this.cmp.setLayer(layer);
    }

    public void resetOffset() {
        this.offx = 0;
        if (this.vBar != null) {
            this.vBar.setValue(0);
        }
        this.offy = 0;
        if (this.hBar != null) {
            this.hBar.setValue(0);
        }
        if (this.link != null) {
            this.link.setClientX(0);
            this.link.setClientY(0);
        }
    }

    @Override
    public void mouseMove(int x, int y) {
        super.mouseMove(x, y);
        ScrollBox.pt.x = x;
        ScrollBox.pt.y = y;
        if (this.vBar != null && this.vBar.isInside(pt)) {
            this.vBar.mouseMove(x, y);
            return;
        }
        if (this.hBar != null && this.hBar.isInside(pt)) {
            this.hBar.mouseMove(x, y);
            return;
        }
        this.cmp.mouseMove(x - this.pos.x + this.offx, y - this.pos.y + this.offy);
    }

    @Override
    public void mouseDown(int button) {
        ScrollBox.pt.x = this.getMouseX();
        ScrollBox.pt.y = this.getMouseY();
        if (this.vBar != null && this.vBar.isInside(pt)) {
            this.vBar.mouseDown(button);
            return;
        }
        if (this.hBar != null && this.hBar.isInside(pt)) {
            this.hBar.mouseDown(button);
            return;
        }
        this.cmp.mouseDown(button);
    }

    @Override
    public void mouseUp(int button) {
        ScrollBox.pt.x = this.getMouseX();
        ScrollBox.pt.y = this.getMouseY();
        if (this.vBar != null && this.vBar.isInside(pt)) {
            this.vBar.mouseUp(button);
            return;
        }
        if (this.hBar != null && this.hBar.isInside(pt)) {
            this.hBar.mouseUp(button);
            return;
        }
        this.cmp.mouseUp(button);
    }

    @Override
    public void mouseScroll(int dx, int dy) {
        ScrollBox.pt.x = this.getMouseX();
        ScrollBox.pt.y = this.getMouseY();
        if (this.vBar != null && this.vBar.isInside(pt)) {
            this.vBar.mouseScroll(dx, dy);
            return;
        }
        if (this.hBar != null && this.hBar.isInside(pt)) {
            this.hBar.mouseScroll(dx, dy);
            return;
        }
        this.cmp.mouseScroll(dx, dy);
    }

    @Override
    public int getClientX() {
        return this.offx;
    }

    @Override
    public void setClientX(int value) {
        this.offx = value;
        if (this.hBar != null) {
            this.hBar.setValue(this.offx);
        }
    }

    @Override
    public int getClientY() {
        return this.offy;
    }

    @Override
    public void setClientY(int value) {
        this.offy = value;
        if (this.vBar != null) {
            this.vBar.setValue(this.offy);
        }
    }

    @Override
    public void setLink(ScrollBox link) {
    }

    public String toString() {
        return "ScrollBox";
    }
}

