/*
 * Decompiled with CFR 0.152.
 */
package javaforce.utils;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import javaforce.JFLog;

public class WakeOnLan {
    private DatagramSocket socket;

    public boolean init() {
        try {
            this.socket = new DatagramSocket();
            this.socket.setBroadcast(true);
        }
        catch (Exception e) {
            JFLog.log(e);
        }
        return true;
    }

    public void wake(byte[] mac) {
        int a;
        if (mac == null || mac.length != 6) {
            return;
        }
        byte[] data = new byte[102];
        for (a = 0; a < 6; ++a) {
            data[0] = -1;
        }
        for (a = 0; a < 16; ++a) {
            System.arraycopy(mac, 0, data, 6 + a * 6, 6);
        }
        try {
            DatagramPacket packet = new DatagramPacket(data, 0, data.length);
            packet.setAddress(InetAddress.getByName("255.255.255.255"));
            packet.setPort(0);
            this.socket.send(packet);
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    public void wake(String mac) {
        if (mac == null || mac.length() != 12) {
            return;
        }
        byte[] binmac = new byte[6];
        for (int a = 0; a < 6; ++a) {
            int idx = a * 2;
            String p = mac.substring(idx, idx + 2);
            binmac[a] = Short.valueOf(p, 16).byteValue();
        }
        this.wake(binmac);
    }
}

