/*
 * Decompiled with CFR 0.152.
 */
package javaforce.vm;

import java.io.Serializable;
import javaforce.ShellProcess;
import javaforce.vm.NetworkBridge;
import javaforce.vm.NetworkConfig;

public class NetworkVirtual
extends NetworkConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    public String bridge;
    public int vlan;

    public NetworkVirtual(String name, String bridge, String mac, String ip, String netmask, int vlan) {
        super(name);
        this.mac = mac;
        this.ip = ip;
        this.netmask = netmask;
        this.bridge = bridge;
        this.vlan = vlan;
    }

    @Override
    public String[] getState() {
        return new String[]{this.name, this.state.ip + "/" + this.state.netmask, this.state.mac, Integer.toString(this.vlan), this.bridge, this.state.link};
    }

    public static NetworkVirtual createVirtual(String name, NetworkBridge bridge, String mac, String ip, String netmask, int vlan) {
        ShellProcess p = new ShellProcess();
        p.keepOutput(true);
        p.run(new String[]{"/usr/bin/ovs-vsctl", "add-br", name, bridge.name, Integer.toString(vlan)}, true);
        NetworkVirtual nic = new NetworkVirtual(name, bridge.name, mac, ip, netmask, vlan);
        nic.link_up();
        nic.set_ip();
        return nic;
    }

    public boolean start() {
        this.link_up();
        this.set_ip();
        return true;
    }

    public boolean stop() {
        this.link_down();
        return true;
    }

    public boolean remove() {
        ShellProcess p = new ShellProcess();
        p.keepOutput(true);
        p.run(new String[]{"/usr/bin/ovs-vsctl", "del-br", this.name}, true);
        return true;
    }
}

