/*
 * Decompiled with CFR 0.152.
 */
package javaforce.webui;

import java.util.ArrayList;
import javaforce.webui.Component;

public class ComboBox
extends Component {
    private ArrayList<String> values = new ArrayList();
    private ArrayList<String> texts = new ArrayList();
    private int index = -1;

    public ComboBox() {
        this.addEvent("onchange", "onComboBoxChange(event, this);");
    }

    @Override
    public String html() {
        StringBuilder sb = new StringBuilder();
        sb.append("<select" + this.getAttrs() + ">");
        int cnt = this.values.size();
        for (int a = 0; a < cnt; ++a) {
            sb.append("<option value='" + this.values.get(a) + "'" + (a == this.index ? " selected" : "") + ">");
            sb.append(this.texts.get(a));
            sb.append("</option>");
        }
        sb.append("</select>");
        return sb.toString();
    }

    public void add(String value, String text) {
        if (this.index == -1) {
            this.index = 0;
        }
        this.values.add(value);
        this.texts.add(text);
        if (this.client != null) {
            this.sendEvent("addoption", new String[]{"value=" + value, "text=" + text});
        }
    }

    public void clear() {
        for (int a = 0; a < this.values.size(); ++a) {
            this.sendEvent("removeoption", new String[]{"idx=0"});
        }
        this.index = -1;
        this.values.clear();
        this.texts.clear();
    }

    public int getCount() {
        return this.values.size();
    }

    public int getSelectedIndex() {
        return this.index;
    }

    public String getSelectedValue() {
        int idx = this.getSelectedIndex();
        if (idx == -1) {
            return null;
        }
        return this.values.get(idx);
    }

    public String getSelectedText() {
        int idx = this.getSelectedIndex();
        if (idx == -1) {
            return null;
        }
        return this.texts.get(idx);
    }

    public void setSelectedIndex(int idx) {
        this.index = idx;
        this.sendEvent("setidx", new String[]{"idx=" + idx});
    }

    @Override
    public void onChanged(String[] args) {
        int idx = args[0].indexOf("=");
        this.index = Integer.valueOf(args[0].substring(idx + 1));
        super.onChanged(args);
    }
}

