package javaforce.awt;

/** MQTT Viewer
 *
 * @author peter.quiring
 */

import javaforce.*;

public class MQTTViewer extends javax.swing.JFrame implements MQTTEvents {

  /**
   * Creates new form MQTTViewer
   */
  public MQTTViewer() {
    initComponents();
    if (server_init != null) {
      server.setText(server_init);
    }
  }

  /**
   * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The content of this method is always regenerated by the Form
   * Editor.
   */
  @SuppressWarnings("unchecked")
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {

    jLabel1 = new javax.swing.JLabel();
    server = new javax.swing.JTextField();
    jLabel2 = new javax.swing.JLabel();
    topic = new javax.swing.JTextField();
    start = new javax.swing.JButton();
    jScrollPane1 = new javax.swing.JScrollPane();
    msgs = new javax.swing.JTextArea();

    setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
    setTitle("MQTT Viewer");

    jLabel1.setText("Server");

    server.setText("127.0.0.1");

    jLabel2.setText("Topic");

    topic.setText("*");

    start.setText("Start");
    start.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        startActionPerformed(evt);
      }
    });

    msgs.setColumns(20);
    msgs.setRows(5);
    jScrollPane1.setViewportView(msgs);

    javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
    getContentPane().setLayout(layout);
    layout.setHorizontalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(layout.createSequentialGroup()
        .addContainerGap()
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
          .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 788, Short.MAX_VALUE)
          .addGroup(layout.createSequentialGroup()
            .addComponent(jLabel2)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
            .addComponent(topic))
          .addGroup(layout.createSequentialGroup()
            .addComponent(jLabel1)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
            .addComponent(server)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
            .addComponent(start)))
        .addContainerGap())
    );
    layout.setVerticalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(layout.createSequentialGroup()
        .addContainerGap()
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
          .addComponent(jLabel1)
          .addComponent(server, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
          .addComponent(start))
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
          .addComponent(jLabel2)
          .addComponent(topic, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 612, Short.MAX_VALUE)
        .addContainerGap())
    );

    pack();
  }// </editor-fold>//GEN-END:initComponents

  private void startActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_startActionPerformed
    start();
  }//GEN-LAST:event_startActionPerformed

  /**
   * @param args the command line arguments
   */
  public static void main(String args[]) {
    if (args.length > 0) {
      server_init = args[0];
    }
    /* Create and display the form */
    java.awt.EventQueue.invokeLater(new Runnable() {
      public void run() {
        new MQTTViewer().setVisible(true);
      }
    });
  }

  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JLabel jLabel1;
  private javax.swing.JLabel jLabel2;
  private javax.swing.JScrollPane jScrollPane1;
  private javax.swing.JTextArea msgs;
  private javax.swing.JTextField server;
  private javax.swing.JButton start;
  private javax.swing.JTextField topic;
  // End of variables declaration//GEN-END:variables

  private MQTT client;
  private static String server_init;

  public boolean message(String topic, String msg) {
    String ln = topic + "=" + msg + "\r\n";
    msgs.setText(msgs.getText() + ln);
    return true;
  }

  public void start() {
    if (client == null) {
      start_new();
    } else {
      stop();
    }
  }

  public void start_new() {
    String _server = server.getText();
    String _topic = topic.getText();
    msgs.setText("Connecting to " + _server + "...");
    client = new MQTT();
    if (!client.connect(_server)) {
      msgs.setText("Connection failed!");
      client = null;
    }
    client.connect();
    msgs.setText("Connected to " + _server + "\r\n");
    client.setListener(this);
    client.subscribe(_topic);
    start.setText("Stop");
    server.setEditable(false);
    topic.setEditable(false);
  }

  public void stop() {
    client.disconnect();
    client = null;
    start.setText("Start");
    server.setEditable(true);
    topic.setEditable(true);
  }
}
