/*
 * Decompiled with CFR 0.152.
 */
package javaforce.awt;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javaforce.MQTT;
import javaforce.MQTTEvents;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class MQTTViewer
extends JFrame
implements MQTTEvents {
    private JCheckBox authenticate;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JScrollPane jScrollPane1;
    private JTextArea msgs;
    private JTextField password;
    private JTextField server;
    private JButton start;
    private JTextField topic;
    private JTextField username;
    private MQTT client;
    private static String[] args;

    public MQTTViewer() {
        this.initComponents();
        if (args.length > 0) {
            this.server.setText(args[0]);
            if (args.length > 1) {
                this.authenticate.setSelected(true);
                this.username.setText(args[1]);
                if (args.length > 2) {
                    this.password.setText(args[2]);
                }
            }
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.server = new JTextField();
        this.jLabel2 = new JLabel();
        this.topic = new JTextField();
        this.start = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.msgs = new JTextArea();
        this.jLabel3 = new JLabel();
        this.authenticate = new JCheckBox();
        this.username = new JTextField();
        this.jLabel4 = new JLabel();
        this.password = new JTextField();
        this.setDefaultCloseOperation(3);
        this.setTitle("MQTT Viewer");
        this.jLabel1.setText("Server");
        this.server.setText("127.0.0.1");
        this.server.setMinimumSize(new Dimension(200, 22));
        this.server.setPreferredSize(new Dimension(200, 22));
        this.jLabel2.setText("Topic");
        this.topic.setText("#");
        this.start.setText("Start");
        this.start.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MQTTViewer.this.startActionPerformed(evt);
            }
        });
        this.msgs.setColumns(20);
        this.msgs.setRows(5);
        this.jScrollPane1.setViewportView(this.msgs);
        this.jLabel3.setText("Username");
        this.authenticate.setText("Authenticate");
        this.username.setMinimumSize(new Dimension(100, 22));
        this.username.setPreferredSize(new Dimension(100, 22));
        this.jLabel4.setText("Password");
        this.password.setMinimumSize(new Dimension(100, 22));
        this.password.setPreferredSize(new Dimension(100, 22));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 788, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.topic)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.server, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.authenticate).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.username, -2, 100, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.password, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.start))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.server, -2, -1, -2).addComponent(this.start).addComponent(this.jLabel3).addComponent(this.authenticate).addComponent(this.username, -2, -1, -2).addComponent(this.jLabel4).addComponent(this.password, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.topic, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 612, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void startActionPerformed(ActionEvent evt) {
        this.start();
    }

    public static void main(String[] args) {
        MQTTViewer.args = args;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new MQTTViewer().setVisible(true);
            }
        });
    }

    @Override
    public boolean message(String topic, String msg) {
        String ln = topic + "=" + msg + "\r\n";
        this.msgs.setText(this.msgs.getText() + ln);
        return true;
    }

    public void start() {
        if (this.client == null) {
            this.start_new();
        } else {
            this.stop();
        }
    }

    public void start_new() {
        String _server = this.server.getText();
        String _topic = this.topic.getText();
        this.msgs.setText("Connecting to " + _server + "...");
        this.client = new MQTT();
        if (!this.client.connect(_server)) {
            this.msgs.setText("Connection failed!");
            this.client = null;
        }
        if (this.authenticate.isSelected()) {
            String _user = this.username.getText();
            String _pass = this.password.getText();
            this.client.connect(_user, _pass);
        } else {
            this.client.connect();
        }
        this.msgs.setText("Connected to " + _server + "\r\n");
        this.client.setListener(this);
        this.client.subscribe(_topic);
        this.start.setText("Stop");
        this.setState(false);
    }

    public void stop() {
        this.client.disconnect();
        this.client = null;
        this.start.setText("Start");
        this.setState(true);
    }

    private void setState(boolean state) {
        this.server.setEditable(state);
        this.topic.setEditable(state);
        this.authenticate.setEnabled(state);
        this.username.setEditable(state);
        this.password.setEditable(state);
    }
}

