/*
 * Decompiled with CFR 0.152.
 */
package javaforce.controls.mod;

import javaforce.BE;
import javaforce.JFLog;
import javaforce.controls.mod.ModAddr;
import javaforce.controls.mod.ModData;

public class ModPacket {
    private static short tid = (short)4096;

    private static byte readFunc(byte io_type) {
        switch (io_type) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 4: {
                return 3;
            }
            case 3: {
                return 4;
            }
        }
        return 0;
    }

    public static byte[] makeReadPacket(ModAddr addr) {
        byte[] data = new byte[12];
        short s = tid;
        tid = (short)(s + 1);
        BE.setuint16(data, 0, s);
        BE.setuint16(data, 4, 6);
        data[7] = ModPacket.readFunc(addr.io_type);
        BE.setuint16(data, 8, addr.io_number);
        BE.setuint16(data, 10, addr.length);
        return data;
    }

    private static byte writeFunc(byte io_type) {
        switch (io_type) {
            case 1: {
                return 5;
            }
            case 4: {
                return 6;
            }
        }
        return 0;
    }

    public static byte[] makeWritePacket(ModAddr addr) {
        byte[] data = new byte[12];
        short s = tid;
        tid = (short)(s + 1);
        BE.setuint16(data, 0, s);
        BE.setuint16(data, 4, 6);
        data[7] = ModPacket.writeFunc(addr.io_type);
        BE.setuint16(data, 8, addr.io_number);
        if (addr.io_type == 1) {
            BE.setuint16(data, 10, addr.data[0] != 0 ? 65280 : 0);
        } else {
            data[10] = addr.data[0];
            data[11] = addr.data[1];
        }
        return data;
    }

    public static ModAddr decodeAddress(String addr) {
        addr = addr.toUpperCase();
        ModAddr ma = new ModAddr();
        ma.length = 1;
        switch (addr.charAt(0)) {
            case 'C': {
                ma.io_type = 1;
                ma.io_number = Short.valueOf(addr.substring(1)).shortValue();
                --ma.io_number;
                break;
            }
            case 'D': {
                if (addr.charAt(1) != 'I') {
                    JFLog.log("MODBUS:Invalid addr:" + addr);
                    return null;
                }
                ma.io_type = (byte)2;
                ma.io_number = Integer.valueOf(addr.substring(2));
                --ma.io_number;
                break;
            }
            case 'I': {
                if (addr.charAt(1) != 'R') {
                    JFLog.log("MODBUS:Invalid addr:" + addr);
                    return null;
                }
                ma.io_type = (byte)3;
                if (addr.charAt(2) == 'X') {
                    ma.io_number = Integer.valueOf(addr.substring(3), 16);
                    break;
                }
                ma.io_number = Integer.valueOf(addr.substring(2));
                break;
            }
            case 'H': {
                if (addr.charAt(1) != 'R') {
                    JFLog.log("MODBUS:Invalid addr:" + addr);
                    return null;
                }
                ma.io_type = (byte)4;
                if (addr.charAt(2) == 'X') {
                    ma.io_number = Integer.valueOf(addr.substring(3), 16);
                    break;
                }
                ma.io_number = Integer.valueOf(addr.substring(2));
                break;
            }
            default: {
                return null;
            }
        }
        return ma;
    }

    public static ModData decodePacket(byte[] data) {
        ModData out = new ModData();
        short tid = (short)BE.getuint16(data, 0);
        short proto = (short)BE.getuint16(data, 2);
        short len = (short)BE.getuint16(data, 4);
        byte uid = data[6];
        if (data.length != 6 + len) {
            return null;
        }
        byte func = data[7];
        switch (func) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                byte blen = data[8];
                out.type = func;
                out.data = new byte[blen];
                System.arraycopy(data, 9, out.data, 0, blen);
            }
        }
        return out;
    }

    public static boolean isPacketComplete(byte[] data) {
        try {
            return ModPacket.decodePacket(data) != null;
        }
        catch (Exception e) {
            return false;
        }
    }
}

