/*
 * Decompiled with CFR 0.152.
 */
package javaforce.media;

import java.util.ArrayList;
import javaforce.BE;
import javaforce.JF;
import javaforce.JFLog;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;

public class AudioOutput {
    private SourceDataLine sdl;
    private AudioFormat af;
    private byte[] buf8;

    public String[] listDevices() {
        ArrayList<String> mixers = new ArrayList<String>();
        Mixer.Info[] mi = AudioSystem.getMixerInfo();
        mixers.add("<default>");
        for (int a = 0; a < mi.length; ++a) {
            String name = mi[a].getName();
            Mixer m = AudioSystem.getMixer(mi[a]);
            if (m.getSourceLineInfo().length == 0) continue;
            mixers.add(name);
        }
        return mixers.toArray(JF.StringArrayType);
    }

    public boolean start(int chs, int freq, int bits, int frame_size, String device) {
        if (bits != 16) {
            return false;
        }
        this.buf8 = new byte[frame_size * 2];
        if (device == null) {
            device = "<default>";
        }
        this.af = new AudioFormat(freq, bits, chs, true, true);
        JFLog.log("AudioOutput:AudioFormat=" + String.valueOf(this.af));
        Mixer.Info[] mi = AudioSystem.getMixerInfo();
        int idx = -1;
        for (int a = 0; a < mi.length; ++a) {
            if (!mi[a].getName().equalsIgnoreCase(device)) continue;
            idx = a;
            break;
        }
        try {
            this.sdl = idx == -1 ? AudioSystem.getSourceDataLine(this.af) : AudioSystem.getSourceDataLine(this.af, mi[idx]);
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
        try {
            this.sdl.open(this.af);
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
        this.sdl.start();
        return true;
    }

    public boolean write(byte[] buf) {
        this.sdl.write(buf, 0, buf.length);
        return true;
    }

    public boolean write(short[] buf16) {
        this.sdl.write(BE.shortArray2byteArray(buf16, this.buf8), 0, buf16.length * 2);
        return true;
    }

    public void flush() {
        this.sdl.drain();
        this.sdl.flush();
    }

    public boolean stop() {
        if (this.sdl == null) {
            return false;
        }
        this.sdl.stop();
        this.sdl.close();
        this.sdl = null;
        return true;
    }
}

