/*
 * Decompiled with CFR 0.152.
 */
package javaforce.media;

import java.io.File;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.jni.JFNative;
import javaforce.jni.Library;
import javaforce.jni.LnxNative;

public class MediaCoder {
    private long ctx = 0L;
    public static final int SEEK_SET = 0;
    public static final int SEEK_CUR = 1;
    public static final int SEEK_END = 2;
    public static final int PROFILE_BASELINE = 1;
    public static final int PROFILE_MAIN = 2;
    public static final int PROFILE_HIGH = 3;
    public static final int AV_CODEC_ID_NONE = 0;
    public static final int AV_CODEC_ID_MPEG1VIDEO = 1;
    public static final int AV_CODEC_ID_MPEG2VIDEO = 2;
    public static final int AV_CODEC_ID_H263 = 4;
    public static final int AV_CODEC_ID_MPEG4 = 12;
    public static final int AV_CODEC_ID_H264 = 27;
    public static final int AV_CODEC_ID_THEORA = 30;
    public static final int AV_CODEC_ID_VP8 = 139;
    public static final int AV_CODEC_ID_VP9 = 167;
    public static final int AV_CODEC_ID_H265 = 173;
    public static final int AV_CODEC_ID_PCM_S16LE = 65536;
    public static final int AV_CODEC_ID_MP2 = 86016;
    public static final int AV_CODEC_ID_MP3 = 86017;
    public static final int AV_CODEC_ID_AAC = 86018;
    public static final int AV_CODEC_ID_AC3 = 86019;
    public static final int AV_CODEC_ID_VORBIS = 86021;
    public static final int AV_CODEC_ID_FLAC = 86028;
    public static final int AV_CODEC_ID_GSM_MS = 86046;
    public static final int AV_CODEC_ID_OPUS = 86076;
    public static final int END_FRAME = -1;
    public static final int NULL_FRAME = 0;
    public static final int AUDIO_FRAME = 1;
    public static final int VIDEO_FRAME = 2;

    public static void init() {
        File[] sysFolders;
        String ext = "";
        String apphome = System.getProperty("java.app.home");
        if (apphome == null) {
            apphome = ".";
        }
        if (JF.isWindows()) {
            sysFolders = new File[]{new File(apphome), new File(System.getenv("appdata") + "/ffmpeg"), new File(".")};
            ext = ".dll";
        } else if (JF.isMac()) {
            sysFolders = new File[]{new File(apphome), new File(".")};
            ext = ".dylib";
        } else {
            sysFolders = new File[]{new File("/usr/lib"), new File(LnxNative.getArchLibFolder())};
            ext = ".so";
        }
        Library[] libs = new Library[]{new Library("avcodec"), new Library("avdevice"), new Library("avfilter"), new Library("avformat"), new Library("avutil"), new Library("swscale"), new Library("postproc"), new Library("swresample")};
        JFNative.findLibraries(sysFolders, libs, ext, libs.length - 1);
        if (!MediaCoder.haveLibs(libs)) {
            for (int a = 0; a < libs.length; ++a) {
                if (libs[a].path != null) continue;
                System.out.println("Error:Unable to find library:" + libs[a].name + ext);
            }
            JFLog.log("MediaCoder.load() failed");
            System.exit(1);
        }
        if (!MediaCoder.ninit(libs[0].path, libs[1].path, libs[2].path, libs[3].path, libs[4].path, libs[5].path, libs[6].path, libs[7].path)) {
            System.exit(1);
        }
    }

    private static native boolean ninit(String var0, String var1, String var2, String var3, String var4, String var5, String var6, String var7);

    public static native void setLogging(boolean var0);

    private static boolean haveLibs(Library[] libs) {
        int cnt = 0;
        for (int a = 0; a < 7; ++a) {
            if (libs[a].path == null) continue;
            ++cnt;
        }
        if (libs[7].path != null) {
            ++cnt;
        } else if (libs[8].path != null) {
            ++cnt;
        }
        return cnt == 8;
    }
}

