/*
 * Decompiled with CFR 0.152.
 */
package javaforce.voip;

import javaforce.JFLog;
import javaforce.media.MediaVideoDecoder;
import javaforce.voip.CodecInfo;
import javaforce.voip.Packet;
import javaforce.voip.PacketReceiver;
import javaforce.voip.RTPChannel;
import javaforce.voip.RTPCodec;

public class RTPH264
extends RTPCodec {
    private static boolean debug = false;
    private static final int mtu = 1446;
    private int seqnum;
    private int timestamp;
    private final int ssrc = this.random.nextInt();
    private Packet packet = new Packet();
    private int lastseqnum = -1;
    private static final int maxSize = 0x400000;
    private int log;
    private static final int FU = 28;
    private static final int S = 128;
    private static final int E = 64;
    private static final int M = 128;

    public RTPH264() {
        this.packet.data = new byte[0x400000];
    }

    public void setLog(int id) {
        this.log = id;
    }

    private int find_best_length(byte[] data, int offset, int length) {
        for (int a = 1; a < length - 3; ++a) {
            if (data[offset + a] != 0 || data[offset + a + 1] != 0 || data[offset + a + 2] != 1) continue;
            return a;
        }
        return length;
    }

    @Override
    public void encode(byte[] data, int offset, int length, int x, int y, int id, PacketReceiver pr) {
        int len = length;
        int pos = offset;
        while (len > 0) {
            int packetLength;
            while (data[pos] == 0) {
                ++pos;
                --len;
            }
            if ((packetLength = --len > 1446 ? this.find_best_length(data, ++pos, len) : len) > 1446) {
                int nalLength = 1444;
                byte type = RTPH264.get_nal_type(data, pos);
                byte nri = (byte)(data[pos] & 0x60);
                ++pos;
                --len;
                --packetLength;
                boolean first = true;
                while (packetLength > nalLength) {
                    this.packet.length = 14 + nalLength;
                    RTPChannel.buildHeader(this.packet.data, id, this.seqnum++, this.timestamp, this.ssrc, false);
                    this.packet.data[12] = 28;
                    this.packet.data[12] = (byte)(this.packet.data[12] | nri);
                    this.packet.data[13] = type;
                    if (first) {
                        this.packet.data[13] = (byte)(this.packet.data[13] | 0x80);
                        first = false;
                    }
                    System.arraycopy(data, pos, this.packet.data, 14, nalLength);
                    pos += nalLength;
                    len -= nalLength;
                    packetLength -= nalLength;
                    pr.onPacket(this.packet);
                }
                nalLength = packetLength;
                this.packet.length = 14 + nalLength;
                RTPChannel.buildHeader(this.packet.data, id, this.seqnum++, this.timestamp, this.ssrc, len == nalLength);
                this.packet.data[12] = 28;
                this.packet.data[12] = (byte)(this.packet.data[12] | nri);
                this.packet.data[13] = type;
                this.packet.data[13] = (byte)(this.packet.data[13] | 0x40);
                System.arraycopy(data, pos, this.packet.data, 14, nalLength);
                pos += nalLength;
                len -= nalLength;
                packetLength -= nalLength;
                pr.onPacket(this.packet);
                continue;
            }
            this.packet.length = packetLength + 12;
            RTPChannel.buildHeader(this.packet.data, id, this.seqnum++, this.timestamp, this.ssrc, len == packetLength);
            System.arraycopy(data, pos, this.packet.data, 12, packetLength);
            pr.onPacket(this.packet);
            pos += packetLength;
            len -= packetLength;
        }
        this.timestamp += 100;
    }

    @Override
    public void decode(byte[] rtp, int offset, int length, PacketReceiver pr) {
        if (length < 14) {
            return;
        }
        int h264Length = length - 12;
        byte type = RTPH264.get_nal_type(rtp, 12);
        int thisseqnum = RTPChannel.getseqnum(rtp, 0);
        if (type >= 1 && type <= 23) {
            System.arraycopy(rtp, 12, this.packet.data, 4, h264Length);
            this.packet.data[3] = 1;
            this.packet.length = 4 + h264Length;
            if (debug) {
                this.log(this.packet);
            }
            pr.onPacket(this.packet);
            this.lastseqnum = thisseqnum;
            this.packet.length = 0;
        } else if (type == 28) {
            boolean m;
            boolean first = (rtp[13] & 0x80) == 128;
            boolean last = (rtp[13] & 0x40) == 64;
            byte fu_type = RTPH264.get_fu_type(rtp, 13);
            boolean bl = m = (rtp[1] & 0x80) == 128;
            if (m && !last) {
                JFLog.log(this.log, "Error : H264 : FU : M bit set but not last packet : seq=" + thisseqnum);
                this.lastseqnum = -1;
                this.packet.length = 0;
                return;
            }
            if (first) {
                if (this.packet.length != 0) {
                    JFLog.log(this.log, "Warning : H264 : FU : first packet again, last frame lost?");
                }
                int nri = rtp[12] & 0x60;
                System.arraycopy(rtp, 14, this.packet.data, 5, h264Length -= 2);
                this.packet.length = 5 + h264Length;
                this.packet.data[3] = 1;
                this.packet.data[4] = (byte)(nri + fu_type);
                this.lastseqnum = thisseqnum;
            } else {
                if (this.packet.length == 0) {
                    JFLog.log(this.log, "Error : H264 : partial packet received before first packet : seq=" + thisseqnum);
                    this.lastseqnum = -1;
                    this.packet.length = 0;
                    return;
                }
                if (thisseqnum != this.nextseqnum()) {
                    JFLog.log(this.log, "Error : H264 : Received FU packet out of order, discarding frame : seq=" + thisseqnum);
                    this.lastseqnum = -1;
                    this.packet.length = 0;
                    return;
                }
                this.lastseqnum = thisseqnum;
                System.arraycopy(rtp, 14, this.packet.data, this.packet.length, h264Length -= 2);
                this.packet.length += h264Length;
                if (last) {
                    if (debug) {
                        this.log(this.packet);
                    }
                    pr.onPacket(this.packet);
                    this.packet.length = 0;
                }
            }
        } else {
            JFLog.log(this.log, "H264:Unsupported packet type:" + type);
            this.lastseqnum = -1;
            this.packet.length = 0;
        }
    }

    private int nextseqnum() {
        if (this.lastseqnum == 65535) {
            return 0;
        }
        return this.lastseqnum + 1;
    }

    private static byte get_fu_type(byte[] rtp, int offset) {
        return (byte)(rtp[offset] & 0x1F);
    }

    public static byte get_nal_type(byte[] packet, int offset) {
        return (byte)(packet[offset] & 0x1F);
    }

    public boolean isKeyFrame(byte type) {
        return type == 5;
    }

    public boolean isIFrame(byte type) {
        return type == 1;
    }

    public boolean isFrame(byte type) {
        return type == 5 || type == 1;
    }

    public boolean isStart(byte type) {
        return type == 7;
    }

    public static boolean canDecodePacket(byte type) {
        switch (type) {
            case 1: 
            case 5: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public static CodecInfo getCodecInfo(Packet sps) {
        MediaVideoDecoder decoder = new MediaVideoDecoder();
        decoder.start(27, 320, 200);
        decoder.decode(sps.data, sps.offset, sps.length);
        CodecInfo info = new CodecInfo();
        info.width = decoder.getWidth();
        info.height = decoder.getHeight();
        info.fps = decoder.getFrameRate();
        decoder.stop();
        return info;
    }

    private void log(Packet packet) {
        JFLog.log(String.format("H264:%x,%x", packet.data[4], packet.data[5]));
    }
}

