/*
 * Decompiled with CFR 0.152.
 */
package javaforce.gl;

import javaforce.gl.Quaternion;
import javaforce.gl.Vector3;
import javaforce.gl.Vector4;

public class Matrix
implements Cloneable {
    public float[] m = new float[16];
    private float[] r;
    private Matrix mat;
    private Vector3 vec;

    public Matrix() {
        this.setIdentity();
        this.mat = new Matrix(false);
        this.vec = new Vector3();
        this.r = new float[16];
    }

    private Matrix(boolean dummy) {
        this.setIdentity();
    }

    public Object clone() {
        Matrix cln = new Matrix();
        for (int a = 0; a < 16; ++a) {
            cln.m[a] = this.m[a];
        }
        return cln;
    }

    public void setIdentity() {
        for (int a = 0; a < 16; ++a) {
            this.m[a] = a % 5 == 0 ? 1.0f : 0.0f;
        }
    }

    public void setIdentity3x3() {
        for (int a = 0; a < 11; ++a) {
            this.m[a] = a % 5 == 0 ? 1.0f : 0.0f;
        }
    }

    public void set(Matrix src) {
        for (int a = 0; a < 16; ++a) {
            this.m[a] = src.m[a];
        }
    }

    public void setAA(float angle, float x, float y, float z) {
        float mag;
        float s = (float)Math.sin(angle * (float)Math.PI / 180.0f);
        float c = (float)Math.cos(angle * (float)Math.PI / 180.0f);
        this.setIdentity();
        if (x == 0.0f) {
            if (y == 0.0f) {
                if (z != 0.0f) {
                    this.m[0] = c;
                    this.m[5] = c;
                    if ((double)z < 0.0) {
                        this.m[4] = s;
                        this.m[1] = -s;
                    } else {
                        this.m[4] = -s;
                        this.m[1] = s;
                    }
                    return;
                }
            } else if (z == 0.0f) {
                this.m[0] = c;
                this.m[10] = c;
                if ((double)y < 0.0) {
                    this.m[8] = -s;
                    this.m[2] = s;
                } else {
                    this.m[8] = s;
                    this.m[2] = -s;
                }
                return;
            }
        } else if (y == 0.0f && z == 0.0f) {
            this.m[5] = c;
            this.m[10] = c;
            if ((double)x < 0.0) {
                this.m[9] = s;
                this.m[6] = -s;
            } else {
                this.m[9] = -s;
                this.m[6] = s;
            }
            return;
        }
        if ((mag = (float)Math.sqrt(x * x + y * y + z * z)) <= 1.0E-4f) {
            return;
        }
        float xx = (x /= mag) * x;
        float yy = (y /= mag) * y;
        float zz = (z /= mag) * z;
        float xy = x * y;
        float yz = y * z;
        float zx = z * x;
        float xs = x * s;
        float ys = y * s;
        float zs = z * s;
        float one_c = 1.0f - c;
        this.m[0] = one_c * xx + c;
        this.m[4] = one_c * xy - zs;
        this.m[8] = one_c * zx + ys;
        this.m[1] = one_c * xy + zs;
        this.m[5] = one_c * yy + c;
        this.m[9] = one_c * yz - xs;
        this.m[2] = one_c * zx - ys;
        this.m[6] = one_c * yz + xs;
        this.m[10] = one_c * zz + c;
    }

    public void set(Quaternion q) {
        float x = q.x;
        float y = q.y;
        float z = q.z;
        float w = q.w;
        float x2 = x + x;
        float y2 = y + y;
        float z2 = z + z;
        float xx = x * x2;
        float xy = x * y2;
        float xz = x * z2;
        float yy = y * y2;
        float yz = y * z2;
        float zz = z * z2;
        float wx = w * x2;
        float wy = w * y2;
        float wz = w * z2;
        float sx = 1.0f;
        float sy = 1.0f;
        float sz = 1.0f;
        this.m[0] = (1.0f - (yy + zz)) * sx;
        this.m[1] = (xy + wz) * sx;
        this.m[2] = (xz - wy) * sx;
        this.m[3] = 0.0f;
        this.m[4] = (xy - wz) * sy;
        this.m[5] = (1.0f - (xx + zz)) * sy;
        this.m[6] = (yz + wx) * sy;
        this.m[7] = 0.0f;
        this.m[8] = (xz + wy) * sz;
        this.m[9] = (yz - wx) * sz;
        this.m[10] = (1.0f - (xx + yy)) * sz;
        this.m[11] = 0.0f;
        this.m[12] = 0.0f;
        this.m[13] = 0.0f;
        this.m[14] = 0.0f;
        this.m[15] = 1.0f;
    }

    public void setAATranslate(float angle, float x, float y, float z, float tx, float ty, float tz) {
        this.setAA(angle, x, y, z);
        this.addTranslate(tx, ty, tz);
    }

    public void setTranslate(float x, float y, float z) {
        this.setIdentity();
        this.m[12] = x;
        this.m[13] = y;
        this.m[14] = z;
    }

    public void setScale(float x, float y, float z) {
        this.setIdentity();
        this.m[0] = x;
        this.m[5] = y;
        this.m[10] = z;
    }

    public void addRotate(float angle, float ax, float ay, float az) {
        this.mat.setAA(angle, ax, ay, az);
        this.mult3x3(this.mat);
    }

    public void addRotate2(float angle, float ax, float ay, float az) {
        this.mat.setAA(angle, ax, ay, az);
        this.mult4x4(this.mat);
    }

    public void addRotate3(float angle, float ax, float ay, float az) {
        this.vec.v[0] = ax;
        this.vec.v[1] = ay;
        this.vec.v[2] = az;
        this.mult(this.vec);
        this.mat.setAA(angle, this.vec.v[0], this.vec.v[1], this.vec.v[2]);
        this.mult3x3(this.mat);
    }

    public void addRotate4(float angle, float ax, float ay, float az) {
        this.vec.v[0] = ax;
        this.vec.v[1] = ay;
        this.vec.v[2] = az;
        this.mult(this.vec);
        this.mat.setAA(angle, this.vec.v[0], this.vec.v[1], this.vec.v[2]);
        this.mult4x4(this.mat);
    }

    public void addTranslate(float tx, float ty, float tz) {
        this.m[12] = this.m[12] + tx;
        this.m[13] = this.m[13] + ty;
        this.m[14] = this.m[14] + tz;
    }

    public void addTranslate(Matrix src) {
        this.addTranslate(src.m[12], src.m[13], src.m[14]);
    }

    public void addTranslate2(float tx, float ty, float tz) {
        this.mat.setTranslate(tx, ty, tz);
        this.mult4x4(this.mat);
    }

    public void addScale(float sx, float sy, float sz) {
        this.mat.setScale(sx, sy, sz);
        this.mult4x4(this.mat);
    }

    public void mult4x4(Matrix src) {
        for (int col = 0; col < 4; ++col) {
            float a0 = this.m[col + 0];
            float a1 = this.m[col + 4];
            float a2 = this.m[col + 8];
            float a3 = this.m[col + 12];
            this.r[col + 0] = a0 * src.m[0] + a1 * src.m[1] + a2 * src.m[2] + a3 * src.m[3];
            this.r[col + 4] = a0 * src.m[4] + a1 * src.m[5] + a2 * src.m[6] + a3 * src.m[7];
            this.r[col + 8] = a0 * src.m[8] + a1 * src.m[9] + a2 * src.m[10] + a3 * src.m[11];
            this.r[col + 12] = a0 * src.m[12] + a1 * src.m[13] + a2 * src.m[14] + a3 * src.m[15];
        }
        float[] x = this.m;
        this.m = this.r;
        this.r = x;
    }

    public void mult3x3(Matrix src) {
        for (int i = 0; i < 3; ++i) {
            float a0 = this.m[i + 0];
            float a1 = this.m[i + 4];
            float a2 = this.m[i + 8];
            this.r[i + 0] = a0 * src.m[0] + a1 * src.m[1] + a2 * src.m[2];
            this.r[i + 4] = a0 * src.m[4] + a1 * src.m[5] + a2 * src.m[6];
            this.r[i + 8] = a0 * src.m[8] + a1 * src.m[9] + a2 * src.m[10];
        }
        for (int a = 0; a < 4; ++a) {
            this.r[a + 12] = this.m[a + 12];
        }
        float[] x = this.m;
        this.m = this.r;
        this.r = x;
    }

    public void mult(Matrix src) {
        this.mult3x3(src);
    }

    public void mult(Vector3 dest) {
        float nx = this.m[0] * dest.v[0] + this.m[1] * dest.v[1] + this.m[2] * dest.v[2];
        float ny = this.m[4] * dest.v[0] + this.m[5] * dest.v[1] + this.m[6] * dest.v[2];
        float nz = this.m[8] * dest.v[0] + this.m[9] * dest.v[1] + this.m[10] * dest.v[2];
        dest.v[0] = nx;
        dest.v[1] = ny;
        dest.v[2] = nz;
    }

    public void mult(Vector4 dest) {
        float nx = this.m[0] * dest.v[0] + this.m[1] * dest.v[1] + this.m[2] * dest.v[2] + this.m[3] * dest.v[3];
        float ny = this.m[4] * dest.v[0] + this.m[5] * dest.v[1] + this.m[6] * dest.v[2] + this.m[7] * dest.v[3];
        float nz = this.m[8] * dest.v[0] + this.m[9] * dest.v[1] + this.m[10] * dest.v[2] + this.m[11] * dest.v[3];
        float nw = this.m[12] * dest.v[0] + this.m[13] * dest.v[1] + this.m[14] * dest.v[2] + this.m[15] * dest.v[3];
        dest.v[0] = nx;
        dest.v[1] = ny;
        dest.v[2] = nz;
        dest.v[3] = nw;
    }

    public float get(int i, int j) {
        return this.m[j + i * 4];
    }

    public void set(int i, int j, float v) {
        this.m[j + i * 4] = v;
    }

    public void transpose() {
        float t = this.get(0, 1);
        this.set(0, 1, this.get(1, 0));
        this.set(1, 0, t);
        t = this.get(0, 2);
        this.set(0, 2, this.get(2, 0));
        this.set(2, 0, t);
        t = this.get(1, 2);
        this.set(1, 2, this.get(2, 1));
        this.set(2, 1, t);
    }

    public float determinant() {
        return this.get(0, 0) * (this.get(1, 1) * this.get(2, 2) - this.get(2, 1) * this.get(1, 2)) + this.get(0, 1) * (this.get(2, 0) * this.get(1, 2) - this.get(1, 0) * this.get(2, 2)) + this.get(0, 2) * (this.get(1, 0) * this.get(2, 1) - this.get(2, 0) * this.get(1, 1));
    }

    public boolean invert() {
        float det = this.determinant();
        if (det == 0.0f) {
            return false;
        }
        this.mat.set(0, 0, this.get(1, 1) * this.get(2, 2) - this.get(2, 1) * this.get(1, 2));
        this.mat.set(0, 1, this.get(2, 0) * this.get(1, 2) - this.get(1, 0) * this.get(2, 2));
        this.mat.set(0, 2, this.get(1, 0) * this.get(2, 1) - this.get(2, 0) * this.get(1, 1));
        this.mat.set(1, 0, this.get(2, 1) * this.get(0, 2) - this.get(0, 1) * this.get(2, 2));
        this.mat.set(1, 1, this.get(0, 0) * this.get(2, 2) - this.get(2, 0) * this.get(0, 2));
        this.mat.set(1, 2, this.get(2, 0) * this.get(0, 1) - this.get(0, 0) * this.get(2, 1));
        this.mat.set(2, 0, this.get(0, 1) * this.get(1, 2) - this.get(1, 1) * this.get(0, 2));
        this.mat.set(2, 1, this.get(1, 0) * this.get(0, 2) - this.get(0, 0) * this.get(1, 2));
        this.mat.set(2, 2, this.get(0, 0) * this.get(1, 1) - this.get(1, 0) * this.get(0, 1));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.set(i, j, this.mat.get(j, i) / det);
            }
        }
        return true;
    }

    public void reverseTranslate() {
        this.m[12] = this.m[12] * -1.0f;
        this.m[13] = this.m[13] * -1.0f;
        this.m[14] = this.m[14] * -1.0f;
    }

    public void frustum(float left, float right, float bottom, float top, float znear, float zfar) {
        float temp = 2.0f * znear;
        float temp2 = right - left;
        float temp3 = top - bottom;
        float temp4 = zfar - znear;
        this.m[0] = temp / temp2;
        this.m[1] = 0.0f;
        this.m[2] = 0.0f;
        this.m[3] = 0.0f;
        this.m[4] = 0.0f;
        this.m[5] = temp / temp3;
        this.m[6] = 0.0f;
        this.m[7] = 0.0f;
        this.m[8] = (right + left) / temp2;
        this.m[9] = (top + bottom) / temp3;
        this.m[10] = (-zfar - znear) / temp4;
        this.m[11] = -1.0f;
        this.m[12] = 0.0f;
        this.m[13] = 0.0f;
        this.m[14] = -temp * zfar / temp4;
        this.m[15] = 0.0f;
    }

    private float degToRad(float x) {
        return (float)((double)x * (Math.PI / 180));
    }

    public void perspective(float fovyInDegrees, float aspectRatio, float znear, float zfar) {
        float ymax = (float)((double)znear * Math.tan(this.degToRad(fovyInDegrees) / 2.0f));
        float xmax = ymax * aspectRatio;
        this.frustum(-xmax, xmax, -ymax, ymax, znear, zfar);
    }

    public void ortho(float left, float right, float bottom, float top, float near, float far) {
        float w = right - left;
        float h = top - bottom;
        float d = far - near;
        this.m[0] = 2.0f / w;
        this.m[1] = 0.0f;
        this.m[2] = 0.0f;
        this.m[3] = 0.0f;
        this.m[4] = 0.0f;
        this.m[5] = 2.0f / h;
        this.m[6] = 0.0f;
        this.m[7] = 0.0f;
        this.m[8] = 0.0f;
        this.m[9] = 0.0f;
        this.m[10] = -2.0f / d;
        this.m[11] = 0.0f;
        this.m[12] = -(left + right) / w;
        this.m[13] = -(top + bottom) / h;
        this.m[14] = -(far + near) / d;
        this.m[15] = 1.0f;
    }

    public void lookAt(Vector3 eye, Vector3 at, Vector3 up) {
        at.v[0] = at.v[0] - eye.v[0];
        at.v[1] = at.v[1] - eye.v[1];
        at.v[2] = at.v[2] - eye.v[2];
        at.normalize();
        this.vec.cross(at, up);
        this.vec.normalize();
        up.cross(this.vec, at);
        at.scale(-1.0f);
        this.m[0] = this.vec.v[0];
        this.m[1] = this.vec.v[1];
        this.m[2] = this.vec.v[2];
        this.m[3] = 0.0f;
        this.m[4] = up.v[0];
        this.m[5] = up.v[1];
        this.m[6] = up.v[2];
        this.m[7] = 0.0f;
        this.m[8] = at.v[0];
        this.m[9] = at.v[1];
        this.m[10] = at.v[2];
        this.m[11] = 0.0f;
        this.m[12] = eye.v[0];
        this.m[13] = eye.v[1];
        this.m[14] = eye.v[2];
        this.m[15] = 1.0f;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int a = 0; a < 16; a += 4) {
            if (a > 0) {
                sb.append(",");
            }
            sb.append(String.format("%.3f,%.3f,%.3f,%.3f", Float.valueOf(this.m[a + 0]), Float.valueOf(this.m[a + 1]), Float.valueOf(this.m[a + 2]), Float.valueOf(this.m[a + 3])));
        }
        sb.append("]");
        return sb.toString();
    }
}

