/*
 * Decompiled with CFR 0.152.
 */
package javaforce.gl;

import java.util.ArrayList;
import java.util.HashMap;
import javaforce.JFArrayFloat;
import javaforce.JFArrayInt;
import javaforce.gl.GL;
import javaforce.gl.Matrix;
import javaforce.gl.Model;
import javaforce.gl.Rotate3;
import javaforce.gl.Scale3;
import javaforce.gl.Scene;
import javaforce.gl.Translate3;
import javaforce.gl.UVMap;
import javaforce.gl.Vertex3;

public class Object3
implements Cloneable {
    public JFArrayFloat vpl;
    public JFArrayInt vil;
    public int vpb = -1;
    public int vib = -1;
    public int type = 4;
    public ArrayList<UVMap> maps = new ArrayList();
    public boolean visible = true;
    public boolean needCopyBuffers = true;
    public HashMap<Integer, Translate3> tl;
    public HashMap<Integer, Rotate3> rl;
    public HashMap<Integer, Scale3> sl;
    public int frameIndex = 0;
    public Matrix m;
    public float[] color;
    public Vertex3 org;
    public String name;
    public int parent;
    public int maxframeCount;

    public Object3() {
        this.vpl = new JFArrayFloat();
        this.vil = new JFArrayInt();
        this.tl = new HashMap();
        this.rl = new HashMap();
        this.sl = new HashMap();
        this.color = new float[4];
        for (int a = 0; a < 4; ++a) {
            this.color[a] = 1.0f;
        }
        this.visible = true;
        this.org = new Vertex3();
        this.parent = -1;
        this.maxframeCount = 0;
        this.m = new Matrix();
    }

    public Object clone() {
        Object3 cln = new Object3();
        cln.vpl = this.vpl;
        cln.vil = this.vil;
        cln.maps = this.maps;
        cln.visible = this.visible;
        cln.tl = this.tl;
        cln.rl = this.rl;
        cln.sl = this.sl;
        cln.frameIndex = this.frameIndex;
        cln.m = (Matrix)this.m.clone();
        cln.color = new float[4];
        for (int a = 0; a < 4; ++a) {
            cln.color[a] = this.color[a];
        }
        cln.org = this.org;
        cln.parent = this.parent;
        cln.maxframeCount = this.maxframeCount;
        cln.type = this.type;
        return cln;
    }

    public void setVisible(boolean state) {
        this.visible = state;
    }

    public void addRotate(float angle, float x, float y, float z, Vertex3 org) {
        Matrix tmp = new Matrix();
        tmp.setAA(angle, x, y, z);
        tmp.addTranslate(org.x, org.y, org.z);
        this.m.mult4x4(tmp);
        tmp.setIdentity3x3();
        tmp.reverseTranslate();
        this.m.mult4x4(tmp);
    }

    public void addTranslate(float x, float y, float z) {
        this.m.addTranslate(x, y, z);
    }

    public void addScale(float x, float y, float z) {
        this.m.addScale(x, y, z);
    }

    public void setFrame(int idx) {
        Scale3 _s;
        Rotate3 _r;
        this.frameIndex = idx;
        if (idx == 0) {
            this.m.setIdentity();
            return;
        }
        Translate3 _t = this.tl.get(idx);
        if (_t != null) {
            this.addTranslate(_t.x - this.org.x, _t.y - this.org.y, _t.z - this.org.z);
        }
        if ((_r = this.rl.get(idx)) != null) {
            this.addRotate(_r.angle, _r.x, _r.y, _r.z, this.org);
        }
        if ((_s = this.sl.get(idx)) != null) {
            this.addScale(_s.x, _s.y, _s.z);
        }
    }

    public void nextFrame() {
        this.setFrame(this.frameIndex + 1);
    }

    public int frameCount() {
        return this.maxframeCount;
    }

    public void addVertex(float[] xyz) {
        this.vpl.append(xyz);
    }

    public void addVertex(float[] xyz, float[] uv) {
        this.vpl.append(xyz);
        this.maps.get((int)0).uvl.append(uv);
    }

    public void addVertex(float[] xyz, float[] uv1, float[] uv2) {
        this.vpl.append(xyz);
        this.maps.get((int)0).uvl.append(uv1);
        this.maps.get((int)1).uvl.append(uv2);
    }

    public void addVertex(Vertex3 v) {
        this.vpl.append(v.x);
        this.vpl.append(v.y);
        this.vpl.append(v.z);
        UVMap map = this.maps.get(0);
        map.uvl.append(v.u);
        map.uvl.append(v.v);
    }

    public int getVertexCount() {
        return this.vpl.size() / 3;
    }

    public void addText(float[] uv) {
        this.maps.get(0).addText(uv);
    }

    public void addText(float[] uv, int map) {
        this.maps.get(map).addText(uv);
    }

    public void addPoly(int[] pts) {
        this.vil.append(pts);
    }

    public void copyBuffers() {
        int[] ids = new int[1];
        if (this.vpb == -1) {
            GL.glGenBuffers(1, ids);
            this.vpb = ids[0];
        }
        GL.glBindBuffer(34962, this.vpb);
        GL.glBufferData(34962, this.vpl.size() * 4, this.vpl.toArray(), 35044);
        for (int a = 0; a < this.maps.size(); ++a) {
            this.maps.get(a).copyBuffers();
        }
        if (this.vib == -1) {
            GL.glGenBuffers(1, ids);
            this.vib = ids[0];
        }
        GL.glBindBuffer(34963, this.vib);
        GL.glBufferData(34963, this.vil.size() * 4, this.vil.toArray(), 35040);
        this.needCopyBuffers = false;
    }

    public void bindBuffers(Scene scene) {
        GL.glBindBuffer(34962, this.vpb);
        GL.glVertexAttribPointer(scene.vpa, 3, 5126, 0, 0, 0);
        for (int m = 0; m < this.maps.size(); ++m) {
            this.maps.get(m).bindBuffers(scene);
        }
        GL.glBindBuffer(34963, this.vib);
    }

    public void render(Scene scene) {
        if (this.vpl.size() == 0 || this.vil.size() == 0) {
            return;
        }
        int uvcnt = this.maps.size();
        GL.glUniform1i(scene.uUVMaps, uvcnt);
        GL.glEnableVertexAttribArray(scene.tca[0]);
        if (uvcnt > 1) {
            GL.glEnableVertexAttribArray(scene.tca[1]);
        } else {
            GL.glDisableVertexAttribArray(scene.tca[1]);
        }
        GL.glDrawElements(this.type, this.vil.size(), 5125, 0);
    }

    public void freeBuffers() {
        int[] ids = new int[1];
        if (this.vpb != -1) {
            ids[0] = this.vpb;
            GL.glDeleteBuffers(1, ids);
            this.vpb = -1;
        }
        if (this.vib != -1) {
            ids[0] = this.vib;
            GL.glDeleteBuffers(1, ids);
            this.vib = -1;
        }
        for (int m = 0; m < this.maps.size(); ++m) {
            this.maps.get(m).freeBuffers();
        }
    }

    public UVMap createUVMap() {
        UVMap map = new UVMap(this.maps.size());
        this.maps.add(map);
        return map;
    }

    public UVMap getUVMap(int idx) {
        return this.maps.get(idx);
    }

    public UVMap getUVMap(String name) {
        for (int a = 0; a < this.maps.size(); ++a) {
            UVMap map = this.maps.get(a);
            if (!map.name.equals(name)) continue;
            return map;
        }
        return null;
    }

    public int getUVMaps() {
        return this.maps.size();
    }

    public void print(Model model) {
        System.out.println("Object:" + this.name);
        float[] vp = this.vpl.toArray();
        int a = 0;
        while (a < vp.length) {
            System.out.println(String.format("v[%d]=%6.3f,%6.3f,%6.3f", a / 3, Float.valueOf(vp[a++]), Float.valueOf(vp[a++]), Float.valueOf(vp[a++])));
        }
        int[] vi = this.vil.toArray();
        int a2 = 0;
        while (a2 < vi.length) {
            switch (this.type) {
                case 4: {
                    System.out.println(String.format("i[%d]=%d,%d,%d", a2 / 3, vi[a2++], vi[a2++], vi[a2++]));
                    break;
                }
                case 7: {
                    System.out.println(String.format("i[%d]=%d,%d,%d,%d", a2 / 4, vi[a2++], vi[a2++], vi[a2++], vi[a2++]));
                }
            }
        }
        for (int m = 0; m < this.maps.size(); ++m) {
            UVMap map = this.maps.get(m);
            System.out.println("UVMap:" + map.name + ",texture=" + model.textures.get(map.textureIndex));
            float[] uv = map.uvl.toArray();
            int a3 = 0;
            while (a3 < uv.length) {
                System.out.println(String.format("uv[%d]=%6.3f,%6.3f", a3 / 2, Float.valueOf(uv[a3++]), Float.valueOf(uv[a3++])));
            }
        }
    }
}

