/*
 * Decompiled with CFR 0.152.
 */
package javaforce.ui;

import javaforce.ui.Dimension;
import javaforce.ui.FontMetrics;
import javaforce.ui.Image;
import javaforce.ui.ToggleButton;

public class CheckBox
extends ToggleButton {
    public CheckBox(String text) {
        super(text);
    }

    @Override
    public Dimension getMinSize() {
        FontMetrics metrics = this.getFont().getMetrics(this.getText());
        int w = metrics.getWidth() + 16 + 7;
        int h = metrics.getHeight();
        if (h < 16) {
            h = 16;
        }
        return new Dimension(w, h += 8);
    }

    @Override
    public void render(Image image) {
        int x = this.pos.x;
        int y = this.pos.y;
        int w = this.size.width;
        int h = this.size.height;
        if (w == 0 || h == 0) {
            return;
        }
        if (this.isEnabled()) {
            image.setForeColor(this.getForeColor());
        } else {
            image.setForeColor(this.getDisabledColor());
        }
        if (this.isFocused()) {
            image.setLineStyle(2);
            image.drawBox(x + 1, y + 1, w - 2, h - 2);
        }
        image.setLineStyle(1);
        image.drawBox((x += 3) + 0, (y += (this.getHeight() - 16) / 2) + 0, 16, 16);
        if (this.isSelected()) {
            image.drawLine(x + 0, y + 8, x + 7, y + 15);
            image.drawLine(x + 7, y + 15, x + 15, y + 0);
        }
        this.renderText(image, 20, 3);
    }
}

