/*
 * Decompiled with CFR 0.152.
 */
package javaforce.voip;

import java.net.InetAddress;
import java.util.Random;
import javaforce.BE;
import javaforce.JFLog;
import javaforce.media.AudioBuffer;
import javaforce.voip.Codec;
import javaforce.voip.DTMF;
import javaforce.voip.MusicOnHold;
import javaforce.voip.RTP;
import javaforce.voip.RTPAudioCoder;
import javaforce.voip.SDP;
import javaforce.voip.g711a;
import javaforce.voip.g711u;
import javaforce.voip.g722;
import javaforce.voip.g729a;
import javaforce.voip.gsm;
import javaforce.voip.speex;

public class RTPChannel {
    private int seqnum = 0;
    private int timestamp = 0;
    protected int ssrc_src = -1;
    protected int ssrc_dst = -1;
    private static Random r = new Random();
    private static Object rlock = new Object();
    private short dtmfduration = 0;
    protected short turn1ch;
    protected short turn2ch;
    private int rfc2833_id = -1;
    private int speex_id = -1;
    private int vp8_id = -1;
    private int vp9_id = -1;
    private int h263_1998_id = -1;
    private int h263_2000_id = -1;
    private int h264_id = -1;
    private int h265_id = -1;
    private char dtmfChar;
    private boolean dtmfSent = false;
    private AudioBuffer buffer = new AudioBuffer(32000, 1, 2);
    private DTMF dtmf;
    private static short[] silence8 = new short[160];
    private static short[] silence16 = new short[320];
    protected long turnBindExpires;
    private long lastPacket = 0L;
    protected boolean active = false;
    private MusicOnHold moh = new MusicOnHold();
    public RTP rtp;
    public SDP.Stream stream;
    public RTPAudioCoder coder;
    public int log;
    public static boolean debug = false;

    protected RTPChannel(RTP rtp, int ssrc, SDP.Stream stream) {
        this.rtp = rtp;
        this.ssrc_src = ssrc;
        this.stream = stream;
    }

    public void setLog(int id) {
        this.log = id;
    }

    public int getVP8id() {
        return this.vp8_id;
    }

    public int getVP9id() {
        return this.vp9_id;
    }

    public int getH264id() {
        return this.h264_id;
    }

    public int getH265id() {
        return this.h265_id;
    }

    public int getH263_1998id() {
        return this.h263_1998_id;
    }

    public int getH263_2000id() {
        return this.h263_2000_id;
    }

    public int getRFC2833id() {
        return this.rfc2833_id;
    }

    public void writeRTP(byte[] data, int off, int len) {
        if (!this.rtp.active) {
            JFLog.log(this.log, "RTPChannel.writeRTP() : not active");
            return;
        }
        if (this.stream.getPort() == -1) {
            JFLog.log(this.log, "RTPChannel.writeRTP() : not ready (NATing)");
            return;
        }
        if (!this.stream.canSend()) {
            JFLog.log(this.log, "RTPChannel.writeRTP() : stream without send");
            return;
        }
        if (debug) {
            JFLog.log("RTPChannel.writeRTP:" + this.stream.getIP() + ":" + this.stream.getPort());
        }
        try {
            if (RTP.useTURN) {
                this.rtp.stun1.sendData(this.turn1ch, data, off, len);
            } else {
                this.rtp.sock1.send(data, off, len, InetAddress.getByName(this.stream.getIP()), this.stream.getPort());
            }
        }
        catch (Exception e) {
            JFLog.log(this.log, (Throwable)e);
        }
    }

    public void writeRTCP(byte[] data, int off, int len) {
        if (!this.rtp.active) {
            return;
        }
        if (this.stream.getPort() == -1) {
            return;
        }
        try {
            if (RTP.useTURN) {
                this.rtp.stun2.sendData(this.turn2ch, data, off, len);
            } else {
                this.rtp.sock2.send(data, off, len, InetAddress.getByName(this.stream.getIP()), this.stream.getPort() + 1);
            }
        }
        catch (Exception e) {
            JFLog.log(this.log, "err:RTP.writeRTCP:failed");
            JFLog.log(this.log, (Throwable)e);
        }
    }

    public void writeDTMF(char digit, boolean end) {
        byte[] data = new byte[16];
        RTPChannel.buildHeader(data, RTP.CODEC_RFC2833.id, this.getseqnum(), this.gettimestamp(160), this.getssrc(), false);
        switch (digit) {
            case '*': {
                data[12] = 10;
                break;
            }
            case '#': {
                data[12] = 11;
                break;
            }
            default: {
                data[12] = (byte)(digit - 48);
            }
        }
        data[13] = end ? -118 : 10;
        data[14] = (byte)((this.dtmfduration & 0xFF00) >> 8);
        data[15] = (byte)(this.dtmfduration & 0xFF);
        this.dtmfduration = (short)(this.dtmfduration + 160);
        this.writeRTP(data, 0, data.length);
        if (end) {
            this.writeRTP(data, 0, data.length);
            this.writeRTP(data, 0, data.length);
            this.dtmfduration = 0;
        }
    }

    public static void buildHeader(byte[] data, int id, int seqnum, int timestamp, int ssrc, boolean last) {
        data[0] = -128;
        data[1] = (byte)id;
        if (last) {
            data[1] = (byte)(data[1] | 0x80);
        }
        BE.setuint16(data, 2, seqnum);
        BE.setuint32(data, 4, timestamp);
        BE.setuint32(data, 8, ssrc);
    }

    public void buildHeader(byte[] data, int type) {
        RTPChannel.buildHeader(data, type, 0, 0, this.getssrc(), false);
    }

    public int getseqnum() {
        return this.seqnum++;
    }

    public int gettimestamp(int delta) {
        int ret = this.timestamp;
        this.timestamp += delta;
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getssrc() {
        if (this.ssrc_src != -1) {
            return this.ssrc_src;
        }
        Object object = rlock;
        synchronized (object) {
            this.ssrc_src = r.nextInt() & Integer.MAX_VALUE;
        }
        return this.ssrc_src;
    }

    public static int getseqnum(byte[] data, int off) {
        return BE.getuint16(data, 2 + off);
    }

    public static int gettimestamp(byte[] data, int off) {
        return BE.getuint32(data, 4 + off);
    }

    public static int getssrc(byte[] data, int off) {
        return BE.getuint32(data, 8 + off);
    }

    public String getremoteip() {
        if (RTP.useTURN) {
            return this.rtp.stun1.getIP();
        }
        return this.stream.getIP();
    }

    public int getremoteport() {
        return this.stream.getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean start() {
        Object codec_rfc2833;
        this.lastPacket = System.currentTimeMillis();
        JFLog.log(this.log, "RTPChannel.start() : localhost:" + this.rtp.getlocalrtpport() + " remote=" + this.stream.getIP() + ":" + this.stream.getPort());
        if (this.stream.codecs != null && this.stream.codecs.length > 0) {
            Codec codec_speex32;
            Codec codec_speex16;
            Codec codec_speex;
            Codec codec_h263_2000;
            Codec codec_h263_1998;
            Codec codec_h265;
            Codec codec_h264;
            Codec codec_vp9;
            Codec codec_vp8;
            codec_rfc2833 = this.stream.getCodec(RTP.CODEC_RFC2833);
            if (codec_rfc2833 != null) {
                this.rfc2833_id = ((Codec)codec_rfc2833).id;
            }
            if ((codec_vp8 = this.stream.getCodec(RTP.CODEC_VP8)) != null) {
                this.vp8_id = codec_vp8.id;
            }
            if ((codec_vp9 = this.stream.getCodec(RTP.CODEC_VP9)) != null) {
                this.vp9_id = codec_vp9.id;
            }
            if ((codec_h264 = this.stream.getCodec(RTP.CODEC_H264)) != null) {
                this.h264_id = codec_h264.id;
            }
            if ((codec_h265 = this.stream.getCodec(RTP.CODEC_H265)) != null) {
                this.h265_id = codec_h265.id;
            }
            if ((codec_h263_1998 = this.stream.getCodec(RTP.CODEC_H263_1998)) != null) {
                this.h263_1998_id = codec_h263_1998.id;
            }
            if ((codec_h263_2000 = this.stream.getCodec(RTP.CODEC_H263_2000)) != null) {
                this.h263_2000_id = codec_h263_2000.id;
            }
            if ((codec_speex = this.stream.getCodec(RTP.CODEC_SPEEX)) != null) {
                this.speex_id = codec_speex.id;
            }
            if ((codec_speex16 = this.stream.getCodec(RTP.CODEC_SPEEX16)) != null) {
                this.speex_id = codec_speex16.id;
            }
            if ((codec_speex32 = this.stream.getCodec(RTP.CODEC_SPEEX32)) != null) {
                this.speex_id = codec_speex32.id;
            }
            if (this.stream.type == SDP.Type.audio) {
                this.coder = null;
                for (int a = 0; a < this.stream.codecs.length; ++a) {
                    Codec codec = this.stream.codecs[a];
                    if (codec.equals(RTP.CODEC_G711u)) {
                        this.coder = new g711u(this.rtp);
                        JFLog.log(this.log, "codec = g711u");
                        break;
                    }
                    if (codec.equals(RTP.CODEC_G711a)) {
                        this.coder = new g711a(this.rtp);
                        JFLog.log(this.log, "codec = g711a");
                        break;
                    }
                    if (codec.equals(RTP.CODEC_GSM)) {
                        this.coder = new gsm(this.rtp);
                        JFLog.log(this.log, "codec = gsm");
                        break;
                    }
                    if (codec.equals(RTP.CODEC_G722)) {
                        this.coder = new g722(this.rtp);
                        JFLog.log(this.log, "codec = g722");
                        break;
                    }
                    if (codec.equals(RTP.CODEC_G729a)) {
                        this.coder = new g729a(this.rtp);
                        JFLog.log(this.log, "codec = g729a");
                        break;
                    }
                    if (codec.equals(RTP.CODEC_SPEEX)) {
                        this.coder = new speex(this.rtp, codec.rate);
                        this.coder.setid(codec.id);
                        JFLog.log(this.log, "codec = speex");
                        break;
                    }
                    if (codec.equals(RTP.CODEC_SPEEX16)) {
                        this.coder = new speex(this.rtp, codec.rate);
                        this.coder.setid(codec.id);
                        JFLog.log(this.log, "codec = speex16");
                        break;
                    }
                    if (!codec.equals(RTP.CODEC_SPEEX32)) continue;
                    this.coder = new speex(this.rtp, codec.rate);
                    this.coder.setid(codec.id);
                    JFLog.log(this.log, "codec = speex32");
                    break;
                }
                if (this.coder == null) {
                    JFLog.log(this.log, "RTP.start() : Warning : no compatible audio codec selected");
                }
                this.dtmf = new DTMF(this.coder.getSampleRate());
            } else {
                boolean haveVcodec = false;
                for (int a = 0; a < this.stream.codecs.length; ++a) {
                    Codec codec = this.stream.codecs[a];
                    if (codec.equals(RTP.CODEC_H263)) {
                        JFLog.log(this.log, "codec = H.263");
                        haveVcodec = true;
                        break;
                    }
                    if (codec.equals(RTP.CODEC_H263_1998)) {
                        JFLog.log(this.log, "codec = H.263-1998");
                        haveVcodec = true;
                        break;
                    }
                    if (codec.equals(RTP.CODEC_H263_2000)) {
                        JFLog.log(this.log, "codec = H.263-2000");
                        haveVcodec = true;
                        break;
                    }
                    if (codec.equals(RTP.CODEC_JPEG)) {
                        JFLog.log(this.log, "codec = JPEG");
                        haveVcodec = true;
                        break;
                    }
                    if (codec.equals(RTP.CODEC_H264)) {
                        JFLog.log(this.log, "codec = H.264");
                        haveVcodec = true;
                        break;
                    }
                    if (codec.equals(RTP.CODEC_H265)) {
                        JFLog.log(this.log, "codec = H.265");
                        haveVcodec = true;
                        break;
                    }
                    if (!codec.equals(RTP.CODEC_VP8)) continue;
                    JFLog.log(this.log, "codec = VP8");
                    haveVcodec = true;
                    break;
                }
                if (!haveVcodec) {
                    JFLog.log(this.log, "RTP.start() : Warning : no compatible video codec selected");
                }
            }
        } else {
            JFLog.log(this.log, "RTP:Error:No codecs provided");
        }
        if (RTP.useTURN) {
            try {
                codec_rfc2833 = this.rtp.bindLock;
                synchronized (codec_rfc2833) {
                    this.rtp.bindingChannel = this;
                    this.turn1ch = this.rtp.getNextTURNChannel();
                    this.rtp.wait4reset();
                    this.rtp.stun1.requestBind(this.turn1ch, this.stream.getIP(), this.stream.getPort());
                    this.rtp.wait4reply();
                    this.turn2ch = this.rtp.getNextTURNChannel();
                    this.rtp.wait4reset();
                    this.rtp.stun2.requestBind(this.turn2ch, this.stream.getIP(), this.stream.getPort() + 1);
                    this.rtp.wait4reply();
                }
            }
            catch (Exception e) {
                JFLog.log(this.log, (Throwable)e);
                return false;
            }
        }
        this.active = true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean change(SDP.Stream new_stream) {
        this.lastPacket = System.currentTimeMillis();
        this.stream = new_stream;
        if (this.stream.type == SDP.Type.audio) {
            if (new_stream.hasCodec(RTP.CODEC_G711u)) {
                this.coder = new g711u(this.rtp);
            } else if (new_stream.hasCodec(RTP.CODEC_G711a)) {
                this.coder = new g711a(this.rtp);
            } else if (new_stream.hasCodec(RTP.CODEC_GSM)) {
                this.coder = new gsm(this.rtp);
            } else if (new_stream.hasCodec(RTP.CODEC_G722)) {
                this.coder = new g722(this.rtp);
            } else if (new_stream.hasCodec(RTP.CODEC_G729a)) {
                this.coder = new g729a(this.rtp);
            } else if (new_stream.hasCodec(RTP.CODEC_SPEEX)) {
                this.coder = new speex(this.rtp, 8000);
            } else if (new_stream.hasCodec(RTP.CODEC_SPEEX16)) {
                this.coder = new speex(this.rtp, 16000);
            } else if (new_stream.hasCodec(RTP.CODEC_SPEEX32)) {
                this.coder = new speex(this.rtp, 32000);
            }
            this.dtmf = new DTMF(this.coder.getSampleRate());
        }
        if (RTP.useTURN) {
            Object object = this.rtp.bindLock;
            synchronized (object) {
                this.rtp.bindingChannel = this;
                this.rtp.stun1.requestBind(this.turn1ch, this.stream.getIP(), this.stream.getPort());
                this.rtp.stun2.requestBind(this.turn2ch, this.stream.getIP(), this.stream.getPort() + 1);
            }
        }
        return true;
    }

    protected void processRTP(byte[] data, int off, int len) {
        this.lastPacket = RTP.now;
        if (this.rtp.rawMode) {
            this.rtp.iface.rtpPacket(this, 0, data, off, len);
            return;
        }
        int id = data[off + 1] & 0x7F;
        if (id < 96) {
            switch (id) {
                case 0: 
                case 3: 
                case 8: 
                case 9: 
                case 18: {
                    this.dtmfSent = false;
                    int packetSize = this.coder.getPacketSize();
                    if (packetSize != -1 && len != packetSize + 12) {
                        JFLog.log(this.log, "RTP:Bad RTP packet length:type=" + this.coder.getClass().getName());
                        break;
                    }
                    this.addSamples(this.coder.decode(data, off, len));
                    this.rtp.iface.rtpSamples(this);
                    break;
                }
                case 26: {
                    this.rtp.iface.rtpPacket(this, 20, data, off, len);
                    break;
                }
                case 34: {
                    this.rtp.iface.rtpPacket(this, 40, data, off, len);
                }
            }
        } else if (id == this.rfc2833_id) {
            this.dtmfChar = (char)32;
            if (data[off + 12] >= 0 && data[off + 12] <= 9) {
                this.dtmfChar = (char)(48 + data[off + 12]);
            }
            if (data[off + 12] == 10) {
                this.dtmfChar = (char)42;
            }
            if (data[off + 12] == 11) {
                this.dtmfChar = (char)35;
            }
            if (data[off + 13] < 0) {
                this.dtmfSent = false;
                this.dtmfChar = (char)32;
            }
            if (this.dtmfChar == ' ') {
                switch (this.coder.getSampleRate()) {
                    case 8000: {
                        this.addSamples(silence8);
                        break;
                    }
                    case 16000: {
                        this.addSamples(silence16);
                    }
                }
            } else {
                this.addSamples(this.dtmf.getSamples(this.dtmfChar));
                if (!this.dtmfSent) {
                    this.rtp.iface.rtpDigit(this, this.dtmfChar);
                    this.dtmfSent = true;
                }
            }
        } else if (id == this.vp8_id) {
            this.rtp.iface.rtpPacket(this, 30, data, off, len);
        } else if (id == this.vp9_id) {
            this.rtp.iface.rtpPacket(this, 31, data, off, len);
        } else if (id == this.h264_id) {
            this.rtp.iface.rtpPacket(this, 50, data, off, len);
        } else if (id == this.h265_id) {
            this.rtp.iface.rtpPacket(this, 60, data, off, len);
        } else if (id == this.h263_1998_id) {
            this.rtp.iface.rtpPacket(this, 41, data, off, len);
        } else if (id == this.h263_2000_id) {
            this.rtp.iface.rtpPacket(this, 42, data, off, len);
        } else if (id == this.speex_id) {
            int packetSize = this.coder.getPacketSize();
            if (packetSize != -1 && len != packetSize + 12) {
                JFLog.log(this.log, "RTP:Bad RTP packet length:type=" + this.coder.getClass().getName());
            }
            this.addSamples(this.coder.decode(data, off, len));
            this.rtp.iface.rtpSamples(this);
        } else if (debug) {
            JFLog.log("RTPChannel:unknown codec id:" + id + ":" + String.valueOf(this.rtp));
        }
    }

    protected void processRTCP(byte[] data, int off, int len) {
        if (this.rtp.rawMode) {
            this.rtp.iface.rtpPacket(this, 2, data, off, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void keepalive(long now) {
        if (RTP.useTURN && now + 75000L > this.turnBindExpires) {
            Object object = this.rtp.bindLock;
            synchronized (object) {
                this.rtp.bindingChannel = this;
                this.rtp.stun1.requestBind(this.turn1ch, this.stream.getIP(), this.stream.getPort());
                this.rtp.stun2.requestBind(this.turn2ch, this.stream.getIP(), this.stream.getPort() + 1);
            }
        }
        if (this.active && this.stream.type == SDP.Type.audio && this.stream.canRecv() && now - 45000L > this.lastPacket) {
            this.rtp.iface.rtpInactive(this);
        }
    }

    public boolean getSamples(short[] data) {
        if (!this.stream.canRecv()) {
            return this.moh.getSamples(data);
        }
        return this.buffer.get(data, 0, data.length);
    }

    private void addSamples(short[] data) {
        this.buffer.add(data, 0, data.length);
    }

    public String toString() {
        return "RTPChannel:{src=" + this.ssrc_src + ",dst=" + this.ssrc_dst + "," + String.valueOf(this.stream) + "}";
    }
}

