/*
 * Decompiled with CFR 0.152.
 */
package javaforce.media;

public class Camera {
    private long ctx = 0L;
    private int[] mirror;

    private native boolean cameraInit();

    private native boolean cameraUninit();

    private native String[] cameraListDevices();

    private native String[] cameraListModes(int var1);

    private native boolean cameraStart(int var1, int var2, int var3);

    private native boolean cameraStop();

    private native int[] cameraGetFrame();

    private native int cameraGetWidth();

    private native int cameraGetHeight();

    public boolean init() {
        return this.cameraInit();
    }

    public boolean uninit() {
        return this.cameraUninit();
    }

    public String[] listDevices() {
        return this.cameraListDevices();
    }

    public String[] listModes(int deviceIdx) {
        return this.cameraListModes(deviceIdx);
    }

    public boolean start(int deviceIdx, int width, int height) {
        return this.cameraStart(deviceIdx, width, height);
    }

    public boolean stop() {
        return this.cameraStop();
    }

    public int[] getFrame() {
        return this.cameraGetFrame();
    }

    public int[] getFrameMirror() {
        int[] px = this.cameraGetFrame();
        if (px == null) {
            return null;
        }
        if (this.mirror == null || this.mirror.length != px.length) {
            this.mirror = new int[px.length];
        }
        int width = this.getWidth();
        int height = this.getHeight();
        int src = 0;
        int dst = 0;
        for (int y = 0; y < height; ++y) {
            src += width;
            for (int x = 0; x < width; ++x) {
                this.mirror[dst++] = px[--src];
            }
            src += width;
        }
        return this.mirror;
    }

    public int getWidth() {
        return this.cameraGetWidth();
    }

    public int getHeight() {
        return this.cameraGetHeight();
    }
}

