/*
 * Decompiled with CFR 0.152.
 */
package javaforce.voip;

import javaforce.BE;
import javaforce.JFLog;
import javaforce.voip.RTP;
import javaforce.voip.RTPAudioCoder;
import javaforce.voip.RTPChannel;

public class g711a
implements RTPAudioCoder {
    private RTP rtp;
    private static short[] alaw_lut;
    private static int[] exp_lut;
    private static final short CLIP = Short.MAX_VALUE;
    private byte[] encoded = new byte[172];
    private int decode_timestamp;
    private short[] decoded = new short[160];

    public g711a(RTP rtp) {
        this.rtp = rtp;
    }

    @Override
    public void setid(int id) {
    }

    @Override
    public int getPacketSize() {
        return 160;
    }

    private static void init() {
        alaw_lut = new short[256];
        for (int idx = 0; idx < 256; idx = (int)((short)(idx + 1))) {
            int alaw = idx;
            alaw = (short)(alaw ^ 0x55);
            short i = (short)(((alaw & 0xF) << 4) + 8);
            short seg = (short)((alaw & 0x70) >> 4);
            if (seg != 0) {
                i = (short)(i + 256 << seg - 1);
            }
            g711a.alaw_lut[idx] = (alaw & 0x80) == 128 ? i : -i;
        }
    }

    @Override
    public byte[] encode(short[] samples) {
        RTPChannel rtpChannel = this.rtp.getDefaultChannel();
        RTPChannel.buildHeader(this.encoded, 8, rtpChannel.getseqnum(), rtpChannel.gettimestamp(160), rtpChannel.getssrc(), false);
        for (int i = 0; i < 160; ++i) {
            int sample = samples[i];
            int sign = sample >> 8 & 0x80;
            int mag = sign != 0 ? -sample : sample;
            if (mag > Short.MAX_VALUE) {
                mag = Short.MAX_VALUE;
            }
            int exponent = exp_lut[mag >> 8 & 0x7F];
            int mantissa = mag >> exponent + 3 & 0xF;
            if (mag < 256) {
                exponent = 0;
            }
            byte alawbyte = (byte)(sign | exponent << 4 | mantissa);
            this.encoded[12 + i] = alawbyte = (byte)(alawbyte ^ 0x55);
        }
        return this.encoded;
    }

    @Override
    public short[] decode(byte[] encoded, int off, int length) {
        int decode_timestamp = BE.getuint32(encoded, off + 4);
        if (this.decode_timestamp == 0) {
            this.decode_timestamp = decode_timestamp;
        } else {
            if (RTP.debug) {
                JFLog.log("G711a:timestamp = " + decode_timestamp + ":" + (this.decode_timestamp + 160 == decode_timestamp ? "ok" : "lost packet"));
            }
            this.decode_timestamp = decode_timestamp;
        }
        for (int i = 0; i < 160; ++i) {
            this.decoded[i] = alaw_lut[encoded[off + i + 12] & 0xFF];
        }
        return this.decoded;
    }

    @Override
    public int getSampleRate() {
        return 8000;
    }

    static {
        exp_lut = new int[]{1, 1, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};
        g711a.init();
    }
}

