/*
 * Decompiled with CFR 0.152.
 */
package javaforce.voip;

import javaforce.BE;
import javaforce.JFLog;
import javaforce.voip.RTP;
import javaforce.voip.RTPAudioCoder;
import javaforce.voip.RTPChannel;

public class g711u
implements RTPAudioCoder {
    private RTP rtp;
    private static short[] ulaw_lut;
    private static short[] etab;
    private static int[] exp_lut;
    private static final short BIAS = 132;
    private static final short CLIP = 32635;
    private byte[] encoded = new byte[172];
    private int decode_timestamp;
    private short[] decoded = new short[160];

    public g711u(RTP rtp) {
        this.rtp = rtp;
    }

    @Override
    public void setid(int id) {
    }

    @Override
    public int getPacketSize() {
        return 160;
    }

    private static void init() {
        ulaw_lut = new short[256];
        for (int i = 0; i < 256; i = (int)((short)(i + 1))) {
            short mu = (short)(255 - i);
            short e = (short)((mu & 0x70) / 16);
            short f = (short)(mu & 0xF);
            short y = (short)(f * (1 << e + 3));
            y = (short)(y + etab[e]);
            if ((mu & 0x80) == 128) {
                y = -y;
            }
            g711u.ulaw_lut[i] = y;
        }
    }

    @Override
    public byte[] encode(short[] samples) {
        RTPChannel rtpChannel = this.rtp.getDefaultChannel();
        RTPChannel.buildHeader(this.encoded, 0, rtpChannel.getseqnum(), rtpChannel.gettimestamp(160), rtpChannel.getssrc(), false);
        for (int i = 0; i < 160; ++i) {
            int mantissa;
            int exponent;
            int ulawbyte;
            int sample = samples[i];
            int sign = sample >> 8 & 0x80;
            if (sign != 0) {
                sample = (short)(-sample);
            }
            if (sample > 32635) {
                sample = 32635;
            }
            if ((ulawbyte = (int)(~(sign | (exponent = exp_lut[(sample = (int)((short)(sample + 132))) >> 7 & 0xFF]) << 4 | (mantissa = sample >> exponent + 3 & 0xF)))) == 0) {
                ulawbyte = 2;
            }
            this.encoded[12 + i] = ulawbyte;
        }
        return this.encoded;
    }

    @Override
    public short[] decode(byte[] encoded, int off, int length) {
        int decode_timestamp = BE.getuint32(encoded, off + 4);
        if (this.decode_timestamp == 0) {
            this.decode_timestamp = decode_timestamp;
        } else {
            if (RTP.debug) {
                JFLog.log("G711u:timestamp = " + decode_timestamp + ":" + (this.decode_timestamp + 160 == decode_timestamp ? "ok" : "lost packet"));
            }
            this.decode_timestamp = decode_timestamp;
        }
        for (int i = 0; i < 160; ++i) {
            this.decoded[i] = ulaw_lut[encoded[off + i + 12] & 0xFF];
        }
        return this.decoded;
    }

    @Override
    public int getSampleRate() {
        return 8000;
    }

    static {
        etab = new short[]{0, 132, 396, 924, 1980, 4092, 8316, 16764};
        exp_lut = new int[]{0, 0, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};
        g711u.init();
    }
}

