/*
 * Decompiled with CFR 0.152.
 */
package javaforce.voip;

import javaforce.BE;
import javaforce.JFLog;
import javaforce.codec.gsm.GSMDecoder;
import javaforce.codec.gsm.GSMEncoder;
import javaforce.voip.RTP;
import javaforce.voip.RTPAudioCoder;
import javaforce.voip.RTPChannel;

public class gsm
implements RTPAudioCoder {
    private GSMEncoder encoder = new GSMEncoder();
    private GSMDecoder decoder = new GSMDecoder();
    private RTP rtp;
    private byte[] edata = new byte[33];
    private byte[] encoded = new byte[45];
    private int decode_timestamp;
    private short[] decoded = new short[160];
    private byte[] ddata = new byte[33];

    public gsm(RTP rtp) {
        this.rtp = rtp;
    }

    @Override
    public void setid(int id) {
    }

    @Override
    public int getPacketSize() {
        return 33;
    }

    @Override
    public byte[] encode(short[] samples) {
        RTPChannel rtpChannel = this.rtp.getDefaultChannel();
        RTPChannel.buildHeader(this.encoded, 3, rtpChannel.getseqnum(), rtpChannel.gettimestamp(160), rtpChannel.getssrc(), false);
        this.encoder.encode(samples, this.edata);
        System.arraycopy(this.edata, 0, this.encoded, 12, 33);
        return this.encoded;
    }

    @Override
    public short[] decode(byte[] encoded, int off, int length) {
        int decode_timestamp = BE.getuint32(encoded, off + 4);
        if (this.decode_timestamp == 0) {
            this.decode_timestamp = decode_timestamp;
        } else {
            if (RTP.debug) {
                JFLog.log("GSM:timestamp = " + decode_timestamp + ":" + (this.decode_timestamp + 160 == decode_timestamp ? "ok" : "lost packet"));
            }
            this.decode_timestamp = decode_timestamp;
        }
        System.arraycopy(encoded, 12, this.ddata, 0, 33);
        try {
            int[] tmp = this.decoder.decode(this.ddata);
            for (int a = 0; a < 160; ++a) {
                this.decoded[a] = (short)tmp[a];
            }
        }
        catch (Exception e) {
            return null;
        }
        return this.decoded;
    }

    @Override
    public int getSampleRate() {
        return 8000;
    }
}

