/*
 * Decompiled with CFR 0.152.
 */
package javaforce.webui;

import javaforce.webui.Resource;
import javaforce.webui.TextComponent;

public class Label
extends TextComponent {
    private Resource img;

    public Label(String text) {
        this.text = text;
        this.addEvent("onclick", "onClick(event, this);");
        this.setClass("label");
        this.addClass("noselect");
    }

    public Label(Resource img) {
        this.img = img;
        this.addEvent("onclick", "onClick(event, this);");
        this.setClass("label");
        this.addClass("noselect");
    }

    @Override
    public String html() {
        if (this.img != null) {
            return "<img" + this.getAttrs() + " src='/static/" + this.img.id + "'>";
        }
        return "<div" + this.getAttrs() + ">" + this.text + "</div>";
    }

    @Override
    public void updateText(String txt) {
        this.sendEvent("settext", new String[]{"text=" + this.text});
    }

    public void setImage(Resource img) {
        this.img = img;
        this.sendEvent("setsrc", new String[]{"src=/static/" + img.id});
    }
}

