/*
 * Decompiled with CFR 0.152.
 */
package javaforce.webui.tasks;

import java.util.ArrayList;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.webui.Panel;
import javaforce.webui.tasks.Task;
import javaforce.webui.tasks.TaskUI;

public class Tasks
extends Thread {
    private Object lock = new Object();
    private ArrayList<Task> taskList = new ArrayList();
    private ArrayList<Task> waiting = new ArrayList();
    private boolean active = true;
    private boolean sequential = false;
    public static Tasks tasks;
    private static final long ts_cut_time = 300000L;

    public static void init() {
        if (tasks != null) {
            return;
        }
        tasks = new Tasks();
        tasks.start();
    }

    public void cancel() {
        this.active = false;
    }

    public void setSequential(boolean state) {
        this.sequential = state;
    }

    private void addUI(Task task) {
        task.taskui = new TaskUI(task);
        task.tasks.add(0, task.taskui);
    }

    private boolean busy() {
        if (this.waiting.size() > 0) {
            return true;
        }
        for (Task task : this.taskList) {
            if (!task.running) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(Panel ui_tasks, Task task) {
        task.tasks = ui_tasks;
        task.ts_start = System.currentTimeMillis();
        task.result = "";
        this.addUI(task);
        Object object = this.lock;
        synchronized (object) {
            if (this.sequential) {
                if (this.busy()) {
                    this.waiting.add(task);
                } else {
                    task.running = true;
                    this.taskList.add(task);
                    task.start();
                }
            } else {
                task.running = true;
                this.taskList.add(task);
                task.start();
            }
        }
    }

    private void updateUI(Task task) {
        task.taskui.update(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completed(Task task) {
        task.ts_stop = System.currentTimeMillis();
        task.ts_delta = task.ts_stop - task.ts_start;
        Object object = this.lock;
        synchronized (object) {
            task.running = false;
            if (this.sequential && this.waiting.size() > 0) {
                Task next = this.waiting.remove(0);
                next.running = true;
                this.taskList.add(next);
                next.start();
            }
        }
        this.updateUI(task);
        JFLog.log("Task completed:" + task.action + ":result=" + task.result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTask(Task task) {
        Object object = this.lock;
        synchronized (object) {
            this.taskList.remove(task);
        }
        task.tasks.remove(task.taskui);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.active) {
            JF.sleep(1000);
            long ts_now = System.currentTimeMillis();
            long ts_cut = ts_now - 300000L;
            ArrayList<Task> remove = new ArrayList<Task>();
            Object object = this.lock;
            synchronized (object) {
                for (Task task : this.taskList) {
                    if (task.ts_stop == 0L || task.ts_stop >= ts_cut) continue;
                    remove.add(task);
                }
                for (Task task : remove) {
                    this.removeTask(task);
                }
            }
        }
    }
}

