/*
 * Decompiled with CFR 0.152.
 */
package javaforce;

import java.io.InputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;

public class DatagramInputStream
extends InputStream {
    private static final int MAX = 1460;
    private DatagramSocket ds;
    private byte[] buffer;
    private int buffersize = 0;
    private int bufferpos = 0;

    private boolean fillBuffer() {
        while (this.buffersize == 0) {
            byte[] data = new byte[1460];
            DatagramPacket pack = new DatagramPacket(data, 1460);
            try {
                this.ds.receive(pack);
            }
            catch (Exception e) {
                return false;
            }
            this.buffer = pack.getData();
            this.buffersize = pack.getLength();
            this.bufferpos = 0;
        }
        return true;
    }

    public DatagramInputStream(DatagramSocket ds) {
        this.ds = ds;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() {
        if (!this.fillBuffer()) {
            return -1;
        }
        int ret = this.buffer[this.bufferpos++] & 0xFF;
        --this.buffersize;
        return ret;
    }

    @Override
    public int read(byte[] buf) {
        return this.read(buf, 0, buf.length);
    }

    @Override
    public int read(byte[] buf, int pos, int len) {
        int ret;
        if (!this.fillBuffer()) {
            return -1;
        }
        if (len > this.buffersize) {
            ret = this.buffersize;
            System.arraycopy(this.buffer, this.bufferpos, buf, pos, this.buffersize);
            this.buffersize = 0;
            this.bufferpos = 0;
        } else {
            ret = len;
            System.arraycopy(this.buffer, this.bufferpos, buf, pos, len);
            this.buffersize -= len;
            this.bufferpos += len;
        }
        return ret;
    }
}

