/*
 * Decompiled with CFR 0.152.
 */
package javaforce;

import java.util.ArrayList;
import java.util.List;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.LLRPEvent;
import org.llrp.ltk.generated.enumerations.AISpecStopTriggerType;
import org.llrp.ltk.generated.enumerations.AccessReportTriggerType;
import org.llrp.ltk.generated.enumerations.AccessSpecState;
import org.llrp.ltk.generated.enumerations.AccessSpecStopTriggerType;
import org.llrp.ltk.generated.enumerations.AirProtocols;
import org.llrp.ltk.generated.enumerations.GPIPortState;
import org.llrp.ltk.generated.enumerations.GetReaderCapabilitiesRequestedData;
import org.llrp.ltk.generated.enumerations.NotificationEventType;
import org.llrp.ltk.generated.enumerations.ROReportTriggerType;
import org.llrp.ltk.generated.enumerations.ROSpecEventType;
import org.llrp.ltk.generated.enumerations.ROSpecStartTriggerType;
import org.llrp.ltk.generated.enumerations.ROSpecState;
import org.llrp.ltk.generated.enumerations.ROSpecStopTriggerType;
import org.llrp.ltk.generated.interfaces.AccessCommandOpSpecResult;
import org.llrp.ltk.generated.interfaces.AirProtocolTagSpec;
import org.llrp.ltk.generated.messages.ADD_ACCESSSPEC;
import org.llrp.ltk.generated.messages.ADD_ACCESSSPEC_RESPONSE;
import org.llrp.ltk.generated.messages.ADD_ROSPEC;
import org.llrp.ltk.generated.messages.ADD_ROSPEC_RESPONSE;
import org.llrp.ltk.generated.messages.CUSTOM_MESSAGE;
import org.llrp.ltk.generated.messages.DELETE_ACCESSSPEC;
import org.llrp.ltk.generated.messages.DELETE_ACCESSSPEC_RESPONSE;
import org.llrp.ltk.generated.messages.DELETE_ROSPEC;
import org.llrp.ltk.generated.messages.DELETE_ROSPEC_RESPONSE;
import org.llrp.ltk.generated.messages.DISABLE_ACCESSSPEC;
import org.llrp.ltk.generated.messages.DISABLE_ACCESSSPEC_RESPONSE;
import org.llrp.ltk.generated.messages.DISABLE_ROSPEC;
import org.llrp.ltk.generated.messages.DISABLE_ROSPEC_RESPONSE;
import org.llrp.ltk.generated.messages.ENABLE_ACCESSSPEC;
import org.llrp.ltk.generated.messages.ENABLE_ACCESSSPEC_RESPONSE;
import org.llrp.ltk.generated.messages.ENABLE_ROSPEC;
import org.llrp.ltk.generated.messages.ENABLE_ROSPEC_RESPONSE;
import org.llrp.ltk.generated.messages.ERROR_MESSAGE;
import org.llrp.ltk.generated.messages.GET_READER_CAPABILITIES;
import org.llrp.ltk.generated.messages.GET_READER_CAPABILITIES_RESPONSE;
import org.llrp.ltk.generated.messages.KEEPALIVE;
import org.llrp.ltk.generated.messages.READER_EVENT_NOTIFICATION;
import org.llrp.ltk.generated.messages.RO_ACCESS_REPORT;
import org.llrp.ltk.generated.messages.SET_READER_CONFIG;
import org.llrp.ltk.generated.messages.SET_READER_CONFIG_RESPONSE;
import org.llrp.ltk.generated.messages.START_ROSPEC;
import org.llrp.ltk.generated.messages.START_ROSPEC_RESPONSE;
import org.llrp.ltk.generated.parameters.AISpec;
import org.llrp.ltk.generated.parameters.AISpecStopTrigger;
import org.llrp.ltk.generated.parameters.AccessCommand;
import org.llrp.ltk.generated.parameters.AccessReportSpec;
import org.llrp.ltk.generated.parameters.AccessSpec;
import org.llrp.ltk.generated.parameters.AccessSpecStopTrigger;
import org.llrp.ltk.generated.parameters.AntennaConfiguration;
import org.llrp.ltk.generated.parameters.C1G2EPCMemorySelector;
import org.llrp.ltk.generated.parameters.C1G2InventoryCommand;
import org.llrp.ltk.generated.parameters.C1G2Kill;
import org.llrp.ltk.generated.parameters.C1G2RFControl;
import org.llrp.ltk.generated.parameters.C1G2Read;
import org.llrp.ltk.generated.parameters.C1G2ReadOpSpecResult;
import org.llrp.ltk.generated.parameters.C1G2SingulationControl;
import org.llrp.ltk.generated.parameters.C1G2TagSpec;
import org.llrp.ltk.generated.parameters.C1G2TargetTag;
import org.llrp.ltk.generated.parameters.C1G2Write;
import org.llrp.ltk.generated.parameters.Custom;
import org.llrp.ltk.generated.parameters.EventNotificationState;
import org.llrp.ltk.generated.parameters.GPIEvent;
import org.llrp.ltk.generated.parameters.GPIPortCurrentState;
import org.llrp.ltk.generated.parameters.GPITriggerValue;
import org.llrp.ltk.generated.parameters.GPOWriteData;
import org.llrp.ltk.generated.parameters.InventoryParameterSpec;
import org.llrp.ltk.generated.parameters.PeakRSSI;
import org.llrp.ltk.generated.parameters.PeriodicTriggerValue;
import org.llrp.ltk.generated.parameters.RFReceiver;
import org.llrp.ltk.generated.parameters.RFTransmitter;
import org.llrp.ltk.generated.parameters.ROBoundarySpec;
import org.llrp.ltk.generated.parameters.ROReportSpec;
import org.llrp.ltk.generated.parameters.ROSpec;
import org.llrp.ltk.generated.parameters.ROSpecEvent;
import org.llrp.ltk.generated.parameters.ROSpecStartTrigger;
import org.llrp.ltk.generated.parameters.ROSpecStopTrigger;
import org.llrp.ltk.generated.parameters.ReaderEventNotificationData;
import org.llrp.ltk.generated.parameters.ReaderEventNotificationSpec;
import org.llrp.ltk.generated.parameters.TagReportContentSelector;
import org.llrp.ltk.generated.parameters.TagReportData;
import org.llrp.ltk.generated.parameters.TransmitPowerLevelTableEntry;
import org.llrp.ltk.net.LLRPConnector;
import org.llrp.ltk.net.LLRPEndpoint;
import org.llrp.ltk.types.Bit;
import org.llrp.ltk.types.BitArray_HEX;
import org.llrp.ltk.types.BytesToEnd_HEX;
import org.llrp.ltk.types.LLRPMessage;
import org.llrp.ltk.types.TwoBitField;
import org.llrp.ltk.types.UnsignedByte;
import org.llrp.ltk.types.UnsignedInteger;
import org.llrp.ltk.types.UnsignedShort;
import org.llrp.ltk.types.UnsignedShortArray;
import org.llrp.ltk.types.UnsignedShortArray_HEX;

public class LLRP
implements LLRPEndpoint {
    private static int delay = 10;
    private static int rospecid = 101;
    private static int inventoryparamid = 102;
    private static int accessid = 103;
    private static int opspecid = 104;
    private ROSpec rospec;
    private AccessSpec accessspec;
    private LLRPConnector llrp;
    private LLRPEvent events;
    private String ip;
    private int[] powerIndexes = new int[50];
    private int impinj_search_mode = -1;
    private int period = -1;
    private int duration = -1;
    private int gpi = -1;
    private int mode = 1002;
    private int sensitivity = 1;
    private int session = 1;
    private boolean enableAccessSpec = false;
    public static final int IMPINJ_SEARCH_MODE_SINGLE = 1;
    public static final int IMPINJ_SEARCH_MODE_DUAL = 2;
    public static final int IMPINJ_SEARCH_MODE_FOCUS = 3;
    public static final int IMPINJ_SEARCH_MODE_SINGLE_RESET = 5;
    public static final int IMPINJ_SEARCH_MODE_DUAL_B_TO_A = 6;
    public boolean active;
    public boolean connected;
    public int log;
    public long lastMsg;
    public static boolean debug;
    private int[] powerLevels;
    private boolean reading_power_levels;
    private int[] sensitivityLevels;
    private boolean reading_sensitivity_levels;

    public boolean connect(String ip, int time_out_ms) {
        this.ip = ip;
        this.llrp = new LLRPConnector((LLRPEndpoint)this, ip);
        try {
            this.llrp.connect((long)time_out_ms);
            this.connected = true;
            return true;
        }
        catch (Exception e) {
            try {
                this.llrp.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.llrp = null;
            if (debug) {
                JFLog.log(this.log, (Throwable)e);
            }
            return false;
        }
    }

    public boolean connect(String ip) {
        return this.connect(ip, 30000);
    }

    public void disconnect() {
        this.active = false;
        this.connected = false;
        if (this.llrp != null) {
            this.llrp.disconnect();
            this.llrp = null;
        }
    }

    public void ping() {
        this.ping(5000);
    }

    public void ping(int timeout) {
        if (this.llrp == null) {
            return;
        }
        try {
            long prevMsg = this.lastMsg;
            KEEPALIVE msg = new KEEPALIVE();
            this.llrp.send((LLRPMessage)msg);
            JF.sleep(delay);
            int cnt = 0;
            int maxcnt = timeout / delay;
            while (prevMsg == this.lastMsg) {
                JF.sleep(delay);
                if (++cnt != maxcnt) continue;
            }
            if (prevMsg == this.lastMsg) {
                throw new Exception("ping:no reply");
            }
        }
        catch (Exception e) {
            if (debug) {
                JFLog.log(this.log, (Throwable)e);
            }
            this.active = false;
            this.connected = false;
            this.disconnect();
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setEventsListener(LLRPEvent events) {
        this.events = events;
    }

    public void setRSSIThreshold(int value) {
        this.sensitivity = value;
    }

    public void setPowerIndexes(int[] powerIndexes) {
        this.powerIndexes = powerIndexes;
    }

    public void setModeIndex(int mode) {
        this.mode = mode;
    }

    public void setSession(int session) {
        this.session = session;
    }

    public void setPeriod(int period, int duration) {
        this.period = period;
        this.duration = duration;
    }

    public void setGPITrigger(int port) {
        this.gpi = port;
    }

    public void setGPITrigger(int port, int duration) {
        this.gpi = port;
        this.duration = duration;
    }

    public void setGPOState(int port, boolean state) {
        SET_READER_CONFIG msg = new SET_READER_CONFIG();
        msg.setResetToFactoryDefault(new Bit(false));
        GPOWriteData write = new GPOWriteData();
        write.setGPOPortNumber(new UnsignedShort(port));
        write.setGPOData(new Bit(state));
        ArrayList<GPOWriteData> list = new ArrayList<GPOWriteData>();
        list.add(write);
        msg.setGPOWriteDataList(list);
        this.llrp.send((LLRPMessage)msg);
    }

    public void setEnableAccessSpec(boolean access) {
        this.enableAccessSpec = access;
    }

    public void setImpinjSearchMode(int mode) {
        this.impinj_search_mode = mode;
    }

    public void setLog(int log) {
        this.log = log;
    }

    public boolean startInventoryScan() {
        if (this.llrp == null) {
            return false;
        }
        if (this.active) {
            return false;
        }
        this.active = true;
        try {
            this.rospec = this.createROSpec();
            this.accessspec = this.enableAccessSpec ? this.createReadAccessSpec(this.rospec.getROSpecID()) : null;
            SET_READER_CONFIG msg = new SET_READER_CONFIG();
            msg.setResetToFactoryDefault(new Bit(true));
            this.llrp.send((LLRPMessage)msg);
            JF.sleep(delay);
            msg = new DELETE_ROSPEC();
            msg.setROSpecID(new UnsignedInteger(0));
            this.llrp.send((LLRPMessage)msg);
            JF.sleep(delay);
            msg = new DELETE_ACCESSSPEC();
            msg.setAccessSpecID(new UnsignedInteger(0));
            this.llrp.send((LLRPMessage)msg);
            JF.sleep(delay);
            msg = new SET_READER_CONFIG();
            msg.setResetToFactoryDefault(new Bit(false));
            if (this.gpi != -1) {
                ArrayList<GPIPortCurrentState> list = new ArrayList<GPIPortCurrentState>();
                for (int a = 1; a <= 4; ++a) {
                    GPIPortCurrentState state = new GPIPortCurrentState();
                    state.setConfig(new Bit(true));
                    state.setGPIPortNum(new UnsignedShort(a));
                    state.setState(new GPIPortState(0));
                    list.add(state);
                }
                msg.setGPIPortCurrentStateList(list);
            }
            ReaderEventNotificationSpec events = new ReaderEventNotificationSpec();
            ArrayList<EventNotificationState> eventsList = new ArrayList<EventNotificationState>();
            if (this.gpi != -1) {
                EventNotificationState gpi_events = new EventNotificationState();
                gpi_events.setEventType(new NotificationEventType(1));
                gpi_events.setNotificationState(new Bit(true));
                eventsList.add(gpi_events);
            }
            EventNotificationState ro_events = new EventNotificationState();
            ro_events.setEventType(new NotificationEventType(2));
            ro_events.setNotificationState(new Bit(true));
            eventsList.add(ro_events);
            events.setEventNotificationStateList(eventsList);
            msg.setReaderEventNotificationSpec(events);
            this.llrp.send((LLRPMessage)msg);
            JF.sleep(delay);
            if (this.impinj_search_mode != -1) {
                msg = new CUSTOM_MESSAGE();
                msg.setVendorIdentifier(new UnsignedInteger(25882));
                msg.setMessageSubtype(new UnsignedByte(21));
                msg.setData(new BytesToEnd_HEX("00000000"));
                this.llrp.send((LLRPMessage)msg);
                JF.sleep(delay);
            }
            msg = new ADD_ROSPEC();
            msg.setROSpec(this.rospec);
            this.llrp.send((LLRPMessage)msg);
            JF.sleep(delay);
            if (this.enableAccessSpec) {
                msg = new ADD_ACCESSSPEC();
                msg.setAccessSpec(this.accessspec);
                this.llrp.send((LLRPMessage)msg);
                JF.sleep(delay);
            }
            msg = new ENABLE_ROSPEC();
            msg.setROSpecID(this.rospec.getROSpecID());
            this.llrp.send((LLRPMessage)msg);
            JF.sleep(delay);
            if (this.enableAccessSpec) {
                msg = new ENABLE_ACCESSSPEC();
                msg.setAccessSpecID(this.accessspec.getAccessSpecID());
                this.llrp.send((LLRPMessage)msg);
                JF.sleep(delay);
            }
            if (this.period == -1 && this.gpi == -1) {
                msg = new START_ROSPEC();
                msg.setROSpecID(this.rospec.getROSpecID());
                this.llrp.send((LLRPMessage)msg);
                JF.sleep(delay);
            }
            return true;
        }
        catch (Exception e) {
            if (debug) {
                JFLog.log(this.log, (Throwable)e);
            }
            return false;
        }
    }

    public void stop() {
        if (this.llrp == null) {
            return;
        }
        try {
            DISABLE_ROSPEC msg;
            if (this.rospec != null) {
                msg = new DISABLE_ROSPEC();
                msg.setROSpecID(this.rospec.getROSpecID());
                this.llrp.send((LLRPMessage)msg);
                this.rospec = null;
            }
            msg = new DELETE_ROSPEC();
            msg.setROSpecID(new UnsignedInteger(0));
            this.llrp.send((LLRPMessage)msg);
            if (this.accessspec != null) {
                msg = new DISABLE_ACCESSSPEC();
                msg.setAccessSpecID(this.accessspec.getROSpecID());
                this.llrp.send((LLRPMessage)msg);
                this.accessspec = null;
            }
            msg = new DELETE_ACCESSSPEC();
            msg.setAccessSpecID(new UnsignedInteger(0));
            this.llrp.send((LLRPMessage)msg);
            this.active = false;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.active = false;
            this.connected = false;
            this.disconnect();
        }
    }

    public boolean startWriteTag(short[] oldEPC, short[] newEPC, int wordOffset) {
        if (this.llrp == null) {
            return false;
        }
        if (this.active) {
            return false;
        }
        this.active = true;
        try {
            this.rospec = this.createROSpec();
            this.accessspec = this.createWriteAccessSpec(this.rospec.getROSpecID(), oldEPC, newEPC, wordOffset);
            SET_READER_CONFIG msg = new SET_READER_CONFIG();
            msg.setResetToFactoryDefault(new Bit(true));
            this.llrp.send((LLRPMessage)msg);
            JF.sleep(delay);
            msg = new DELETE_ROSPEC();
            msg.setROSpecID(new UnsignedInteger(0));
            this.llrp.send((LLRPMessage)msg);
            JF.sleep(delay);
            msg = new DELETE_ACCESSSPEC();
            msg.setAccessSpecID(new UnsignedInteger(0));
            this.llrp.send((LLRPMessage)msg);
            JF.sleep(delay);
            msg = new ADD_ROSPEC();
            msg.setROSpec(this.rospec);
            this.llrp.send((LLRPMessage)msg);
            JF.sleep(delay);
            msg = new ADD_ACCESSSPEC();
            msg.setAccessSpec(this.accessspec);
            this.llrp.send((LLRPMessage)msg);
            JF.sleep(delay);
            msg = new ENABLE_ROSPEC();
            msg.setROSpecID(this.rospec.getROSpecID());
            this.llrp.send((LLRPMessage)msg);
            JF.sleep(delay);
            msg = new ENABLE_ACCESSSPEC();
            msg.setAccessSpecID(this.accessspec.getAccessSpecID());
            this.llrp.send((LLRPMessage)msg);
            JF.sleep(delay);
            if (this.period == -1 && this.gpi == -1) {
                msg = new START_ROSPEC();
                msg.setROSpecID(this.rospec.getROSpecID());
                this.llrp.send((LLRPMessage)msg);
                JF.sleep(delay);
            }
            return true;
        }
        catch (Exception e) {
            if (debug) {
                JFLog.log(this.log, (Throwable)e);
            }
            return false;
        }
    }

    public boolean startWriteTag(short[] oldEPC, short[] newEPC) {
        return this.startWriteTag(oldEPC, newEPC, 2);
    }

    public boolean startKillTag(short[] targetEPC, int password) {
        if (this.llrp == null) {
            return false;
        }
        if (this.active) {
            return false;
        }
        this.active = true;
        try {
            this.rospec = this.createROSpec();
            this.accessspec = this.createKillAccessSpec(this.rospec.getROSpecID(), targetEPC, password);
            SET_READER_CONFIG msg = new SET_READER_CONFIG();
            msg.setResetToFactoryDefault(new Bit(true));
            this.llrp.send((LLRPMessage)msg);
            JF.sleep(delay);
            msg = new DELETE_ROSPEC();
            msg.setROSpecID(new UnsignedInteger(0));
            this.llrp.send((LLRPMessage)msg);
            JF.sleep(delay);
            msg = new DELETE_ACCESSSPEC();
            msg.setAccessSpecID(new UnsignedInteger(0));
            this.llrp.send((LLRPMessage)msg);
            JF.sleep(delay);
            msg = new ADD_ROSPEC();
            msg.setROSpec(this.rospec);
            this.llrp.send((LLRPMessage)msg);
            JF.sleep(delay);
            msg = new ADD_ACCESSSPEC();
            msg.setAccessSpec(this.accessspec);
            this.llrp.send((LLRPMessage)msg);
            JF.sleep(delay);
            msg = new ENABLE_ROSPEC();
            msg.setROSpecID(this.rospec.getROSpecID());
            this.llrp.send((LLRPMessage)msg);
            JF.sleep(delay);
            msg = new ENABLE_ACCESSSPEC();
            msg.setAccessSpecID(this.accessspec.getAccessSpecID());
            this.llrp.send((LLRPMessage)msg);
            JF.sleep(delay);
            if (this.period == -1 && this.gpi == -1) {
                msg = new START_ROSPEC();
                msg.setROSpecID(this.rospec.getROSpecID());
                this.llrp.send((LLRPMessage)msg);
                JF.sleep(delay);
            }
            return true;
        }
        catch (Exception e) {
            if (debug) {
                JFLog.log(this.log, (Throwable)e);
            }
            return false;
        }
    }

    public int[] getPowerLevels() {
        if (this.llrp == null) {
            return null;
        }
        if (this.active) {
            return null;
        }
        this.powerLevels = null;
        try {
            SET_READER_CONFIG msg = new SET_READER_CONFIG();
            msg.setResetToFactoryDefault(new Bit(true));
            this.llrp.send((LLRPMessage)msg);
            JF.sleep(delay);
            this.reading_power_levels = true;
            GET_READER_CAPABILITIES caps = new GET_READER_CAPABILITIES();
            caps.setRequestedData(new GetReaderCapabilitiesRequestedData(0));
            this.llrp.send((LLRPMessage)caps);
            JF.sleep(delay);
            int max = 12;
            while (this.powerLevels == null) {
                JF.sleep(1000);
                if (--max != 0) continue;
                JFLog.log(this.log, "LLRP:Error:getPowerLevels():timeout");
                return null;
            }
            this.reading_power_levels = false;
            return this.powerLevels;
        }
        catch (Exception e) {
            if (debug) {
                JFLog.log(this.log, (Throwable)e);
            }
            return null;
        }
    }

    public int[] getSensitivityLevels() {
        if (this.llrp == null) {
            return null;
        }
        if (this.active) {
            return null;
        }
        this.sensitivityLevels = null;
        try {
            SET_READER_CONFIG msg = new SET_READER_CONFIG();
            msg.setResetToFactoryDefault(new Bit(true));
            this.llrp.send((LLRPMessage)msg);
            JF.sleep(delay);
            this.reading_sensitivity_levels = true;
            GET_READER_CAPABILITIES caps = new GET_READER_CAPABILITIES();
            caps.setRequestedData(new GetReaderCapabilitiesRequestedData(0));
            this.llrp.send((LLRPMessage)caps);
            JF.sleep(delay);
            int max = 12;
            while (this.sensitivityLevels == null) {
                JF.sleep(1000);
                if (--max != 0) continue;
                JFLog.log(this.log, "LLRP:Error:getSensitivityLevels():timeout");
                return null;
            }
            this.reading_sensitivity_levels = false;
            return this.sensitivityLevels;
        }
        catch (Exception e) {
            if (debug) {
                JFLog.log(this.log, (Throwable)e);
            }
            return null;
        }
    }

    private ROSpec createROSpec() {
        boolean session_bit_1;
        ROSpecStartTrigger rospecstarttrigger = new ROSpecStartTrigger();
        if (this.period != -1) {
            rospecstarttrigger.setROSpecStartTriggerType(new ROSpecStartTriggerType(2));
            PeriodicTriggerValue periodValue = new PeriodicTriggerValue();
            periodValue.setPeriod(new UnsignedInteger(this.period));
            periodValue.setOffset(new UnsignedInteger(0));
            rospecstarttrigger.setPeriodicTriggerValue(periodValue);
        } else if (this.gpi != -1) {
            rospecstarttrigger.setROSpecStartTriggerType(new ROSpecStartTriggerType(3));
            GPITriggerValue gpiValue = new GPITriggerValue();
            gpiValue.setGPIPortNum(new UnsignedShort(this.gpi));
            gpiValue.setGPIEvent(new Bit(false));
            gpiValue.setTimeout(new UnsignedInteger(0));
            rospecstarttrigger.setGPITriggerValue(gpiValue);
        } else {
            rospecstarttrigger.setROSpecStartTriggerType(new ROSpecStartTriggerType(0));
        }
        ROSpecStopTrigger rospecstoptrigger = new ROSpecStopTrigger();
        if (this.duration != -1) {
            rospecstoptrigger.setROSpecStopTriggerType(new ROSpecStopTriggerType(1));
            rospecstoptrigger.setDurationTriggerValue(new UnsignedInteger(this.duration));
        } else {
            rospecstoptrigger.setROSpecStopTriggerType(new ROSpecStopTriggerType(0));
            rospecstoptrigger.setDurationTriggerValue(new UnsignedInteger(0));
        }
        ROBoundarySpec roboundaryspec = new ROBoundarySpec();
        roboundaryspec.setROSpecStartTrigger(rospecstarttrigger);
        roboundaryspec.setROSpecStopTrigger(rospecstoptrigger);
        ROReportSpec roreportspec = new ROReportSpec();
        roreportspec.setROReportTrigger(new ROReportTriggerType(2));
        roreportspec.setN(new UnsignedShort(1));
        TagReportContentSelector selector = new TagReportContentSelector();
        ArrayList<C1G2EPCMemorySelector> selectorList = new ArrayList<C1G2EPCMemorySelector>();
        C1G2EPCMemorySelector selectorEPC = new C1G2EPCMemorySelector();
        selectorEPC.setEnableCRC(new Bit(true));
        selectorEPC.setEnablePCBits(new Bit(true));
        selectorList.add(selectorEPC);
        selector.setAirProtocolEPCMemorySelectorList(selectorList);
        selector.setEnableROSpecID(new Bit(false));
        selector.setEnableSpecIndex(new Bit(false));
        selector.setEnableInventoryParameterSpecID(new Bit(false));
        selector.setEnableAntennaID(new Bit(true));
        selector.setEnableChannelIndex(new Bit(true));
        selector.setEnablePeakRSSI(new Bit(false));
        selector.setEnableFirstSeenTimestamp(new Bit(true));
        selector.setEnableLastSeenTimestamp(new Bit(false));
        selector.setEnableTagSeenCount(new Bit(false));
        selector.setEnableAccessSpecID(new Bit(true));
        selector.setEnablePeakRSSI(new Bit(true));
        roreportspec.setTagReportContentSelector(selector);
        ArrayList<AISpec> specParameterList = new ArrayList<AISpec>();
        AISpec aispec = new AISpec();
        UnsignedShortArray IDs = new UnsignedShortArray();
        for (int a = 0; a < this.powerIndexes.length; ++a) {
            IDs.add(new UnsignedShort(a + 1));
        }
        aispec.setAntennaIDs(IDs);
        AISpecStopTrigger aispecstoptrigger = new AISpecStopTrigger();
        aispecstoptrigger.setAISpecStopTriggerType(new AISpecStopTriggerType(0));
        aispecstoptrigger.setDurationTrigger(new UnsignedInteger(0));
        aispec.setAISpecStopTrigger(aispecstoptrigger);
        ArrayList<InventoryParameterSpec> inventoryParameterSpecList = new ArrayList<InventoryParameterSpec>();
        InventoryParameterSpec invspec = new InventoryParameterSpec();
        invspec.setInventoryParameterSpecID(new UnsignedShort(inventoryparamid));
        invspec.setProtocolID(new AirProtocols(1));
        ArrayList<AntennaConfiguration> antennaConfigurationList = new ArrayList<AntennaConfiguration>();
        ArrayList<C1G2InventoryCommand> commands = new ArrayList<C1G2InventoryCommand>();
        C1G2InventoryCommand command = new C1G2InventoryCommand();
        C1G2RFControl rfcontrol = new C1G2RFControl();
        rfcontrol.setModeIndex(new UnsignedShort(this.mode));
        rfcontrol.setTari(new UnsignedShort(0));
        command.setC1G2RFControl(rfcontrol);
        C1G2SingulationControl singulationcontrol = new C1G2SingulationControl();
        TwoBitField session_bits = new TwoBitField();
        boolean session_bit_0 = (this.session & 1) == 1;
        boolean bl = session_bit_1 = (this.session & 2) == 2;
        if (session_bit_0) {
            session_bits.set(Integer.valueOf(1));
        }
        if (session_bit_1) {
            session_bits.set(Integer.valueOf(0));
        }
        singulationcontrol.setSession(session_bits);
        singulationcontrol.setTagPopulation(new UnsignedShort(32));
        singulationcontrol.setTagTransitTime(new UnsignedInteger(0));
        command.setC1G2SingulationControl(singulationcontrol);
        command.setTagInventoryStateAware(new Bit(false));
        if (this.impinj_search_mode != -1) {
            ArrayList<Custom> customList = new ArrayList<Custom>();
            Custom search_mode = new Custom();
            search_mode.setVendorIdentifier(new UnsignedInteger(25882));
            search_mode.setParameterSubtype(new UnsignedInteger(23));
            search_mode.setData(new BytesToEnd_HEX(String.format("%04x", this.impinj_search_mode)));
            customList.add(search_mode);
            command.setCustomList(customList);
        }
        commands.add(command);
        for (int a = 0; a < this.powerIndexes.length; ++a) {
            AntennaConfiguration antennaConfiguration = new AntennaConfiguration();
            antennaConfiguration.setAirProtocolInventoryCommandSettingsList(commands);
            antennaConfiguration.setAntennaID(new UnsignedShort(a + 1));
            RFReceiver rfrec = new RFReceiver();
            rfrec.setReceiverSensitivity(new UnsignedShort(this.sensitivity));
            antennaConfiguration.setRFReceiver(rfrec);
            RFTransmitter rftrans = new RFTransmitter();
            rftrans.setHopTableID(new UnsignedShort(1));
            rftrans.setChannelIndex(new UnsignedShort(1));
            rftrans.setTransmitPower(new UnsignedShort(this.powerIndexes[a]));
            antennaConfiguration.setRFTransmitter(rftrans);
            antennaConfigurationList.add(antennaConfiguration);
        }
        invspec.setAntennaConfigurationList(antennaConfigurationList);
        inventoryParameterSpecList.add(invspec);
        aispec.setInventoryParameterSpecList(inventoryParameterSpecList);
        specParameterList.add(aispec);
        ROSpec rospec = new ROSpec();
        rospec.setROBoundarySpec(roboundaryspec);
        rospec.setROSpecID(new UnsignedInteger(rospecid));
        rospec.setROReportSpec(roreportspec);
        rospec.setSpecParameterList(specParameterList);
        rospec.setCurrentState(new ROSpecState(0));
        rospec.setPriority(new UnsignedByte(0));
        return rospec;
    }

    private AccessSpec createReadAccessSpec(UnsignedInteger rospecid) {
        AccessSpec as = new AccessSpec();
        TwoBitField mb = new TwoBitField();
        mb.set(Integer.valueOf(1));
        AccessCommand accessCommand = new AccessCommand();
        ArrayList<C1G2Read> accessCommandOpSpecList = new ArrayList<C1G2Read>();
        C1G2Read read = new C1G2Read();
        read.setAccessPassword(new UnsignedInteger(0));
        read.setMB(mb);
        read.setOpSpecID(new UnsignedShort(opspecid));
        read.setWordCount(new UnsignedShort(8));
        read.setWordPointer(new UnsignedShort(2));
        accessCommandOpSpecList.add(read);
        accessCommand.setAccessCommandOpSpecList(accessCommandOpSpecList);
        C1G2TagSpec tagSpec = new C1G2TagSpec();
        ArrayList<C1G2TargetTag> targetTagList = new ArrayList<C1G2TargetTag>();
        C1G2TargetTag tt = new C1G2TargetTag();
        tt.setMB(mb);
        tt.setMatch(new Bit(false));
        tt.setPointer(new UnsignedShort(2));
        BitArray_HEX mask = new BitArray_HEX(128);
        for (int a = 0; a < 128; ++a) {
            mask.set(a);
        }
        tt.setTagMask(mask);
        BitArray_HEX data = new BitArray_HEX(128);
        for (int a = 0; a < 128; ++a) {
            data.set(a);
        }
        tt.setTagData(data);
        targetTagList.add(tt);
        tagSpec.setC1G2TargetTagList(targetTagList);
        accessCommand.setAirProtocolTagSpec((AirProtocolTagSpec)tagSpec);
        as.setAccessCommand(accessCommand);
        AccessReportSpec accessReportSpec = new AccessReportSpec();
        accessReportSpec.setAccessReportTrigger(new AccessReportTriggerType(0));
        as.setAccessReportSpec(accessReportSpec);
        AccessSpecStopTrigger accessSpecStopTrigger = new AccessSpecStopTrigger();
        accessSpecStopTrigger.setAccessSpecStopTrigger(new AccessSpecStopTriggerType(0));
        accessSpecStopTrigger.setOperationCountValue(new UnsignedShort(1));
        as.setAccessSpecStopTrigger(accessSpecStopTrigger);
        as.setAntennaID(new UnsignedShort(1));
        as.setCurrentState(new AccessSpecState(0));
        AirProtocols airProtocols = new AirProtocols();
        airProtocols.set(1);
        as.setProtocolID(airProtocols);
        as.setROSpecID(rospecid);
        as.setAccessSpecID(new UnsignedInteger(accessid));
        return as;
    }

    private String shortArrayToHexString(short[] epc) {
        StringBuilder sb = new StringBuilder();
        for (int a = 0; a < epc.length; ++a) {
            sb.append(String.format("%04x", epc[a]));
        }
        return sb.toString();
    }

    private AccessSpec createWriteAccessSpec(UnsignedInteger rospecid, short[] oldEPC, short[] newEPC, int offset) {
        AccessSpec as = new AccessSpec();
        TwoBitField mb = new TwoBitField();
        mb.set(Integer.valueOf(1));
        int oldBits = oldEPC.length * 16;
        int newBits = newEPC.length * 16;
        if (oldBits != newBits) {
            JFLog.log("Warning:oldEPC.length != newEPC.length");
        }
        AccessCommand accessCommand = new AccessCommand();
        ArrayList<C1G2Write> accessCommandOpSpecList = new ArrayList<C1G2Write>();
        C1G2Write write = new C1G2Write();
        write.setAccessPassword(new UnsignedInteger(0));
        write.setMB(mb);
        write.setOpSpecID(new UnsignedShort(opspecid));
        write.setWordPointer(new UnsignedShort(offset));
        UnsignedShortArray_HEX newepchex = new UnsignedShortArray_HEX(newEPC.length);
        for (int a = 0; a < newEPC.length; ++a) {
            newepchex.set(a, new UnsignedShort((int)newEPC[a]));
        }
        write.setWriteData(newepchex);
        accessCommandOpSpecList.add(write);
        accessCommand.setAccessCommandOpSpecList(accessCommandOpSpecList);
        C1G2TagSpec tagSpec = new C1G2TagSpec();
        ArrayList<C1G2TargetTag> targetTagList = new ArrayList<C1G2TargetTag>();
        C1G2TargetTag tt = new C1G2TargetTag();
        tt.setMB(mb);
        tt.setMatch(new Bit(true));
        tt.setPointer(new UnsignedShort(32));
        BitArray_HEX mask = new BitArray_HEX(oldBits);
        for (int a = 0; a < oldBits; ++a) {
            mask.set(a);
        }
        tt.setTagMask(mask);
        BitArray_HEX data = new BitArray_HEX(this.shortArrayToHexString(oldEPC));
        tt.setTagData(data);
        targetTagList.add(tt);
        tagSpec.setC1G2TargetTagList(targetTagList);
        accessCommand.setAirProtocolTagSpec((AirProtocolTagSpec)tagSpec);
        as.setAccessCommand(accessCommand);
        AccessReportSpec accessReportSpec = new AccessReportSpec();
        accessReportSpec.setAccessReportTrigger(new AccessReportTriggerType(0));
        as.setAccessReportSpec(accessReportSpec);
        AccessSpecStopTrigger accessSpecStopTrigger = new AccessSpecStopTrigger();
        accessSpecStopTrigger.setAccessSpecStopTrigger(new AccessSpecStopTriggerType(0));
        accessSpecStopTrigger.setOperationCountValue(new UnsignedShort(1));
        as.setAccessSpecStopTrigger(accessSpecStopTrigger);
        as.setAntennaID(new UnsignedShort(1));
        as.setCurrentState(new AccessSpecState(0));
        AirProtocols airProtocols = new AirProtocols();
        airProtocols.set(1);
        as.setProtocolID(airProtocols);
        as.setROSpecID(rospecid);
        as.setAccessSpecID(new UnsignedInteger(accessid));
        return as;
    }

    private AccessSpec createKillAccessSpec(UnsignedInteger rospecid, short[] targetEPC, int password) {
        AccessSpec as = new AccessSpec();
        TwoBitField mb = new TwoBitField();
        mb.set(Integer.valueOf(1));
        int oldBits = targetEPC.length * 16;
        AccessCommand accessCommand = new AccessCommand();
        ArrayList<C1G2Kill> accessCommandOpSpecList = new ArrayList<C1G2Kill>();
        C1G2Kill kill = new C1G2Kill();
        kill.setOpSpecID(new UnsignedShort(opspecid));
        kill.setKillPassword(new UnsignedInteger(password));
        accessCommandOpSpecList.add(kill);
        accessCommand.setAccessCommandOpSpecList(accessCommandOpSpecList);
        C1G2TagSpec tagSpec = new C1G2TagSpec();
        ArrayList<C1G2TargetTag> targetTagList = new ArrayList<C1G2TargetTag>();
        C1G2TargetTag tt = new C1G2TargetTag();
        tt.setMB(mb);
        tt.setMatch(new Bit(true));
        tt.setPointer(new UnsignedShort(32));
        BitArray_HEX mask = new BitArray_HEX(oldBits);
        for (int a = 0; a < oldBits; ++a) {
            mask.set(a);
        }
        tt.setTagMask(mask);
        BitArray_HEX data = new BitArray_HEX(this.shortArrayToHexString(targetEPC));
        tt.setTagData(data);
        targetTagList.add(tt);
        tagSpec.setC1G2TargetTagList(targetTagList);
        accessCommand.setAirProtocolTagSpec((AirProtocolTagSpec)tagSpec);
        as.setAccessCommand(accessCommand);
        AccessReportSpec accessReportSpec = new AccessReportSpec();
        accessReportSpec.setAccessReportTrigger(new AccessReportTriggerType(0));
        as.setAccessReportSpec(accessReportSpec);
        AccessSpecStopTrigger accessSpecStopTrigger = new AccessSpecStopTrigger();
        accessSpecStopTrigger.setAccessSpecStopTrigger(new AccessSpecStopTriggerType(0));
        accessSpecStopTrigger.setOperationCountValue(new UnsignedShort(1));
        as.setAccessSpecStopTrigger(accessSpecStopTrigger);
        as.setAntennaID(new UnsignedShort(1));
        as.setCurrentState(new AccessSpecState(0));
        AirProtocols airProtocols = new AirProtocols();
        airProtocols.set(1);
        as.setProtocolID(airProtocols);
        as.setROSpecID(rospecid);
        as.setAccessSpecID(new UnsignedInteger(accessid));
        return as;
    }

    public void messageReceived(LLRPMessage llrpm) {
        this.lastMsg = System.currentTimeMillis();
        if (debug) {
            JFLog.log("LLRP:messageReceived:" + this.ip + ":" + String.valueOf(llrpm));
        }
        try {
            if (llrpm instanceof RO_ACCESS_REPORT) {
                RO_ACCESS_REPORT report = (RO_ACCESS_REPORT)llrpm;
                List tags = report.getTagReportDataList();
                for (TagReportData tag : tags) {
                    String epc;
                    int idx;
                    String epc_scan = null;
                    String epc_read = null;
                    int tag_rssi = 0;
                    PeakRSSI peak_rssi = tag.getPeakRSSI();
                    if (peak_rssi != null) {
                        tag_rssi = peak_rssi.getPeakRSSI().intValue();
                    }
                    if ((idx = (epc_scan = tag.getEPCParameter().toString()).lastIndexOf(58)) > 0) {
                        epc_scan = epc_scan.substring(idx + 1);
                    }
                    epc_scan = epc_scan.replaceAll(" ", "").trim();
                    List list = tag.getAccessCommandOpSpecResultList();
                    if (list.size() == 0 && this.events != null) {
                        this.events.tagRead(null, 0);
                    }
                    for (AccessCommandOpSpecResult res : list) {
                        if (!(res instanceof C1G2ReadOpSpecResult)) continue;
                        C1G2ReadOpSpecResult readop = (C1G2ReadOpSpecResult)res;
                        epc_read = readop.getReadData().toString();
                        idx = epc_read.lastIndexOf(58);
                        if (idx > 0) {
                            epc_read = epc_read.substring(idx + 1);
                        }
                        epc_read = epc_read.replaceAll(" ", "").trim();
                    }
                    if (this.events == null || epc_read == null && epc_scan == null) continue;
                    String string = epc = epc_read != null && epc_read.length() > 0 ? epc_read : epc_scan;
                    if (debug) {
                        JFLog.log(this.log, "[" + System.currentTimeMillis() + "] EPC=" + epc + ":RSSI=" + tag_rssi);
                    }
                    this.events.tagRead(epc, tag_rssi);
                }
            } else if (llrpm instanceof GET_READER_CAPABILITIES_RESPONSE) {
                int index;
                int[] levels;
                List list;
                GET_READER_CAPABILITIES_RESPONSE caps = (GET_READER_CAPABILITIES_RESPONSE)llrpm;
                if (this.reading_power_levels) {
                    list = caps.getRegulatoryCapabilities().getUHFBandCapabilities().getTransmitPowerLevelTableEntryList();
                    levels = new int[list.size() + 1];
                    index = 1;
                    for (TransmitPowerLevelTableEntry entry : list) {
                        levels[index++] = entry.getTransmitPowerValue().intValue();
                    }
                    this.powerLevels = levels;
                }
                if (this.reading_sensitivity_levels) {
                    list = caps.getGeneralDeviceCapabilities().getReceiveSensitivityTableEntryList();
                    levels = new int[list.size() + 1];
                    index = 1;
                    for (TransmitPowerLevelTableEntry entry : list) {
                        levels[index++] = entry.getReceiveSensitivityValue().toShort();
                    }
                    this.sensitivityLevels = levels;
                }
            } else if (llrpm instanceof READER_EVENT_NOTIFICATION) {
                READER_EVENT_NOTIFICATION event = (READER_EVENT_NOTIFICATION)llrpm;
                ReaderEventNotificationData data = event.getReaderEventNotificationData();
                int type = 0;
                if (data.getGPIEvent() != null) {
                    type = 248;
                }
                if (data.getROSpecEvent() != null) {
                    type = 249;
                }
                block1 : switch (type) {
                    case 248: {
                        GPIEvent gpiEvent = data.getGPIEvent();
                        this.events.gpiEvent(gpiEvent.getGPIPortNumber().toShort(), gpiEvent.getGPIEvent().toBoolean());
                        break;
                    }
                    case 249: {
                        ROSpecEvent roEvent = data.getROSpecEvent();
                        ROSpecEventType roEventType = roEvent.getEventType();
                        int roType = roEventType.toInteger();
                        switch (roType) {
                            case 0: {
                                this.events.readStarted();
                                break block1;
                            }
                            case 1: {
                                this.events.readEnded();
                            }
                        }
                    }
                }
            } else if (!(llrpm instanceof SET_READER_CONFIG_RESPONSE || llrpm instanceof DELETE_ROSPEC_RESPONSE || llrpm instanceof DELETE_ACCESSSPEC_RESPONSE || llrpm instanceof ADD_ROSPEC_RESPONSE || llrpm instanceof ENABLE_ROSPEC_RESPONSE || llrpm instanceof START_ROSPEC_RESPONSE || llrpm instanceof DISABLE_ROSPEC_RESPONSE || llrpm instanceof ADD_ACCESSSPEC_RESPONSE || llrpm instanceof ENABLE_ACCESSSPEC_RESPONSE || llrpm instanceof DISABLE_ACCESSSPEC_RESPONSE)) {
                if (llrpm instanceof ERROR_MESSAGE) {
                    ERROR_MESSAGE event = (ERROR_MESSAGE)llrpm;
                } else {
                    JFLog.log("LLRP:Unknown message:" + String.valueOf(llrpm));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void errorOccured(String msg) {
        JFLog.log(this.log, "LLRP:Error:" + this.ip + ":" + msg);
        this.active = false;
        this.connected = false;
        this.disconnect();
    }

    private static void usage() {
        System.out.println("usage : LLRP controller_ip cmd [args]");
        System.out.println("where : cmd = read | powerlevels | rssilevels | ping");
        System.out.println("      : read [power=p1[,p2[,p3[,p4]]]] [rssi=threshold] [period=ms] [gpi=port] [duration=ms]");
        System.out.println("      : powerlevels");
        System.out.println("      : rssilevels");
        System.out.println("      : ping");
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            LLRP.usage();
            return;
        }
        boolean main_active = true;
        String ctrl = args[0];
        String cmd = args[1];
        int[] powerLevels = new int[]{80, 80, 80, 80};
        int rssi = 0;
        int period = 0;
        int duration = 0;
        int gpi = 0;
        switch (cmd) {
            case "read": {
                block26: for (int a = 2; a < args.length; ++a) {
                    String arg = args[a];
                    int idx = arg.indexOf(61);
                    if (idx == -1) continue;
                    String key = arg.substring(0, idx);
                    String value = arg.substring(idx + 1);
                    switch (key) {
                        case "power": {
                            String[] lvls = value.split("[,]");
                            powerLevels = new int[lvls.length];
                            for (int b = 0; b < lvls.length; ++b) {
                                powerLevels[b] = Integer.valueOf(lvls[b]);
                            }
                            continue block26;
                        }
                        case "rssi": {
                            rssi = Integer.valueOf(value);
                            continue block26;
                        }
                        case "period": {
                            period = Integer.valueOf(value);
                            if (duration != 0) continue block26;
                            duration = 500;
                            continue block26;
                        }
                        case "duration": {
                            duration = Integer.valueOf(value);
                            continue block26;
                        }
                        case "gpi": {
                            gpi = Integer.valueOf(value);
                        }
                    }
                }
                LLRP llrp = new LLRP();
                debug = true;
                if (period != 0) {
                    llrp.setPeriod(period, duration);
                }
                if (gpi != 0) {
                    if (duration != 0) {
                        llrp.setGPITrigger(gpi, duration);
                    } else {
                        llrp.setGPITrigger(gpi);
                    }
                }
                if (rssi != 0) {
                    llrp.setRSSIThreshold(rssi);
                }
                llrp.setEventsListener(new LLRPEvent(){

                    @Override
                    public void tagRead(String epc, int rssi) {
                        System.out.println("EPC=" + epc + ":RSSI=" + rssi);
                    }

                    @Override
                    public void gpiEvent(int port, boolean event) {
                        System.out.println("GPI:" + port + ":" + event);
                    }

                    @Override
                    public void readStarted() {
                        System.out.println("readStarted");
                    }

                    @Override
                    public void readEnded() {
                        System.out.println("readEnded");
                    }
                });
                llrp.setPowerIndexes(powerLevels);
                llrp.connect(ctrl);
                llrp.startInventoryScan();
                while (main_active) {
                    JF.sleep(100);
                }
                llrp.disconnect();
                break;
            }
            case "powerlevels": {
                LLRP llrp = new LLRP();
                debug = true;
                llrp.connect(ctrl);
                int[] levels = llrp.getPowerLevels();
                llrp.stop();
                if (levels == null) {
                    System.out.println("Error:getPowerLevels()==null");
                    break;
                }
                System.out.println("# Power Levels = " + levels.length);
                int index = 0;
                for (int level : levels) {
                    System.out.println("PowerLevel:index=" + index + ":level=" + levels[index]);
                    ++index;
                }
                llrp.disconnect();
                break;
            }
            case "rssilevels": {
                LLRP llrp = new LLRP();
                debug = true;
                llrp.connect(ctrl);
                int[] levels = llrp.getSensitivityLevels();
                llrp.stop();
                if (levels == null) {
                    System.out.println("Error:getSensitivityLevels()==null");
                    break;
                }
                System.out.println("# Sensitivty Levels = " + levels.length);
                int index = 0;
                for (int level : levels) {
                    System.out.println("SensitivtyLevel:index=" + index + ":level=" + levels[index]);
                    ++index;
                }
                llrp.disconnect();
                break;
            }
            case "ping": {
                LLRP llrp = new LLRP();
                debug = true;
                llrp.connect(ctrl);
                llrp.ping();
                llrp.disconnect();
                break;
            }
            default: {
                LLRP.usage();
            }
        }
        System.out.println("Done");
    }
}

