/*
 * Decompiled with CFR 0.152.
 */
package javaforce.codec.speex;

public class Lsp {
    private final float[] pw = new float[42];

    public static float cheb_poly_eva(float[] coef, float x, int m) {
        int m2 = m >> 1;
        float[] T = new float[m2 + 1];
        T[0] = 1.0f;
        T[1] = x;
        float sum = coef[m2] + coef[m2 - 1] * x;
        x *= 2.0f;
        for (int i = 2; i <= m2; ++i) {
            T[i] = x * T[i - 1] - T[i - 2];
            sum += coef[m2 - i] * T[i];
        }
        return sum;
    }

    public static int lpc2lsp(float[] a, int lpcrdr, float[] freq, int nb, float delta) {
        int i;
        float xm = 0.0f;
        int roots = 0;
        boolean flag = true;
        int m = lpcrdr / 2;
        float[] Q = new float[m + 1];
        float[] P = new float[m + 1];
        int px = 0;
        int qx = 0;
        int p = px;
        int q = qx;
        P[px++] = 1.0f;
        Q[qx++] = 1.0f;
        for (i = 1; i <= m; ++i) {
            P[px++] = a[i] + a[lpcrdr + 1 - i] - P[p++];
            Q[qx++] = a[i] - a[lpcrdr + 1 - i] + Q[q++];
        }
        px = 0;
        qx = 0;
        for (i = 0; i < m; ++i) {
            P[px] = 2.0f * P[px];
            Q[qx] = 2.0f * Q[qx];
            ++px;
            ++qx;
        }
        px = 0;
        qx = 0;
        float xr = 0.0f;
        float xl = 1.0f;
        for (int j = 0; j < lpcrdr; ++j) {
            float[] pt = j % 2 != 0 ? Q : P;
            float psuml = Lsp.cheb_poly_eva(pt, xl, lpcrdr);
            flag = true;
            while (flag && (double)xr >= -1.0) {
                float psumr;
                float dd = delta * (1.0f - 0.9f * xl * xl);
                if (Math.abs(psuml) < 0.2f) {
                    dd *= 0.5f;
                }
                xr = xl - dd;
                float temp_psumr = psumr = Lsp.cheb_poly_eva(pt, xr, lpcrdr);
                float temp_xr = xr;
                if ((double)(psumr * psuml) < 0.0) {
                    ++roots;
                    float psumm = psuml;
                    for (int k = 0; k <= nb; ++k) {
                        xm = (xl + xr) / 2.0f;
                        psumm = Lsp.cheb_poly_eva(pt, xm, lpcrdr);
                        if ((double)(psumm * psuml) > 0.0) {
                            psuml = psumm;
                            xl = xm;
                            continue;
                        }
                        psumr = psumm;
                        xr = xm;
                    }
                    freq[j] = xm;
                    xl = xm;
                    flag = false;
                    continue;
                }
                psuml = temp_psumr;
                xl = temp_xr;
            }
        }
        return roots;
    }

    public void lsp2lpc(float[] freq, float[] ak, int lpcrdr) {
        int i;
        int n4 = 0;
        int m = lpcrdr / 2;
        for (i = 0; i < 4 * m + 2; ++i) {
            this.pw[i] = 0.0f;
        }
        float xin1 = 1.0f;
        float xin2 = 1.0f;
        for (int j = 0; j <= lpcrdr; ++j) {
            float xout2;
            float xout1;
            int i2 = 0;
            i = 0;
            while (i < m) {
                int n1 = i * 4;
                int n2 = n1 + 1;
                int n3 = n2 + 1;
                n4 = n3 + 1;
                xout1 = xin1 - 2.0f * freq[i2] * this.pw[n1] + this.pw[n2];
                xout2 = xin2 - 2.0f * freq[i2 + 1] * this.pw[n3] + this.pw[n4];
                this.pw[n2] = this.pw[n1];
                this.pw[n4] = this.pw[n3];
                this.pw[n1] = xin1;
                this.pw[n3] = xin2;
                xin1 = xout1;
                xin2 = xout2;
                ++i;
                i2 += 2;
            }
            xout1 = xin1 + this.pw[n4 + 1];
            xout2 = xin2 - this.pw[n4 + 2];
            ak[j] = (xout1 + xout2) * 0.5f;
            this.pw[n4 + 1] = xin1;
            this.pw[n4 + 2] = xin2;
            xin1 = 0.0f;
            xin2 = 0.0f;
        }
    }

    public static void enforce_margin(float[] lsp, int len, float margin) {
        if (lsp[0] < margin) {
            lsp[0] = margin;
        }
        if (lsp[len - 1] > (float)Math.PI - margin) {
            lsp[len - 1] = (float)Math.PI - margin;
        }
        for (int i = 1; i < len - 1; ++i) {
            if (lsp[i] < lsp[i - 1] + margin) {
                lsp[i] = lsp[i - 1] + margin;
            }
            if (!(lsp[i] > lsp[i + 1] - margin)) continue;
            lsp[i] = 0.5f * (lsp[i] + lsp[i + 1] - margin);
        }
    }
}

