/*
 * Decompiled with CFR 0.152.
 */
package javaforce.codec.speex;

import javaforce.codec.speex.Codebook;
import javaforce.codec.speex.Filters;
import javaforce.codec.speex.LbrLspQuant;
import javaforce.codec.speex.Lsp;
import javaforce.codec.speex.Ltp3Tap;
import javaforce.codec.speex.LtpForcedPitch;
import javaforce.codec.speex.NbLspQuant;
import javaforce.codec.speex.NoiseSearch;
import javaforce.codec.speex.SplitShapeSearch;
import javaforce.codec.speex.SubMode;

public class NbCodec
implements Codebook {
    public static final float VERY_SMALL = 0.0f;
    public static final int[] NB_FRAME_SIZE = new int[]{5, 43, 119, 160, 220, 300, 364, 492, 79, 1, 1, 1, 1, 1, 1, 1};
    public static final int NB_SUBMODES = 16;
    public static final int NB_SUBMODE_BITS = 4;
    public static final float[] exc_gain_quant_scal1 = new float[]{-0.35f, 0.05f};
    public static final float[] exc_gain_quant_scal3 = new float[]{-2.79475f, -1.81066f, -1.16985f, -0.848119f, -0.58719f, -0.329818f, -0.063266f, 0.282826f};
    protected final Lsp m_lsp = new Lsp();
    protected final Filters filters = new Filters();
    protected SubMode[] submodes;
    protected int submodeID;
    protected int first;
    protected int frameSize;
    protected int subframeSize;
    protected int nbSubframes;
    protected int windowSize;
    protected int lpcSize;
    protected int bufSize;
    protected int min_pitch;
    protected int max_pitch;
    protected float gamma1;
    protected float gamma2;
    protected float lag_factor;
    protected float lpc_floor;
    protected float preemph;
    protected float pre_mem;
    protected float[] frmBuf;
    protected int frmIdx;
    protected float[] excBuf;
    protected int excIdx;
    protected float[] innov;
    protected float[] lpc;
    protected float[] qlsp;
    protected float[] old_qlsp;
    protected float[] interp_qlsp;
    protected float[] interp_qlpc;
    protected float[] mem_sp;
    protected float[] pi_gain;
    protected float[] awk1;
    protected float[] awk2;
    protected float[] awk3;
    protected float voc_m1;
    protected float voc_m2;
    protected float voc_mean;
    protected int voc_offset;
    protected int dtx_enabled;

    public void nbinit() {
        this.submodes = NbCodec.buildNbSubModes();
        this.submodeID = 5;
        this.init(160, 40, 10, 640);
    }

    protected void init(int frameSize, int subframeSize, int lpcSize, int bufSize) {
        this.first = 1;
        this.frameSize = frameSize;
        this.windowSize = frameSize * 3 / 2;
        this.subframeSize = subframeSize;
        this.nbSubframes = frameSize / subframeSize;
        this.lpcSize = lpcSize;
        this.bufSize = bufSize;
        this.min_pitch = 17;
        this.max_pitch = 144;
        this.preemph = 0.0f;
        this.pre_mem = 0.0f;
        this.gamma1 = 0.9f;
        this.gamma2 = 0.6f;
        this.lag_factor = 0.01f;
        this.lpc_floor = 1.0001f;
        this.frmBuf = new float[bufSize];
        this.frmIdx = bufSize - this.windowSize;
        this.excBuf = new float[bufSize];
        this.excIdx = bufSize - this.windowSize;
        this.innov = new float[frameSize];
        this.lpc = new float[lpcSize + 1];
        this.qlsp = new float[lpcSize];
        this.old_qlsp = new float[lpcSize];
        this.interp_qlsp = new float[lpcSize];
        this.interp_qlpc = new float[lpcSize + 1];
        this.mem_sp = new float[5 * lpcSize];
        this.pi_gain = new float[this.nbSubframes];
        this.awk1 = new float[lpcSize + 1];
        this.awk2 = new float[lpcSize + 1];
        this.awk3 = new float[lpcSize + 1];
        this.voc_mean = 0.0f;
        this.voc_m2 = 0.0f;
        this.voc_m1 = 0.0f;
        this.voc_offset = 0;
        this.dtx_enabled = 0;
    }

    private static SubMode[] buildNbSubModes() {
        Ltp3Tap ltpNb = new Ltp3Tap(gain_cdbk_nb, 7, 7);
        Ltp3Tap ltpVlbr = new Ltp3Tap(gain_cdbk_lbr, 5, 0);
        Ltp3Tap ltpLbr = new Ltp3Tap(gain_cdbk_lbr, 5, 7);
        Ltp3Tap ltpMed = new Ltp3Tap(gain_cdbk_lbr, 5, 7);
        LtpForcedPitch ltpFP = new LtpForcedPitch();
        NoiseSearch noiseSearch = new NoiseSearch();
        SplitShapeSearch ssNbVlbrSearch = new SplitShapeSearch(40, 10, 4, exc_10_16_table, 4, 0);
        SplitShapeSearch ssNbLbrSearch = new SplitShapeSearch(40, 10, 4, exc_10_32_table, 5, 0);
        SplitShapeSearch ssNbSearch = new SplitShapeSearch(40, 5, 8, exc_5_64_table, 6, 0);
        SplitShapeSearch ssNbMedSearch = new SplitShapeSearch(40, 8, 5, exc_8_128_table, 7, 0);
        SplitShapeSearch ssSbSearch = new SplitShapeSearch(40, 5, 8, exc_5_256_table, 8, 0);
        SplitShapeSearch ssNbUlbrSearch = new SplitShapeSearch(40, 20, 2, exc_20_32_table, 5, 0);
        NbLspQuant nbLspQuant = new NbLspQuant();
        LbrLspQuant lbrLspQuant = new LbrLspQuant();
        SubMode[] nbSubModes = new SubMode[16];
        nbSubModes[1] = new SubMode(0, 1, 0, 0, lbrLspQuant, ltpFP, noiseSearch, 0.7f, 0.7f, -1.0f, 43);
        nbSubModes[2] = new SubMode(0, 0, 0, 0, lbrLspQuant, ltpVlbr, ssNbVlbrSearch, 0.7f, 0.5f, 0.55f, 119);
        nbSubModes[3] = new SubMode(-1, 0, 1, 0, lbrLspQuant, ltpLbr, ssNbLbrSearch, 0.7f, 0.55f, 0.45f, 160);
        nbSubModes[4] = new SubMode(-1, 0, 1, 0, lbrLspQuant, ltpMed, ssNbMedSearch, 0.7f, 0.63f, 0.35f, 220);
        nbSubModes[5] = new SubMode(-1, 0, 3, 0, nbLspQuant, ltpNb, ssNbSearch, 0.7f, 0.65f, 0.25f, 300);
        nbSubModes[6] = new SubMode(-1, 0, 3, 0, nbLspQuant, ltpNb, ssSbSearch, 0.68f, 0.65f, 0.1f, 364);
        nbSubModes[7] = new SubMode(-1, 0, 3, 1, nbLspQuant, ltpNb, ssNbSearch, 0.65f, 0.65f, -1.0f, 492);
        nbSubModes[8] = new SubMode(0, 1, 0, 0, lbrLspQuant, ltpFP, ssNbUlbrSearch, 0.7f, 0.5f, 0.65f, 79);
        return nbSubModes;
    }

    public int getFrameSize() {
        return this.frameSize;
    }

    public boolean getDtx() {
        return this.dtx_enabled != 0;
    }

    public float[] getPiGain() {
        return this.pi_gain;
    }

    public float[] getExc() {
        float[] excTmp = new float[this.frameSize];
        System.arraycopy(this.excBuf, this.excIdx, excTmp, 0, this.frameSize);
        return excTmp;
    }

    public float[] getInnov() {
        return this.innov;
    }
}

