/*
 * Decompiled with CFR 0.152.
 */
package javaforce.gl.model;

import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javaforce.JFLog;
import javaforce.gl.Model;
import javaforce.gl.Object3;
import javaforce.gl.UVMap;
import javaforce.gl.model.Model_IO;

public class ModelOBJ
implements Model_IO {
    private static boolean debug = false;

    public Model load(String filename) {
        try {
            FileInputStream is = new FileInputStream(filename);
            Model model = this.loadObj(is);
            ((InputStream)is).close();
            return model;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Model load(InputStream is) {
        try {
            return this.loadObj(is);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private Model loadObj(InputStream is) {
        try {
            Model model = new Model();
            Object3 object = null;
            UVMap map = null;
            float[] xyz = new float[3];
            float[] uv = new float[2];
            int[] pts = new int[1];
            int pidx = 0;
            ArrayList<Vertex> verts = new ArrayList<Vertex>();
            ArrayList<UV> uvs = new ArrayList<UV>();
            byte[] data = is.readAllBytes();
            String[] lns = new String(data).replaceAll("\r", "").split("\n");
            verts.add(new Vertex());
            uvs.add(new UV());
            block14: for (String ln : lns) {
                String[] fs;
                if ((ln = ln.trim()).startsWith("#") || (fs = ln.split("[ ]+")).length == 0) continue;
                switch (fs[0]) {
                    case "o": {
                        object = new Object3();
                        object.name = fs[1];
                        object.type = 7;
                        pidx = 0;
                        model.addObject(object);
                        map = object.createUVMap();
                        map.name = "normal";
                        if (!debug) continue block14;
                        JFLog.log("obj:object=" + object.name);
                        continue block14;
                    }
                    case "v": {
                        xyz[0] = Float.valueOf(fs[1]).floatValue();
                        xyz[1] = Float.valueOf(fs[2]).floatValue();
                        xyz[2] = Float.valueOf(fs[3]).floatValue();
                        verts.add(new Vertex(xyz));
                        if (!debug) continue block14;
                        JFLog.log("obj:vert=" + xyz[0] + "," + xyz[1] + "," + xyz[2]);
                        continue block14;
                    }
                    case "vt": {
                        uv[0] = Float.valueOf(fs[1]).floatValue();
                        uv[1] = Float.valueOf(fs[2]).floatValue();
                        uvs.add(new UV(uv));
                        if (!debug) continue block14;
                        JFLog.log("obj:uv=" + uv[0] + "," + uv[1]);
                        continue block14;
                    }
                    case "f": {
                        if (debug) {
                            JFLog.log("obj:face.length=" + (fs.length - 1));
                        }
                        for (int i = 1; i < fs.length; ++i) {
                            String[] idxs = fs[i].split("/");
                            int vidx = Integer.valueOf(idxs[0]);
                            int vtidx = Integer.valueOf(idxs[1]);
                            pts[0] = pidx++;
                            if (debug) {
                                JFLog.log("obj:face.idxs=" + vidx + "," + vtidx);
                            }
                            object.addVertex(((Vertex)verts.get((int)vidx)).xyz);
                            object.addText(((UV)uvs.get((int)vtidx)).uv);
                            object.addPoly(pts);
                        }
                        continue block14;
                    }
                }
            }
            return model;
        }
        catch (Exception e) {
            JFLog.log(e);
            return null;
        }
    }

    @Override
    public boolean save(Model model, OutputStream os) {
        return false;
    }

    private static class Vertex {
        float[] xyz = new float[3];

        public Vertex() {
        }

        public Vertex(float[] in) {
            this.xyz[0] = in[0];
            this.xyz[1] = in[1];
            this.xyz[2] = in[2];
        }
    }

    private static class UV {
        float[] uv = new float[2];

        public UV() {
        }

        public UV(float[] in) {
            this.uv[0] = in[0];
            this.uv[1] = in[1];
        }
    }
}

