/*
 * Decompiled with CFR 0.152.
 */
package javaforce.utils;

import java.io.File;
import java.io.FileOutputStream;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.utils.BuildTools;
import javaforce.utils.GenPkgInfo;

public class GenDEB {
    private BuildTools tools;

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Usage:GenDEB build.xml depends");
            System.exit(1);
        }
        try {
            new GenDEB().run(args[0], args[1]);
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    public void run(String buildfile, String deps) throws Exception {
        String files = "files.lst";
        if (new File("files-debian.lst").exists()) {
            files = "files-debian.lst";
        }
        if (!JF.isWindows() && !new File("/usr/bin/bzip2").exists()) {
            JFLog.log("Error:bzip2 not installed");
            System.exit(1);
        }
        if (!BuildTools.checkFiles(files)) {
            System.exit(1);
        }
        String arch = GenDEB.getArch();
        String archext = GenDEB.getArchExt();
        this.tools = new BuildTools();
        if (!this.tools.loadXML(buildfile)) {
            throw new Exception("error loading " + buildfile);
        }
        String app = this.tools.getProperty("app");
        Object apptype = this.tools.getProperty("apptype");
        String version = this.tools.getProperty("version");
        String home = this.tools.getProperty("home");
        switch (apptype) {
            case "client": 
            case "server": {
                apptype = "-" + (String)apptype;
                break;
            }
            default: {
                apptype = "";
            }
        }
        String out = app + (String)apptype + "-" + version + "_" + archext + ".deb";
        String control = "control.tar.gz";
        String data = "data.tar.bz2";
        String debian_binary = "debian-binary";
        Runtime rt = Runtime.getRuntime();
        try {
            int ret;
            GenPkgInfo.main(new String[]{"debian", arch, files, deps});
            if (new File(control).exists()) {
                new File(control).delete();
            }
            if ((ret = rt.exec(new String[]{"tar", "czf", control, "-C", "deb", "."}).waitFor()) != 0) {
                throw new Exception("Failed to build control.tar.gz : ret = " + ret);
            }
            if (new File(data).exists()) {
                new File(data).delete();
            }
            if ((ret = rt.exec(new String[]{"tar", "cjf", data, "-T", files}).waitFor()) != 0) {
                throw new Exception("Failed to build data.tar.bz2 : ret = " + ret);
            }
            if (new File(out).exists()) {
                new File(out).delete();
            }
            FileOutputStream bin = new FileOutputStream(debian_binary);
            bin.write("2.0\n".getBytes());
            bin.close();
            ret = rt.exec(new String[]{"ar", "mc", out, debian_binary, control, data}).waitFor();
            if (ret != 0) {
                throw new Exception("Failed to build " + out + " : ret = " + ret);
            }
            new File(debian_binary).delete();
            new File(control).delete();
            new File(data).delete();
            JF.deletePathEx("deb");
            System.out.println(out + " created!");
            if (new File(home + "/repo/debian/readme.txt").exists() && !JF.moveFile(out, home + "/repo/debian/" + arch + "/" + out)) {
                throw new Exception("move failed");
            }
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static String getArch() {
        String arch = System.getenv("HOSTTYPE");
        if (arch == null && (arch = System.getProperty("os.arch")) == null) {
            JFLog.log("Error:Unable to detect CPU from env:HOSTTYPE or property:os.arch");
        }
        switch (arch) {
            case "x86_64": {
                return "amd64";
            }
            case "aarch64": {
                return "arm64";
            }
        }
        return arch;
    }

    public static String getArchExt() {
        return GenDEB.getArch();
    }
}

