/*
 * Decompiled with CFR 0.152.
 */
package javaforce.voip;

import javaforce.BE;
import javaforce.JFLog;
import javaforce.codec.g729a.Decoder;
import javaforce.codec.g729a.Encoder;
import javaforce.voip.RTP;
import javaforce.voip.RTPAudioCoder;
import javaforce.voip.RTPChannel;

public class g729a
implements RTPAudioCoder {
    private Encoder encoder = new Encoder();
    private Decoder decoder = new Decoder();
    private RTP rtp;
    private byte[] encoded = new byte[32];
    private int decode_timestamp;
    private short[] decoded = new short[160];

    public g729a(RTP rtp) {
        this.rtp = rtp;
    }

    @Override
    public void setid(int id) {
    }

    @Override
    public int getPacketSize() {
        return 20;
    }

    @Override
    public byte[] encode(short[] samples) {
        RTPChannel rtpChannel = this.rtp.getDefaultChannel();
        RTPChannel.buildHeader(this.encoded, 18, rtpChannel.getseqnum(), rtpChannel.gettimestamp(160), rtpChannel.getssrc(), false);
        this.encoder.encode(this.encoded, 12, samples, 0, 2);
        return this.encoded;
    }

    @Override
    public short[] decode(byte[] encoded, int off, int length) {
        int decode_timestamp = BE.getuint32(encoded, off + 4);
        if (this.decode_timestamp == 0) {
            this.decode_timestamp = decode_timestamp;
        } else {
            if (RTP.debug) {
                JFLog.log("G729a:timestamp = " + decode_timestamp + ":" + (this.decode_timestamp + 160 == decode_timestamp ? "ok" : "lost packet"));
            }
            this.decode_timestamp = decode_timestamp;
        }
        this.decoder.decode(this.decoded, 0, encoded, off + 12, 2);
        return this.decoded;
    }

    @Override
    public int getSampleRate() {
        return 8000;
    }
}

