/*
 * Decompiled with CFR 0.152.
 */
package javaforce.voip;

import java.util.Random;
import javaforce.BE;
import javaforce.JFLog;
import javaforce.codec.speex.SpeexDecoder;
import javaforce.codec.speex.SpeexEncoder;
import javaforce.voip.RTP;
import javaforce.voip.RTPAudioCoder;
import javaforce.voip.RTPChannel;
import javaforce.voip.SDP;

public class speex
implements RTPAudioCoder {
    private static boolean debug = false;
    private int mode = 0;
    private static int quality = 5;
    private static boolean enhanced = false;
    private SpeexEncoder encoder = new SpeexEncoder();
    private SpeexDecoder decoder = new SpeexDecoder();
    private RTP rtp;
    private int rtp_id;
    private int rate;
    private int nsamples;
    private byte[] encoded;
    private int decode_timestamp;
    private short[] decoded;

    public speex(RTP rtp, int rate) {
        this.rtp = rtp;
        this.rate = rate;
        switch (rate) {
            case 8000: {
                this.nsamples = 160;
                this.mode = 0;
                break;
            }
            case 16000: {
                this.nsamples = 320;
                this.mode = 1;
                break;
            }
            case 32000: {
                this.nsamples = 640;
                this.mode = 2;
            }
        }
        this.encoder.init(this.mode, quality, rate, 1);
        this.decoder.init(this.mode, rate, 1, enhanced);
        this.encoded = new byte[12];
        this.decoded = new short[this.nsamples];
    }

    @Override
    public void setid(int id) {
        this.rtp_id = id;
    }

    @Override
    public int getPacketSize() {
        return -1;
    }

    public speex setQuality(int value) {
        if (value < 0) {
            value = 0;
        }
        if (value > 10) {
            value = 10;
        }
        quality = value;
        return this;
    }

    public speex setEnhancedMode(boolean mode) {
        enhanced = mode;
        return this;
    }

    @Override
    public byte[] encode(short[] samples) {
        this.encoder.processData(samples, 0, samples.length);
        int encoded_length = this.encoder.getProcessedDataByteSize();
        if (debug) {
            JFLog.log("speex:encoded.size=" + encoded_length);
        }
        if (this.encoded.length != encoded_length + 12) {
            this.encoded = new byte[encoded_length + 12];
        }
        this.encoder.getProcessedData(this.encoded, 12);
        RTPChannel rtpChannel = this.rtp.getDefaultChannel();
        RTPChannel.buildHeader(this.encoded, this.rtp_id, rtpChannel.getseqnum(), rtpChannel.gettimestamp(this.nsamples), rtpChannel.getssrc(), false);
        return this.encoded;
    }

    @Override
    public short[] decode(byte[] encoded, int off, int length) {
        int decode_timestamp = BE.getuint32(encoded, off + 4);
        if (this.decode_timestamp == 0) {
            this.decode_timestamp = decode_timestamp;
        } else {
            if (RTP.debug) {
                JFLog.log("speex:timestamp = " + decode_timestamp + ":" + (this.decode_timestamp + this.nsamples == decode_timestamp ? "ok" : "lost packet"));
            }
            this.decode_timestamp = decode_timestamp;
        }
        try {
            this.decoder.processData(encoded, 12, length - 12);
            if (debug) {
                JFLog.log("speex.decoded.size=" + this.decoder.getProcessedDataByteSize() / 2);
            }
            this.decoder.getProcessedData(this.decoded, 0);
        }
        catch (Exception e) {
            JFLog.log("Error:speex:decode:" + String.valueOf(e));
            JFLog.log(e);
        }
        return this.decoded;
    }

    @Override
    public int getSampleRate() {
        return this.rate;
    }

    private static void test(int rate) {
        try {
            RTP rtp = new RTP();
            SDP sdp = new SDP();
            sdp.setIP("1.2.3.4");
            SDP.Stream stream = sdp.addStream(SDP.Type.audio);
            rtp.createChannel(stream);
            speex sx = new speex(rtp, rate);
            short[] samples = new short[sx.nsamples];
            Random r = new Random();
            for (int a = 0; a < sx.nsamples; ++a) {
                samples[a] = (short)(r.nextInt(65535) - Short.MAX_VALUE);
            }
            byte[] data = sx.encode(samples);
            short[] out = sx.decode(data, 0, data.length);
            JFLog.log("out.length=" + out.length);
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    private static native long speexdspinit(int var0);

    public static long speex_dsp_init(int sample_rate) {
        return speex.speexdspinit(sample_rate);
    }

    public static native void speexdspuninit(long var0);

    public static void speex_dsp_uninit(long ctx) {
        speex.speexdspuninit(ctx);
    }

    public static native void speexdspdenoise(long var0, short[] var2);

    public static void speex_dsp_denoise(long ctx, short[] audio) {
        speex.speexdspdenoise(ctx, audio);
    }

    public static native void speexdspecho(long var0, short[] var2, short[] var3, short[] var4);

    public static void speex_dsp_echo(long ctx, short[] audio_mic, short[] audio_spk, short[] audio_out) {
        speex.speexdspecho(ctx, audio_mic, audio_spk, audio_out);
    }

    private static void noise(short[] audio) {
        Random r = new Random();
        int len = audio.length;
        for (int i = 0; i < len; ++i) {
            audio[i] = (short)(r.nextInt(65535) - Short.MAX_VALUE);
        }
    }

    private static long avg(short[] audio) {
        long sum = 0L;
        int len = audio.length;
        for (int i = 0; i < len; ++i) {
            sum += (long)audio[i];
        }
        return sum / (long)len;
    }

    private static void test_dsp() {
        short[] mic = new short[160];
        short[] spk = new short[160];
        short[] out = new short[160];
        speex.noise(mic);
        speex.noise(spk);
        long ctx = speex.speex_dsp_init(8000);
        JFLog.log("spk.avg=" + speex.avg(spk));
        JFLog.log("mic.avg=" + speex.avg(mic));
        speex.speex_dsp_denoise(ctx, mic);
        JFLog.log("mic.avg=" + speex.avg(mic));
        speex.speex_dsp_echo(ctx, mic, spk, out);
        JFLog.log("out.avg=" + speex.avg(out));
        speex.speex_dsp_uninit(ctx);
    }

    public static void main(String[] args) {
        debug = true;
        speex.test(8000);
        speex.test(16000);
        speex.test(32000);
        speex.test_dsp();
    }
}

