/*
 * Decompiled with CFR 0.152.
 */
package javaforce.webui;

import java.io.ByteArrayOutputStream;
import javaforce.awt.JFImage;
import javaforce.webui.Container;
import javaforce.webui.Point;
import javaforce.webui.Rectangle;

public class Canvas
extends Container {
    private Rectangle rect;

    public Canvas() {
        this.setStyle("contentEditable", "true");
        this.setStyle("outline", "none");
        this.addAttr("tabindex", "1");
    }

    @Override
    public String html() {
        StringBuilder sb = new StringBuilder();
        sb.append("<canvas" + this.getAttrs());
        if (this.width != 0) {
            sb.append(" width='" + this.width + "'");
        }
        if (this.height != 0) {
            sb.append(" height='" + this.height + "'");
        }
        sb.append(">");
        int cnt = this.count();
        for (int a = 0; a < cnt; ++a) {
            sb.append(this.get(a).html());
        }
        sb.append("</canvas>");
        return sb.toString();
    }

    public void initWebGL() {
        this.sendEvent("initwebgl", null);
    }

    public void enableDrawRect() {
        this.addEvent("onmousedown", "onMouseDownCanvas(event, this);");
        this.addEvent("onmouseup", "onMouseUpCanvas(event, this);");
        this.addEvent("onmousemove", "onMouseMoveCanvasDrawRect(event, this);");
    }

    public Rectangle getRect() {
        return this.rect;
    }

    public void drawRect(int clr, Rectangle rect) {
        this.sendEvent("drawrect", new String[]{"clr=#" + String.format("%06x", clr), "x=" + rect.x, "y=" + rect.y, "w=" + rect.width, "h=" + rect.height});
    }

    public void drawImage(JFImage image, Point at) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        image.savePNG(os);
        byte[] data = os.toByteArray();
        this.sendData(data);
        this.sendEvent("drawimage", new String[]{"x=" + at.x, "y=" + at.y});
    }

    @Override
    public void onDrawRect(Rectangle rect) {
        this.rect = rect;
        this.onChanged(null);
    }
}

