/*
 * Decompiled with CFR 0.152.
 */
package javaforce;

import java.util.Arrays;

public class JFArrayByte {
    private byte[] buf = new byte[initSize];
    private int count = 0;
    public static int initSize = 64;

    public int size() {
        return this.count;
    }

    public void clear() {
        this.count = 0;
        if (this.buf.length != initSize) {
            this.buf = new byte[initSize];
        }
    }

    public void append(byte s) {
        int newcount = this.count + 1;
        if (newcount > this.buf.length) {
            this.buf = Arrays.copyOf(this.buf, Math.max(this.buf.length << 1, newcount));
        }
        this.buf[this.count] = s;
        this.count = newcount;
    }

    public void append(byte[] s) {
        int newcount = this.count + s.length;
        if (newcount > this.buf.length) {
            this.buf = Arrays.copyOf(this.buf, Math.max(this.buf.length << 1, newcount));
        }
        System.arraycopy(s, 0, this.buf, this.count, s.length);
        this.count = newcount;
    }

    public void set(byte[] s, int pos) {
        int newcount = pos + s.length;
        if (newcount > this.buf.length) {
            this.buf = Arrays.copyOf(this.buf, Math.max(this.buf.length << 1, newcount));
        }
        System.arraycopy(s, 0, this.buf, pos, s.length);
    }

    public byte[] toArray() {
        return Arrays.copyOf(this.buf, this.count);
    }

    public byte[] toArray(int pos, int length) {
        return Arrays.copyOfRange(this.buf, pos, pos + length);
    }

    public byte[] getBuffer() {
        return this.buf;
    }
}

