/*
 * Decompiled with CFR 0.152.
 */
package javaforce.awt;

import java.awt.GraphicsDevice;
import java.awt.Rectangle;
import java.awt.Robot;
import javaforce.JFLog;
import javaforce.awt.JFImage;
import javaforce.awt.RFB;
import javaforce.awt.VNCRobot;

public class VNCJavaRobot
implements VNCRobot {
    private Robot robot;
    private GraphicsDevice screen;

    public VNCJavaRobot(GraphicsDevice screen) {
        this.screen = screen;
        try {
            this.robot = new Robot(screen);
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    public void setRobot(GraphicsDevice screen) {
        this.screen = screen;
        try {
            this.robot = new Robot(screen);
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    @Override
    public Rectangle getScreenSize() {
        return this.screen.getDefaultConfiguration().getBounds();
    }

    @Override
    public int[] getScreenCapture(int pf) {
        int[] rgb = JFImage.createScreenCapture(this.screen).getBuffer();
        if (pf == RFB.PF_RGB) {
            return rgb;
        }
        return RFB.swapPixelFormat(rgb);
    }

    @Override
    public void keyPress(int code) {
        try {
            this.robot.keyPress(code);
        }
        catch (Exception e) {
            JFLog.log(e);
            JFLog.log("invalid code=" + code);
        }
    }

    @Override
    public void keyRelease(int code) {
        try {
            this.robot.keyRelease(code);
        }
        catch (Exception e) {
            JFLog.log(e);
            JFLog.log("invalid code=" + code);
        }
    }

    @Override
    public void mouseMove(int x, int y) {
        try {
            this.robot.mouseMove(x, y);
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    @Override
    public void mousePress(int button) {
        try {
            this.robot.mousePress(button);
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    @Override
    public void mouseRelease(int button) {
        try {
            this.robot.mouseRelease(button);
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    @Override
    public boolean active() {
        return true;
    }

    @Override
    public void close() {
    }
}

