/*
 * Decompiled with CFR 0.152.
 */
package javaforce.webui;

import javaforce.webui.Block;
import javaforce.webui.Color;
import javaforce.webui.Container;

public class ProgressBar
extends Container {
    public int clr0;
    public int clr1;
    public int clr2;
    public float lvl0;
    public float lvl1;
    private int dir;
    private float max;
    private float value;
    private Block bar;
    private int barWidth;

    public ProgressBar(int dir, float max, int barWidth) {
        this.barWidth = barWidth;
        this.value = 0.0f;
        this.max = max;
        this.bar = new Block();
        this.add(this.bar);
        this.setBackColor(Color.grey);
        this.setDir(dir);
        switch (dir) {
            case 2: {
                this.setSize(100, barWidth);
                break;
            }
            case 1: {
                this.setSize(barWidth, 100);
            }
        }
        this.setSize();
        this.clr0 = Color.red;
        this.clr1 = Color.yellow;
        this.clr2 = Color.green;
        this.lvl0 = 5.0f;
        this.lvl1 = 10.0f;
        this.setColor();
    }

    public void setBarWidth(int size) {
        this.barWidth = size;
    }

    private void setSize() {
        switch (this.dir) {
            case 2: {
                this.setSize(this.width, this.barWidth);
                this.bar.setSize((int)(this.value / this.max * (float)this.width), this.barWidth);
                break;
            }
            case 1: {
                this.setSize(this.barWidth, this.height);
                this.bar.setSize(this.barWidth, (int)(this.value / this.max * (float)this.height));
            }
        }
    }

    public void setColors(int clr0, int clr1, int clr2) {
        this.clr0 = clr0;
        this.clr1 = clr1;
        this.clr2 = clr2;
        this.setColor();
    }

    public void setLevels(float lvl0, float lvl1, float max) {
        this.lvl0 = lvl0;
        this.lvl1 = lvl1;
        this.max = max;
        this.setColor();
    }

    public void setValue(float value) {
        if (value < 0.0f) {
            value = 0.0f;
        }
        if (value > this.max) {
            value = this.max;
        }
        this.value = value;
        this.setSize();
        this.setColor();
    }

    public float getValue() {
        return this.value;
    }

    private void setColor() {
        if (this.value <= this.lvl0) {
            this.bar.setBackColor(this.clr0);
        } else if (this.value <= this.lvl1) {
            this.bar.setBackColor(this.clr1);
        } else {
            this.bar.setBackColor(this.clr2);
        }
    }

    public void setDir(int dir) {
        this.dir = dir;
        switch (dir) {
            case 1: {
                this.setClass("");
                this.setStyle("margin-top", this.max + "px");
                break;
            }
            case 2: {
                this.setClass("");
                this.setStyle("margin-top", "0px");
            }
        }
    }
}

