/*
 * Decompiled with CFR 0.152.
 */
package javaforce.webui;

import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import javaforce.HTTP;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.JSON;
import javaforce.KeyMgmt;
import javaforce.service.WebHandler;
import javaforce.service.WebRequest;
import javaforce.service.WebResponse;
import javaforce.service.WebServer;
import javaforce.service.WebSocket;
import javaforce.service.WebSocketHandler;
import javaforce.webui.Resource;
import javaforce.webui.WebUIClient;
import javaforce.webui.WebUIHandler;

public class WebUIServer
implements WebHandler,
WebSocketHandler {
    private WebServer web;
    private WebUIHandler handler;
    public static boolean debug = false;
    public static boolean debug_tid = false;
    public ArrayList<WebUIClient> clients = new ArrayList();

    public void start(WebUIHandler handler, int port) {
        this.start(handler, port, null);
    }

    public void start(WebUIHandler handler, int port, KeyMgmt keys) {
        this.handler = handler;
        if (this.web != null) {
            this.stop();
        }
        this.web = new WebServer();
        this.web.setWebSocketHandler(this);
        this.web.start(this, port, keys);
        JFLog.log("WebUI Server starting on port " + port + "...");
    }

    public void stop() {
        if (this.web != null) {
            this.web.stop();
            this.web = null;
        }
    }

    public void setClientVerify(boolean state) {
        this.web.setClientVerify(state);
    }

    public byte[] getResource(String name) {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(name);
        if (is == null) {
            JFLog.log("WebUIServer:Resource not found:" + name);
            return null;
        }
        return JF.readAll(is);
    }

    @Override
    public void doPost(WebRequest req, WebResponse res) {
        this.doGet(req, res);
    }

    @Override
    public void doGet(WebRequest req, WebResponse res) {
        String url = req.getURL();
        HTTP.Parameters params = HTTP.Parameters.decode(req.getQueryString());
        byte[] data = null;
        if (url.equals("/favicon.ico")) {
            url = "/webui.png";
        }
        if (url.endsWith(".css")) {
            res.setContentType("text/css");
        } else if (url.endsWith(".png")) {
            res.setContentType("image/png");
        } else if (url.endsWith(".js")) {
            res.setContentType("text/javascript");
        }
        if (url.startsWith("/static/")) {
            Resource r = Resource.getResource(url.substring(8));
            if (r != null) {
                data = r.data;
                res.setContentType(r.mime);
            }
        } else if (url.startsWith("/user/")) {
            data = this.handler.getResource(url, params, res);
            res.addHeader("Cache-Control: no-store");
        } else if (url.startsWith("/api/")) {
            data = this.handler.getResource(url, params, res);
            res.addHeader("Cache-Control: no-store");
        } else {
            String browser;
            int idx = url.indexOf(46);
            if (idx == -1) {
                url = "/webui.html";
            }
            if ((browser = req.getHeader("User-Agent")) != null && browser.indexOf("Trident") != -1) {
                url = "/webui-ie.html";
            }
            data = this.getResource("javaforce/webui/static" + url);
        }
        if (data == null) {
            res.setStatus(404, "Resource not found");
            return;
        }
        try {
            res.write(data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public WebUIClient getClient(WebSocket sock) {
        int cnt = this.clients.size();
        for (int a = 0; a < cnt; ++a) {
            WebUIClient client = this.clients.get(a);
            if (client.socket != sock) continue;
            return client;
        }
        return null;
    }

    public WebUIClient getClient(String hash) {
        int cnt = this.clients.size();
        for (int a = 0; a < cnt; ++a) {
            WebUIClient client = this.clients.get(a);
            if (!client.hash.equals(hash)) continue;
            return client;
        }
        return null;
    }

    @Override
    public boolean doWebSocketConnect(WebSocket sock) {
        try {
            WebUIClient client = new WebUIClient(sock, this.handler);
            this.clients.add(client);
            this.handler.clientConnected(client);
            return true;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    @Override
    public void doWebSocketClosed(WebSocket sock) {
        WebUIClient client = this.getClient(sock);
        this.clients.remove(client);
        this.handler.clientDisconnected(client);
    }

    @Override
    public void doWebSocketMessage(WebSocket sock, byte[] data, int type) {
        JSON.Element json;
        WebUIClient client = this.getClient(sock);
        if (client == null) {
            JFLog.log("Unknown Socket:" + String.valueOf(sock));
            return;
        }
        if (type == 2 || type == 0) {
            client.dispatchData(data);
            return;
        }
        String msg = new String(data);
        if (debug) {
            JFLog.log("RECV=" + msg);
        }
        try {
            json = JSON.parse(msg);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        String id = "";
        String event = "";
        ArrayList<CallSite> args = new ArrayList<CallSite>();
        int cnt = json.children.size();
        for (int a = 0; a < cnt; ++a) {
            JSON.Element e = json.children.get(a);
            if (e.key.equals("id")) {
                id = e.value;
                continue;
            }
            if (e.key.equals("event")) {
                event = e.value;
                continue;
            }
            args.add((CallSite)((Object)(e.key + "=" + e.value)));
        }
        try {
            client.dispatchEvent(id, event, args.toArray(JF.StringArrayType));
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }
}

