/*
 * Decompiled with CFR 0.152.
 */
package javaforce;

import javaforce.JFLog;

public class UShort {
    public static final int MIN_VALUE = 0;
    public static final int MAX_VALUE = 65535;
    public static final int MASK = 65535;
    private short value;

    public UShort(short value) {
        this.value = value;
    }

    public short getValue() {
        return this.value;
    }

    public static short valueOf(String s, int radix) throws NumberFormatException {
        int value = Integer.parseUnsignedInt(s, radix);
        if (value < 0 || value > 65535) {
            throw new NumberFormatException("UShort:value out of range");
        }
        return (short)value;
    }

    public static short valueOf(String s) {
        return UShort.valueOf(s, 10);
    }

    public static String toString(short value, int radix) {
        return Integer.toString(value & 0xFFFF, radix);
    }

    public static String toString(short value) {
        return UShort.toString(value, 10);
    }

    public static int compare(short v1, short v2) {
        return Short.compareUnsigned(v1, v2);
    }

    public static void main(String[] args) {
        short val = 0;
        for (int a = 0; a < 16; ++a) {
            String str = UShort.toString(val, 16);
            short v2 = UShort.valueOf(str, 16);
            JFLog.log("short:" + (val & 0xFFFF) + " > " + str + " > " + (v2 & 0xFFFF));
            val = (short)(val + 4369);
        }
    }
}

