/*
 * Decompiled with CFR 0.152.
 */
package javaforce.jni;

import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.net.StandardProtocolFamily;
import java.net.UnixDomainSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javaforce.JFLog;
import javaforce.jni.JFNative;
import javaforce.jni.Library;
import javaforce.linux.X11Listener;

public class LnxNative {
    public static boolean have_x11 = true;
    public static boolean have_gl = true;
    public static boolean have_fuse = true;
    public static boolean have_v4l2 = true;

    private static void load() {
        Library[] libs = new Library[]{new Library("X11"), new Library("GL"), new Library("v4l2"), new Library("pam"), new Library("ncurses")};
        JFNative.findLibraries(new File[]{new File("/usr/lib"), new File(LnxNative.getArchLibFolder())}, libs, ".so");
        LnxNative.lnxInit(libs[0].path, libs[1].path, libs[2].path, libs[3].path, libs[4].path);
    }

    public static String getArchLibFolder() {
        if (new File("/usr/lib/x86_64-linux-gnu").exists()) {
            return "/usr/lib/x86_64-linux-gnu";
        }
        if (new File("/usr/lib/aarch64-linux-gnu").exists()) {
            return "/usr/lib/aarch64-linux-gnu";
        }
        if (new File("/usr/lib64").exists()) {
            return "/usr/lib64";
        }
        JFLog.log("Warning:Arch Lib folder not found!");
        return "/usr/lib";
    }

    private static String readSocketMessage(SocketChannel channel) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        int bytesRead = channel.read(buffer);
        if (bytesRead < 0) {
            return null;
        }
        byte[] bytes = new byte[bytesRead];
        buffer.flip();
        buffer.get(bytes);
        String message = new String(bytes);
        return message;
    }

    private static String getServiceSocket() {
        try {
            String path = Path.of("/proc/self/exe", new String[0]).toRealPath(new LinkOption[0]).toString();
            int idx = path.lastIndexOf(47);
            String app = path.substring(idx + 1);
            String sockpath = "/usr/lib/systemd/system/" + app + ".socket";
            return sockpath;
        }
        catch (Exception e) {
            JFLog.log(e);
            return null;
        }
    }

    private static native boolean lnxInit(String var0, String var1, String var2, String var3, String var4);

    private static void lnxServiceInit() {
        new Thread(){

            @Override
            public void run() {
                try {
                    String socketPath = LnxNative.getServiceSocket();
                    UnixDomainSocketAddress socketAddress = UnixDomainSocketAddress.of(socketPath);
                    ServerSocketChannel serverChannel = ServerSocketChannel.open(StandardProtocolFamily.UNIX);
                    new File(socketPath).delete();
                    serverChannel.bind(socketAddress);
                    boolean active = true;
                    while (active) {
                        String msg;
                        SocketChannel channel = serverChannel.accept();
                        while (active && (msg = LnxNative.readSocketMessage(channel)) != null) {
                            switch (msg) {
                                case "stop": {
                                    LnxNative.lnxServiceStop();
                                    active = false;
                                }
                            }
                        }
                        channel.close();
                        new File(socketPath).delete();
                    }
                }
                catch (Exception e) {
                    JFLog.log(e);
                }
            }
        }.start();
    }

    private static native boolean lnxServiceStop();

    private static void lnxServiceRequestStop() {
        try {
            SocketChannel channel = SocketChannel.open(StandardProtocolFamily.UNIX);
            UnixDomainSocketAddress socketAddress = UnixDomainSocketAddress.of(LnxNative.getServiceSocket());
            channel.connect(socketAddress);
            ByteBuffer buffer = ByteBuffer.allocate(1024);
            buffer.clear();
            buffer.put("stop".getBytes());
            buffer.flip();
            while (buffer.hasRemaining()) {
                channel.write(buffer);
            }
            channel.close();
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    public static native int comOpen(String var0, int var1);

    public static native void comClose(int var0);

    public static native int comRead(int var0, byte[] var1);

    public static native int comWrite(int var0, byte[] var1);

    public static native long ptyAlloc();

    public static native void ptyFree(long var0);

    public static native String ptyOpen(long var0);

    public static native void ptyClose(long var0);

    public static native int ptyRead(long var0, byte[] var2);

    public static native void ptyWrite(long var0, byte[] var2);

    public static native void ptySetSize(long var0, int var2, int var3);

    public static native long ptyChildExec(String var0, String var1, String[] var2, String[] var3);

    public static native int inotify_init();

    public static native int inotify_add_watch(int var0, String var1, int var2);

    public static native int inotify_rm_watch(int var0, int var1);

    public static native byte[] inotify_read(int var0);

    public static native void inotify_close(int var0);

    public static native long x11_get_id(Window var0);

    public static native void x11_set_desktop(long var0);

    public static native void x11_set_dock(long var0);

    public static native void x11_set_strut(long var0, int var2, int var3, int var4, int var5, int var6);

    public static native void x11_tray_main(long var0, int var2, int var3, int var4);

    public static native void x11_tray_reposition(int var0, int var1, int var2);

    public static native int x11_tray_width();

    public static native void x11_tray_stop();

    public static native void x11_set_listener(X11Listener var0);

    public static native void x11_window_list_main();

    public static native void x11_window_list_stop();

    public static native void x11_minimize_all();

    public static native void x11_raise_window(long var0);

    public static native void x11_map_window(long var0);

    public static native void x11_unmap_window(long var0);

    public static native int x11_keysym_to_keycode(char var0);

    public static native boolean x11_send_event(int var0, boolean var1);

    public static native boolean x11_send_event(long var0, int var2, boolean var3);

    public static native boolean authUser(String var0, String var1, String var2);

    public static native void setenv(String var0, String var1);

    public static native void enableConsoleMode();

    public static native void disableConsoleMode();

    public static native int[] getConsoleSize();

    public static native int[] getConsolePos();

    public static native char readConsole();

    public static native boolean peekConsole();

    public static native void writeConsole(int var0);

    public static native void writeConsoleArray(byte[] var0, int var1, int var2);

    public static native int fileGetMode(String var0);

    public static native void fileSetMode(String var0, int var1);

    public static native void fileSetAccessTime(String var0, long var1);

    public static native void fileSetModifiedTime(String var0, long var1);

    public static native long fileGetID(String var0);
}

