/*
 * Decompiled with CFR 0.152.
 */
package javaforce.service;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import javaforce.JFLog;

public class WebSocket {
    protected InputStream is;
    protected OutputStream os;
    protected String url;
    private boolean connected = true;
    private String host;
    public static final int TYPE_CONT = 0;
    public static final int TYPE_TEXT = 1;
    public static final int TYPE_BINARY = 2;
    protected static final int TYPE_CLOSE = 8;
    protected static final int TYPE_PING = 9;
    protected static final int TYPE_PONG = 10;
    public static final int FIN = 128;
    public static final int MASK = 128;
    public Object userobj;

    public WebSocket(String host) {
        this.host = host;
    }

    public String getURL() {
        return this.url;
    }

    public void write(byte[] msg) {
        this.write(msg, 1);
    }

    public void write(byte[] msg, int type) {
        try {
            int len = msg.length;
            if (len > 0x1000000) {
                throw new Exception("WebSocket message > 16MB");
            }
            if (len > 65535) {
                byte[] header = new byte[10];
                header[0] = (byte)(0x80 | type);
                header[1] = 127;
                header[7] = (byte)((len & 0xFF0000) >> 16);
                header[8] = (byte)((len & 0xFF00) >> 8);
                header[9] = (byte)(len & 0xFF);
                this.os.write(header);
            } else if (len >= 126) {
                byte[] header = new byte[]{(byte)(0x80 | type), 126, (byte)((len & 0xFF00) >> 8), (byte)(len & 0xFF)};
                this.os.write(header);
            } else {
                byte[] header = new byte[]{(byte)(0x80 | type), (byte)len};
                this.os.write(header);
            }
            this.os.write(msg);
        }
        catch (SocketException e) {
            this.connected = false;
            JFLog.log("WebSocket closed:" + this.host);
        }
        catch (Exception e) {
            this.connected = false;
            JFLog.log(e);
        }
    }

    public boolean isConnected() {
        return this.connected;
    }
}

