/*
 * Decompiled with CFR 0.152.
 */
package javaforce.ui;

import javaforce.ui.Button;
import javaforce.ui.Image;

public class ToggleButton
extends Button {
    private boolean selected;

    public ToggleButton(String text) {
        super(text);
    }

    @Override
    public void render(Image image) {
        int x = this.pos.x;
        int y = this.pos.y;
        int w = this.size.width;
        int h = this.size.height;
        if (w == 0 || h == 0) {
            return;
        }
        if (this.isSelected()) {
            image.setForeColor(this.getSelectedColor());
        } else {
            image.setForeColor(this.getBackColor());
        }
        image.fill(x, y, w, h);
        super.render(image);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean state) {
        this.selected = state;
    }

    @Override
    protected void doAction() {
        this.setSelected(!this.selected);
        super.doAction();
    }
}

