/*
 * Decompiled with CFR 0.152.
 */
package javaforce.utils;

import java.io.File;
import java.util.ArrayList;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.ShellProcess;
import javaforce.ShellProcessListener;
import javaforce.utils.BuildTools;
import javaforce.utils.ResourceManager;
import javaforce.utils.WinPE;

public class GenExecutable
implements ShellProcessListener {
    private BuildTools tools;

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Usage:GenExecutable build.xml");
            System.exit(1);
        }
        try {
            new GenExecutable().run(args[0]);
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    public void run(String buildfile) throws Exception {
        Object cfg;
        this.tools = new BuildTools();
        if (!this.tools.loadXML(buildfile)) {
            throw new Exception("error loading " + buildfile);
        }
        String home = this.tools.getProperty("home");
        Object app = this.tools.getProperty("app");
        String apptype = this.tools.getProperty("apptype");
        Object ico = this.tools.getProperty("ico");
        if (((String)ico).length() == 0) {
            ico = (String)app + ".ico";
        }
        if (((String)(cfg = this.tools.getProperty("cfg"))).length() == 0) {
            cfg = (String)app + ".cfg";
        }
        String type = "";
        try {
            if (JF.isWindows()) {
                switch (apptype) {
                    case "c": 
                    case "console": {
                        type = "c";
                        break;
                    }
                    case "s": 
                    case "service": {
                        type = "s";
                        break;
                    }
                    case "client": {
                        app = (String)app + "-client";
                        break;
                    }
                    case "server": {
                        app = (String)app + "-server";
                    }
                }
                if (!JF.copyFile(home + "/native/win64" + type + ".exe", (String)app + ".exe")) {
                    throw new Exception("copy error:" + (String)app + ".exe");
                }
                if (!new File((String)app + ".exe").exists()) {
                    throw new Exception("copy error:" + (String)app + ".exe");
                }
                WinPE.main(new String[]{(String)app + ".exe", ico, cfg});
            } else if (JF.isMac()) {
                switch (apptype) {
                    case "client": {
                        app = (String)app + "-client";
                        break;
                    }
                    case "server": {
                        app = (String)app + "-server";
                    }
                }
                JF.copyFile(home + "/native/mac64.bin", (String)app);
            } else {
                switch (apptype) {
                    case "s": 
                    case "service": {
                        type = "s";
                        break;
                    }
                    case "client": {
                        app = (String)app + "-client";
                        break;
                    }
                    case "server": {
                        app = (String)app + "-server";
                    }
                }
                JF.copyFile(home + "/native/linux64" + type + ".bin", (String)app + ".bin");
                ResourceManager.main(new String[]{(String)app + ".bin", cfg});
            }
            System.out.println("Native Executable generated!");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.doSubProjects();
    }

    @Override
    public void shellProcessOutput(String str) {
        System.out.print(str);
    }

    private void doSubProjects() {
        String[] subs;
        for (String project : subs = this.tools.getSubProjects()) {
            ShellProcess sp = new ShellProcess();
            sp.addListener(this);
            String buildfile = project + ".xml";
            ArrayList<Object> cmd = new ArrayList<Object>();
            if (JF.isWindows()) {
                cmd.add("ant.bat");
            } else {
                cmd.add("ant");
            }
            cmd.add("-file");
            cmd.add(buildfile);
            cmd.add("executable");
            JFLog.log("Executing ant -file " + buildfile + " executable");
            sp.run(cmd.toArray(JF.StringArrayType), true);
        }
    }
}

