/*
 * Decompiled with CFR 0.152.
 */
package javaforce.utils;

import java.io.File;
import java.io.FileInputStream;
import javaforce.Base64;
import javaforce.HTTP;
import javaforce.HTTPS;
import javaforce.JFLog;
import javaforce.utils.BuildTools;

public class Publish {
    public static boolean debug = true;
    private BuildTools settings = new BuildTools();
    private String user = "";
    private String pass = "";

    public static void main(String[] args) {
        new Publish().publish(args);
    }

    private void usage() {
        System.out.println("Usage : javaforce.utils.Publish central-bundle.zip");
    }

    private void error(String msg) {
        System.out.println("Error : javaforce.utils.Publish : " + msg);
        System.exit(1);
    }

    private boolean readXML() {
        this.settings.loadXML(System.getProperty("user.home") + "/.m2/settings.xml");
        this.user = this.settings.getTag(new String[]{"settings", "servers", "server", "username"});
        if (this.user == null) {
            this.error("settings.xml:username not found");
        }
        if (debug) {
            JFLog.log("user=" + this.user);
        }
        this.pass = this.settings.getTag(new String[]{"settings", "servers", "server", "password"});
        if (this.pass == null) {
            this.error("settings.xml:password not found");
        }
        if (debug) {
            JFLog.log("pass=" + this.pass);
        }
        return true;
    }

    private String getBearer() {
        String in = this.user + ":" + this.pass;
        String out = new String(Base64.encode(in.getBytes()));
        if (debug) {
            JFLog.log("bearer=" + out);
        }
        return out;
    }

    public void publish(String[] args) {
        if (args.length == 0) {
            this.usage();
            return;
        }
        if (!this.readXML()) {
            return;
        }
        try {
            File file = new File(args[0]);
            if (!file.exists()) {
                this.error(args[0] + " not found");
            }
            FileInputStream fis = new FileInputStream(file);
            byte[] bundle = fis.readAllBytes();
            fis.close();
            HTTP.Part part = new HTTP.Part();
            part.name = "bundle";
            part.filename = "central-bundle.zip";
            part.mimeType = "application/octet-stream";
            part.data = bundle;
            HTTPS http = new HTTPS();
            http.setHeader("Authorization", "Bearer " + this.getBearer());
            ((HTTP)http).open("central.sonatype.com");
            byte[] deploymentID = http.post("/api/v1/publisher/upload?publishingType=USER_MANAGED", new HTTP.Part[]{part});
            System.out.println("DeploymentID=" + new String(deploymentID));
            http.close();
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }
}

