package javaforce.awt;

/** MQTT Viewer
 *
 * @author peter.quiring
 */

import javaforce.*;

public class MQTTViewer extends javax.swing.JFrame implements MQTTEvents {

  /**
   * Creates new form MQTTViewer
   */
  public MQTTViewer() {
    initComponents();
    if (args.length > 0) {
      server.setText(args[0]);
      if (args.length > 1) {
        authenticate.setSelected(true);
        username.setText(args[1]);
        if (args.length > 2) {
          password.setText(args[2]);
        }
      }
    }
  }

  /**
   * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The content of this method is always regenerated by the Form
   * Editor.
   */
  @SuppressWarnings("unchecked")
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {

    jLabel1 = new javax.swing.JLabel();
    server = new javax.swing.JTextField();
    jLabel2 = new javax.swing.JLabel();
    topic = new javax.swing.JTextField();
    start = new javax.swing.JButton();
    jScrollPane1 = new javax.swing.JScrollPane();
    msgs = new javax.swing.JTextArea();
    jLabel3 = new javax.swing.JLabel();
    authenticate = new javax.swing.JCheckBox();
    username = new javax.swing.JTextField();
    jLabel4 = new javax.swing.JLabel();
    password = new javax.swing.JTextField();
    clear = new javax.swing.JButton();

    setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
    setTitle("MQTT Viewer");

    jLabel1.setText("Server");

    server.setText("127.0.0.1");
    server.setMinimumSize(new java.awt.Dimension(200, 22));
    server.setPreferredSize(new java.awt.Dimension(200, 22));

    jLabel2.setText("Topic");

    topic.setText("#");

    start.setText("Start");
    start.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        startActionPerformed(evt);
      }
    });

    msgs.setColumns(20);
    msgs.setRows(5);
    jScrollPane1.setViewportView(msgs);

    jLabel3.setText("Username");

    authenticate.setText("Authenticate");

    username.setMinimumSize(new java.awt.Dimension(100, 22));
    username.setPreferredSize(new java.awt.Dimension(100, 22));

    jLabel4.setText("Password");

    password.setMinimumSize(new java.awt.Dimension(100, 22));
    password.setPreferredSize(new java.awt.Dimension(100, 22));

    clear.setText("Clear");
    clear.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        clearActionPerformed(evt);
      }
    });

    javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
    getContentPane().setLayout(layout);
    layout.setHorizontalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(layout.createSequentialGroup()
        .addContainerGap()
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
          .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 884, Short.MAX_VALUE)
          .addGroup(layout.createSequentialGroup()
            .addComponent(jLabel2)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
            .addComponent(topic))
          .addGroup(layout.createSequentialGroup()
            .addComponent(jLabel1)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
            .addComponent(server, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
            .addComponent(authenticate)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
            .addComponent(jLabel3)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
            .addComponent(username, javax.swing.GroupLayout.PREFERRED_SIZE, 100, javax.swing.GroupLayout.PREFERRED_SIZE)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
            .addComponent(jLabel4)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
            .addComponent(password, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
            .addComponent(clear)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
            .addComponent(start)))
        .addContainerGap())
    );
    layout.setVerticalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(layout.createSequentialGroup()
        .addContainerGap()
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
          .addComponent(jLabel1)
          .addComponent(server, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
          .addComponent(start)
          .addComponent(jLabel3)
          .addComponent(authenticate)
          .addComponent(username, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
          .addComponent(jLabel4)
          .addComponent(password, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
          .addComponent(clear))
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
          .addComponent(jLabel2)
          .addComponent(topic, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 629, Short.MAX_VALUE)
        .addContainerGap())
    );

    pack();
  }// </editor-fold>//GEN-END:initComponents

  private void startActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_startActionPerformed
    start();
  }//GEN-LAST:event_startActionPerformed

  private void clearActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_clearActionPerformed
    clear();
  }//GEN-LAST:event_clearActionPerformed

  /**
   * @param args the command line arguments
   */
  public static void main(String args[]) {
    MQTTViewer.args = args;
    /* Create and display the form */
    java.awt.EventQueue.invokeLater(new Runnable() {
      public void run() {
        new MQTTViewer().setVisible(true);
      }
    });
  }

  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JCheckBox authenticate;
  private javax.swing.JButton clear;
  private javax.swing.JLabel jLabel1;
  private javax.swing.JLabel jLabel2;
  private javax.swing.JLabel jLabel3;
  private javax.swing.JLabel jLabel4;
  private javax.swing.JScrollPane jScrollPane1;
  private javax.swing.JTextArea msgs;
  private javax.swing.JTextField password;
  private javax.swing.JTextField server;
  private javax.swing.JButton start;
  private javax.swing.JTextField topic;
  private javax.swing.JTextField username;
  // End of variables declaration//GEN-END:variables

  private MQTT client;
  private static String[] args;

  public boolean message(String topic, String msg) {
    String ln = topic + "=" + msg + "\r\n";
    msgs.setText(msgs.getText() + ln);
    return true;
  }

  public void start() {
    if (client == null) {
      start_new();
    } else {
      stop();
    }
  }

  public void start_new() {
    String _server = server.getText();
    String _topic = topic.getText();
    msgs.setText("Connecting to " + _server + "...");
    client = new MQTT();
    if (!client.connect(_server)) {
      msgs.setText("Connection failed!");
      client = null;
    }
    if (authenticate.isSelected()) {
      String _user = username.getText();
      String _pass = password.getText();
      client.connect(_user, _pass);
    } else {
      client.connect();
    }
    msgs.setText("Connected to " + _server + "\r\n");
    client.setListener(this);
    client.subscribe(_topic);
    start.setText("Stop");
    setState(false);
  }

  public void stop() {
    client.disconnect();
    client = null;
    start.setText("Start");
    setState(true);
  }

  private void setState(boolean state) {
    server.setEditable(state);
    topic.setEditable(state);
    authenticate.setEnabled(state);
    username.setEditable(state);
    password.setEditable(state);
  }

  private void clear() {
    if (client == null) {
      msgs.setText("");
    } else {
      msgs.setText("Connected to " + server.getText() + "\r\n");
    }
  }
}
