/*
 * Decompiled with CFR 0.152.
 */
package javaforce;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javaforce.JF;
import javaforce.JFLog;

public class HTTP {
    protected Socket s;
    protected OutputStream os;
    protected InputStream is;
    protected String host;
    protected int port;
    private Parameters request_headers = new Parameters();
    private Parameters reply_headers = new Parameters();
    private String accept = "*/*";
    private int code = -1;
    public static boolean debug = false;
    private Progress progress;
    private static int timeout = 30000;
    private static String user_agent = "JavaForce.HTTP";
    public static final String formType = "application/x-www-form-urlencoded";
    public static final String formTypeMultiPart = "multipart/form-data";
    public static final String partTypeText = "text/plain";
    public static final String partTypeHTML = "text/html";
    public static final String partTypeStream = "application/octet-stream";
    public static final String partTypeZip = "application/x-zip-compressed";
    private static final int bufsiz = 1024;

    public static String cleanURL(String url) {
        return JF.cleanURL(url);
    }

    public static String getUserInfo(String urlstr) {
        try {
            return new URI(urlstr).toURL().getUserInfo();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getHost(String urlstr) {
        try {
            return new URI(urlstr).toURL().getHost();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static int getPort(String urlstr) {
        try {
            return new URI(urlstr).toURL().getPort();
        }
        catch (Exception e) {
            return 80;
        }
    }

    public static void setTimeout(int timeout) {
        HTTP.timeout = timeout;
    }

    public boolean open(String host) {
        return this.open(host, 80);
    }

    public boolean open(String host, int port) {
        this.host = host;
        this.port = port;
        try {
            if (debug) {
                JFLog.log("HTTP.connect:" + host + ":" + port);
            }
            this.s = new Socket();
            this.s.connect(new InetSocketAddress(host, port), timeout);
            this.s.setSoTimeout(timeout);
            this.os = this.s.getOutputStream();
            this.is = this.s.getInputStream();
        }
        catch (Exception e) {
            JFLog.log(e);
            if (this.s != null) {
                try {
                    this.s.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.s = null;
            }
            this.s = null;
            return false;
        }
        return true;
    }

    public void close() {
        if (this.s != null) {
            try {
                this.s.close();
            }
            catch (Exception e) {
                JFLog.log(e);
            }
            this.s = null;
        }
    }

    public boolean isConnected() {
        return this.s != null;
    }

    public void setProgressListener(Progress progress) {
        this.progress = progress;
    }

    public void setHeader(String key, String value) {
        this.request_headers.put(key, value);
    }

    public void clearHeaders() {
        this.request_headers.clear();
    }

    public String getHeader(String key) {
        return this.reply_headers.get(key);
    }

    public HashMap<String, String> getHeaders() {
        return this.reply_headers.getHashMap();
    }

    public int getCode() {
        return this.code;
    }

    public void setAccept(String accept) {
        this.accept = accept;
    }

    public static void setUserAgent(String ua) {
        user_agent = ua;
    }

    private int read(Buffer buf, int length) throws Exception {
        if (buf.count >= length) {
            return length;
        }
        int maxlength = buf.buf.length - buf.pos - buf.count;
        if (length > maxlength && buf.pos > 0) {
            buf.condense();
            maxlength = buf.buf.length - buf.count;
        }
        if (length > maxlength && (length = maxlength) == 0) {
            JFLog.log("HTTP:Error:buffer full:" + buf.buf.length + "," + buf.pos + "," + buf.count);
            return 0;
        }
        int read = this.is.read(buf.buf, buf.pos + buf.count, length);
        if (read > 0) {
            buf.count += read;
        }
        return read;
    }

    private void write(byte[] data) throws Exception {
        this.os.write(data);
    }

    private void sendString(String req) throws Exception {
        this.write(req.getBytes());
    }

    private void sendData(byte[] data) throws Exception {
        this.write(data);
    }

    private void sendEnter() throws Exception {
        this.write("\r\n".getBytes());
    }

    private boolean endOfHeaders(Buffer buf) {
        if (buf.count < 4) {
            return false;
        }
        int length = buf.count;
        return buf.buf[length - 4] == 13 && buf.buf[length - 3] == 10 && buf.buf[length - 2] == 13 && buf.buf[length - 1] == 10;
    }

    private boolean haveChunkLength(Buffer buf) {
        if (buf.count < 2) {
            return false;
        }
        int length = buf.count;
        int start = buf.pos;
        int end = buf.pos + length - 1;
        for (int pos = start; pos < end; ++pos) {
            if (buf.buf[pos] != 13 || buf.buf[pos + 1] != 10) continue;
            return true;
        }
        return false;
    }

    private int getChunkLength(Buffer buf) {
        int value = 0;
        while (buf.buf[buf.pos] != 13) {
            value *= 16;
            char digit = (char)buf.buf[buf.pos];
            if (digit >= '0' && digit <= '9') {
                value += digit - 48;
            } else if (digit >= 'A' && digit <= 'F') {
                value += digit - 65 + 10;
            } else if (digit >= 'a' && digit <= 'f') {
                value += digit - 97 + 10;
            } else {
                JFLog.log("HTTP:Error:Invalid chunk length");
                return -1;
            }
            buf.consume(1);
        }
        buf.consume(2);
        return value;
    }

    private boolean getReply(OutputStream os) throws Exception {
        int i1;
        Buffer buf = new Buffer();
        Buffer req = new Buffer();
        this.reply_headers.clear();
        do {
            int read = this.read(buf, 1024);
            buf.pos = 0;
            buf.count = read;
            while (buf.count > 0) {
                if (req.count == req.buf.length) {
                    req.expand();
                }
                req.buf[req.count++] = buf.buf[buf.pos++];
                --buf.count;
                --read;
                if (!this.endOfHeaders(req)) continue;
            }
        } while (!this.endOfHeaders(req));
        long length = -1L;
        boolean chunked = false;
        String[] lns = new String(req.toArray()).split("\r\n");
        block10: for (int i = 1; i < lns.length; ++i) {
            String ln = lns[i];
            int idx = ln.indexOf(58);
            if (idx == -1) continue;
            String key = ln.substring(0, idx).trim();
            String value = ln.substring(idx + 1).trim();
            this.reply_headers.put(key, value);
            if (debug) {
                System.out.println("Reply:" + key + "=" + value);
            }
            switch (key.toLowerCase()) {
                case "content-length": {
                    length = Long.valueOf(value);
                    continue block10;
                }
                case "transfer-encoding": {
                    chunked = value.contains("chunked");
                }
            }
        }
        String reply = lns[0];
        if (debug) {
            System.out.println("Reply=" + reply);
        }
        if ((i1 = reply.indexOf(32)) == -1) {
            JFLog.log("HTTP:Error:Invalid Reply");
            return false;
        }
        int i2 = reply.substring(i1 + 1).indexOf(32);
        if (i2 == -1) {
            JFLog.log("HTTP:Error:Invalid Reply");
            return false;
        }
        this.code = Integer.valueOf(reply.substring(i1 + 1, i1 + i2 + 1));
        boolean disconn = reply.endsWith("1.0");
        if (length == 0L) {
            if (disconn) {
                this.close();
            }
            return true;
        }
        long copied = 0L;
        if (chunked) {
            if (debug) {
                System.out.println("HTTP:Reading Chunked reply");
            }
            while (true) {
                if (this.haveChunkLength(buf)) {
                    boolean endOfChunks;
                    int chunkLength = this.getChunkLength(buf);
                    boolean bl = endOfChunks = chunkLength == 0;
                    if (buf.count > 0) {
                        int toCopy = buf.count;
                        if (toCopy > chunkLength) {
                            toCopy = chunkLength;
                        }
                        os.write(buf.buf, buf.pos, toCopy);
                        chunkLength -= toCopy;
                        buf.consume(toCopy);
                        copied += (long)toCopy;
                    }
                    while (chunkLength > 0) {
                        int read;
                        int toread = chunkLength;
                        if (toread > 1024) {
                            toread = 1024;
                        }
                        if ((read = this.read(buf, toread)) <= 0) continue;
                        copied += (long)read;
                        if (this.progress != null) {
                            this.progress.progress(copied, -1L);
                        }
                        os.write(buf.buf, buf.pos, read);
                        chunkLength -= read;
                        buf.consume(read);
                    }
                    while (buf.count < 2) {
                        this.read(buf, 2 - buf.count);
                    }
                    buf.consume(2);
                    if (!endOfChunks) continue;
                    if (disconn) {
                        this.close();
                    }
                    return true;
                }
                this.read(buf, 1024);
            }
        }
        if (length != -1L) {
            if (debug) {
                System.out.println("HTTP:Reading Length:" + length);
            }
            if (buf.count > 0) {
                copied += (long)buf.count;
                os.write(buf.toArray());
                buf.consumeAll();
            }
            while (copied < length) {
                int read;
                int toread = 1024;
                if ((long)toread > length) {
                    toread = (int)length;
                }
                if ((read = this.read(buf, toread)) <= 0) continue;
                copied += (long)read;
                if (this.progress != null) {
                    this.progress.progress(copied, length);
                }
                os.write(buf.toArray());
                buf.consume(read);
            }
            if (disconn) {
                this.close();
            }
            return true;
        }
        if (debug) {
            System.out.println("HTTP:Reading till carrier dropped");
        }
        do {
            if (buf.count <= 0) continue;
            copied += (long)buf.count;
            if (this.progress != null) {
                this.progress.progress(copied, -1L);
            }
            os.write(buf.toArray());
            buf.consumeAll();
        } while (this.read(buf, 1024) >= 0);
        if (disconn) {
            this.close();
        }
        return true;
    }

    private void appendHeaders(StringBuilder req) {
        String[] keys;
        for (String key : keys = this.request_headers.keys()) {
            String value = this.request_headers.get(key);
            req.append(key + ": " + value + "\r\n");
        }
    }

    public boolean get(String url, OutputStream os) {
        if (debug) {
            JFLog.log("HTTP.get():" + url);
        }
        this.code = -1;
        if (this.s == null) {
            return false;
        }
        StringBuilder req = new StringBuilder();
        req.append("GET " + url + " HTTP/1.1\r\n");
        req.append("Host: " + this.host + (String)(this.port != 80 ? ":" + this.port : "") + "\r\n");
        req.append("User-Agent: " + user_agent + "\r\n");
        req.append("Content-Length: 0\r\n");
        req.append("Accept: " + this.accept + "\r\n");
        req.append("Accept-Encoding: chunked\r\n");
        this.appendHeaders(req);
        req.append("\r\n");
        if (debug) {
            JFLog.log("request=" + req.toString());
        }
        try {
            this.sendString(req.toString());
            return this.getReply(os);
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public byte[] get(String url) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (!this.get(url, baos)) {
            return null;
        }
        return baos.toByteArray();
    }

    public String getString(String url) {
        return new String(this.get(url));
    }

    private void sendBoundaryHashes() throws Exception {
        this.write("--".getBytes());
    }

    private void sendBoundary(String boundary) throws Exception {
        this.sendBoundaryHashes();
        this.write(boundary.getBytes());
    }

    private String makePart(Part part) {
        StringBuilder buf = new StringBuilder();
        buf.append("Content-Disposition: form-data; name=\"" + part.name + "\"");
        if (part.filename != null) {
            buf.append("; filename=\"" + part.filename + "\"");
        }
        buf.append("\r\n");
        buf.append("Content-Type: " + part.mimeType + "\r\n");
        buf.append("Content-Length: " + part.data.length + "\r\n");
        buf.append("\r\n");
        return buf.toString();
    }

    private void sendPart(Part part) throws Exception {
        String buf = this.makePart(part);
        this.sendString(buf);
    }

    public boolean post(String url, Part[] parts, OutputStream os) {
        this.code = -1;
        if (this.s == null) {
            return false;
        }
        StringBuilder req = new StringBuilder();
        req.append("POST " + url + " HTTP/1.1\r\n");
        req.append("Host: " + this.host + (String)(this.port != 80 ? ":" + this.port : "") + "\r\n");
        req.append("User-Agent: " + user_agent + "\r\n");
        req.append("Accept: " + this.accept + "\r\n");
        req.append("Accept-Encoding: chunked\r\n");
        this.appendHeaders(req);
        String boundary = "----JavaForceHTTP" + System.currentTimeMillis();
        int boundary_length = boundary.length();
        req.append("Content-Type: multipart/form-data; boundary=" + boundary + "\r\n");
        long length = 0L;
        boolean first = true;
        for (Part part : parts) {
            if (first) {
                first = false;
            } else {
                length += 2L;
            }
            length += (long)(2 + boundary_length);
            length += 2L;
            length += (long)this.makePart(part).length();
            length += (long)part.data.length;
            length += 2L;
            length += (long)(2 + boundary_length);
        }
        req.append("Content-Length: " + (length += 4L) + "\r\n");
        req.append("\r\n");
        try {
            this.sendString(req.toString());
            first = true;
            for (Part part : parts) {
                if (first) {
                    first = false;
                } else {
                    this.sendEnter();
                }
                this.sendBoundary(boundary);
                this.sendEnter();
                this.sendPart(part);
                this.sendData(part.data);
                this.sendEnter();
                this.sendBoundary(boundary);
            }
            this.sendBoundaryHashes();
            this.sendEnter();
            return this.getReply(os);
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public byte[] post(String url, Part[] parts) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (!this.post(url, parts, (OutputStream)baos)) {
            return null;
        }
        return baos.toByteArray();
    }

    public boolean post(String url, byte[] data, OutputStream os, String encType) {
        this.code = -1;
        if (this.s == null) {
            return false;
        }
        StringBuilder req = new StringBuilder();
        req.append("POST " + url + " HTTP/1.1\r\n");
        req.append("Host: " + this.host + (String)(this.port != 80 ? ":" + this.port : "") + "\r\n");
        req.append("User-Agent: " + user_agent + "\r\n");
        req.append("Accept: " + this.accept + "\r\n");
        req.append("Accept-Encoding: chunked\r\n");
        if (encType == null) {
            encType = formType;
        }
        req.append("Content-Type: " + encType + "\r\n");
        req.append("Content-Length: " + data.length);
        this.appendHeaders(req);
        req.append("\r\n");
        try {
            this.sendString(req.toString());
            this.sendData(data);
            return this.getReply(os);
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public boolean post(String url, byte[] data, OutputStream os) {
        return this.post(url, data, os, null);
    }

    public byte[] post(String url, byte[] data) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (!this.post(url, data, baos, null)) {
            return null;
        }
        return baos.toByteArray();
    }

    public byte[] post(String url, byte[] data, String encType) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (!this.post(url, data, baos, encType)) {
            return null;
        }
        return baos.toByteArray();
    }

    public String postString(String url, byte[] data) {
        return new String(this.post(url, data));
    }

    public static void main(String[] args) {
        HTTP http = new HTTP();
        boolean print = false;
        if (args.length > 0 && args[0].equals("print")) {
            print = true;
        }
        debug = true;
        http.open("google.com");
        String html = http.getString("/");
        http.close();
        if (html == null || html.length() == 0) {
            System.out.println("Error:HTTP.get() failed");
        }
        if (print) {
            System.out.println(html);
        }
        http.open("www.google.com");
        html = http.getString("/");
        http.close();
        if (html == null || html.length() == 0) {
            System.out.println("Error:HTTP.get() failed");
        }
        if (print) {
            System.out.println(html);
        }
        Part part = new Part();
        part.name = "file";
        part.filename = "file.zip";
        part.data = new byte[]{1, 2, 3};
        part.mimeType = partTypeStream;
        http.open("example.com");
        byte[] data = http.post("/upload", new Part[]{part});
        http.close();
        if (data == null || data.length == 0) {
            System.out.println("Error:HTTP.post() failed");
            return;
        }
        if (print) {
            System.out.println(new String(data));
        }
    }

    public static String getParameter(String[] params, String name) {
        for (int a = 0; a < params.length; ++a) {
            String param = params[a];
            int idx = param.indexOf(":");
            if (idx == -1) continue;
            String key = param.substring(0, idx).trim();
            String value = param.substring(idx + 1).trim();
            if (!key.equalsIgnoreCase(name)) continue;
            return value;
        }
        return null;
    }

    public static String[] getParameters(String[] params, String name) {
        ArrayList<String> lst = new ArrayList<String>();
        for (int a = 0; a < params.length; ++a) {
            String param = params[a];
            int idx = param.indexOf(":");
            if (idx == -1) continue;
            String key = param.substring(0, idx).trim();
            String value = param.substring(idx + 1).trim();
            if (!key.equalsIgnoreCase(name)) continue;
            lst.add(value);
        }
        return lst.toArray(JF.StringArrayType);
    }

    public static String[] getContent(String[] msg) {
        ArrayList<String> content = new ArrayList<String>();
        for (int a = 0; a < msg.length; ++a) {
            if (msg[a].length() != 0) continue;
            for (int b = a + 1; b < msg.length; ++b) {
                content.add(msg[b]);
            }
            break;
        }
        return content.toArray(JF.StringArrayType);
    }

    public static class Parameters {
        private HashMap<String, String> params = new HashMap();

        public String get(String name) {
            return this.params.get(name);
        }

        public void put(String name, String value) {
            this.params.put(name, value);
        }

        public String[] keys() {
            return this.params.keySet().toArray(JF.StringArrayType);
        }

        public void clear() {
            this.params.clear();
        }

        public HashMap<String, String> getHashMap() {
            return this.params;
        }

        public static Parameters decode(String[] headers, char equals, int offset) {
            Parameters p = new Parameters();
            for (int i = offset; i < headers.length; ++i) {
                String ln = headers[i];
                int idx = ln.indexOf(equals);
                if (idx == -1) continue;
                String key = ln.substring(0, idx).trim();
                String value = ln.substring(idx + 1).trim();
                p.put(key, value);
            }
            return p;
        }

        public static Parameters decode(String[] headers) {
            for (int i = 0; i < headers.length; ++i) {
                if (headers[i].length() != 0) continue;
                return Parameters.decode(headers, ':', i + 1);
            }
            return null;
        }

        public static Parameters decode(String[] headers, char equals) {
            for (int i = 0; i < headers.length; ++i) {
                if (headers[i].length() != 0) continue;
                return Parameters.decode(headers, equals, i + 1);
            }
            return null;
        }

        public static Parameters decode(String query) {
            String[] items;
            Parameters params = new Parameters();
            for (String item : items = query.split("&")) {
                int idx = item.indexOf(61);
                if (idx == -1) continue;
                String key = item.substring(0, idx);
                String value = item.substring(idx + 1);
                params.put(key, JF.decodeURL(value));
            }
            return params;
        }
    }

    public static interface Progress {
        public void progress(long var1, long var3);
    }

    protected static class Buffer {
        public byte[] buf = new byte[1024];
        public int pos = 0;
        public int count = 0;

        public void expand() {
            byte[] newbuf = new byte[this.buf.length << 1];
            if (this.count > 0) {
                System.arraycopy(this.buf, this.pos, newbuf, 0, this.count);
            }
            this.buf = newbuf;
            this.pos = 0;
        }

        public void condense() {
            if (this.pos == 0) {
                return;
            }
            if (this.count == 0) {
                this.pos = 0;
                return;
            }
            System.arraycopy(this.buf, this.pos, this.buf, 0, this.count);
            this.pos = 0;
        }

        public void consume(int length) {
            if (length > this.count) {
                JFLog.log("HTTP:Error:Buffer.consume(length > count)");
            }
            this.pos += length;
            this.count -= length;
            if (this.count == 0) {
                this.pos = 0;
            }
        }

        public void consumeAll() {
            this.pos = 0;
            this.count = 0;
        }

        public void setLength(int length) {
            if (this.buf.length == length) {
                return;
            }
            byte[] newbuf = new byte[length];
            if (this.buf.length > length) {
                System.arraycopy(this.buf, this.pos, newbuf, 0, length);
            } else {
                System.arraycopy(this.buf, this.pos, newbuf, 0, this.count);
            }
            this.buf = newbuf;
            this.pos = 0;
        }

        public void append(Buffer other) {
            if (other.count == 0) {
                return;
            }
            while (this.buf.length < this.count + other.count) {
                this.expand();
            }
            if (this.pos > 0) {
                this.condense();
            }
            System.arraycopy(other.buf, other.pos, this.buf, this.pos + this.count, other.count);
            this.count += other.count;
            other.consumeAll();
        }

        public void append(Buffer other, int maxCopy) {
            if (other.count == 0) {
                return;
            }
            if (maxCopy == 0) {
                return;
            }
            int toCopy = maxCopy;
            if (other.count < maxCopy) {
                toCopy = other.count;
            }
            while (this.buf.length < this.count + toCopy) {
                this.expand();
            }
            if (this.pos > 0) {
                this.condense();
            }
            System.arraycopy(other.buf, other.pos, this.buf, this.pos + this.count, toCopy);
            this.count += toCopy;
            other.consume(toCopy);
        }

        public byte[] toArray() {
            if (this.count != this.buf.length) {
                return Arrays.copyOfRange(this.buf, this.pos, this.pos + this.count);
            }
            return this.buf;
        }
    }

    public static class Part {
        public String name;
        public String mimeType;
        public String filename;
        public byte[] data;
    }
}

