/*
 * Decompiled with CFR 0.152.
 */
package javaforce;

public class LE {
    public static int getuint8(byte[] data, int offset) {
        int ret = data[offset] & 0xFF;
        return ret;
    }

    public static int getuint16(byte[] data, int offset) {
        int ret = data[offset] & 0xFF;
        return ret += (data[offset + 1] & 0xFF) << 8;
    }

    public static int getuint32(byte[] data, int offset) {
        int ret = data[offset] & 0xFF;
        ret += (data[offset + 1] & 0xFF) << 8;
        ret += (data[offset + 2] & 0xFF) << 16;
        return ret += (data[offset + 3] & 0xFF) << 24;
    }

    public static float getfloat(byte[] data, int offset) {
        return Float.intBitsToFloat(LE.getuint32(data, offset));
    }

    public static long getuint64(byte[] data, int offset) {
        long ret = (long)data[offset] & 0xFFL;
        ret += ((long)data[offset + 1] & 0xFFL) << 8;
        ret += ((long)data[offset + 2] & 0xFFL) << 16;
        ret += ((long)data[offset + 3] & 0xFFL) << 24;
        ret += ((long)data[offset + 4] & 0xFFL) << 32;
        ret += ((long)data[offset + 5] & 0xFFL) << 40;
        ret += ((long)data[offset + 6] & 0xFFL) << 48;
        return ret += ((long)data[offset + 7] & 0xFFL) << 56;
    }

    public static double getdouble(byte[] data, int offset) {
        return Double.longBitsToDouble(LE.getuint64(data, offset));
    }

    public static String getString(byte[] data, int offset, int len) {
        Object ret = "";
        while (len > 0 && data[offset] != 0) {
            ret = (String)ret + (char)data[offset++];
            --len;
        }
        return ret;
    }

    public static void setuint8(byte[] data, int offset, int num) {
        data[offset] = (byte)(num & 0xFF);
    }

    public static void setuint16(byte[] data, int offset, int num) {
        data[offset + 0] = (byte)(num & 0xFF);
        data[offset + 1] = (byte)((num >>= 8) & 0xFF);
    }

    public static void setuint32(byte[] data, int offset, int num) {
        data[offset + 0] = (byte)(num & 0xFF);
        data[offset + 1] = (byte)((num >>= 8) & 0xFF);
        data[offset + 2] = (byte)((num >>= 8) & 0xFF);
        data[offset + 3] = (byte)((num >>= 8) & 0xFF);
    }

    public static void setfloat(byte[] data, int offset, float num) {
        LE.setuint32(data, offset, Float.floatToIntBits(num));
    }

    public static void setuint64(byte[] data, int offset, long num) {
        data[offset + 0] = (byte)(num & 0xFFL);
        data[offset + 1] = (byte)((num >>= 8) & 0xFFL);
        data[offset + 2] = (byte)((num >>= 8) & 0xFFL);
        data[offset + 3] = (byte)((num >>= 8) & 0xFFL);
        data[offset + 4] = (byte)((num >>= 8) & 0xFFL);
        data[offset + 5] = (byte)((num >>= 8) & 0xFFL);
        data[offset + 6] = (byte)((num >>= 8) & 0xFFL);
        data[offset + 7] = (byte)((num >>= 8) & 0xFFL);
    }

    public static void setdouble(byte[] data, int offset, double num) {
        LE.setuint64(data, offset, Double.doubleToLongBits(num));
    }

    public static void setString(byte[] data, int offset, int len, String str) {
        int pos = 0;
        while (len > 0) {
            if (pos >= str.length()) {
                data[offset++] = 0;
            } else {
                data[offset++] = (byte)str.charAt(pos++);
            }
            --len;
        }
    }

    public static short[] byteArray2shortArray(byte[] in, short[] out) {
        int len = in.length / 2;
        if (out == null) {
            out = new short[len];
        }
        int p = 0;
        for (int a = 0; a < len; ++a) {
            short val = (short)(in[p++] & 0xFF);
            out[a] = val = (short)(val + ((in[p++] & 0xFF) << 8));
        }
        return out;
    }

    public static int[] byteArray2intArray(byte[] in, int[] out) {
        int len = in.length / 4;
        if (out == null) {
            out = new int[len];
        }
        int p = 0;
        for (int a = 0; a < len; ++a) {
            int val = in[p++] & 0xFF;
            val += (in[p++] & 0xFF) << 8;
            val += (in[p++] & 0xFF) << 16;
            out[a] = val += (in[p++] & 0xFF) << 24;
        }
        return out;
    }

    public static byte[] shortArray2byteArray(short[] in, byte[] out) {
        int len = in.length;
        if (out == null) {
            out = new byte[len * 2];
        }
        int p = 0;
        for (int a = 0; a < len; ++a) {
            short val = in[a];
            out[p++] = (byte)(val & 0xFF);
            out[p++] = (byte)(val >>> 8);
        }
        return out;
    }

    public static byte[] intArray2byteArray(int[] in, byte[] out) {
        int len = in.length;
        if (out == null) {
            out = new byte[len * 4];
        }
        int p = 0;
        for (int a = 0; a < len; ++a) {
            int val = in[a];
            out[p++] = (byte)(val & 0xFF);
            out[p++] = (byte)((val >>>= 8) & 0xFF);
            out[p++] = (byte)((val >>>= 8) & 0xFF);
            out[p++] = (byte)(val >>> 8);
        }
        return out;
    }

    public static short[] swap(short[] input) {
        for (int a = 0; a < input.length; ++a) {
            int t1;
            int t2 = t1 = input[a] & 0xFFFF;
            t1 <<= 8;
            input[a] = (short)((t1 &= 0xFF00) | (t2 >>= 8));
        }
        return input;
    }
}

