/*
 * Decompiled with CFR 0.152.
 */
package javaforce.awt;

import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javaforce.JFLog;
import javaforce.awt.JFImage;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.TransferHandler;

public class JFClipboard {
    public static final int NONE = 0;
    public static final int COPY = 1;
    public static final int MOVE = 2;
    public static final int COPY_OR_MOVE = 3;
    public static boolean useAWT = false;

    public static DataFlavor[] getDataFlavors() {
        return Toolkit.getDefaultToolkit().getSystemClipboard().getAvailableDataFlavors();
    }

    public static Image readImage() {
        Transferable t = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
        try {
            if (t != null && t.isDataFlavorSupported(DataFlavor.imageFlavor)) {
                Image image = (Image)t.getTransferData(DataFlavor.imageFlavor);
                return image;
            }
        }
        catch (Exception e) {
            JFLog.log(e);
        }
        return null;
    }

    public static JFImage convertImage(Image image) {
        int x = image.getWidth(null);
        int y = image.getHeight(null);
        JFImage jfimg = new JFImage(x, y);
        jfimg.getGraphics().drawImage(image, 0, 0, null);
        return jfimg;
    }

    public static void writeImage(Image image) {
        ImageTransferable transferable = new ImageTransferable(image);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(transferable, null);
    }

    public static String readString() {
        Transferable t = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
        try {
            if (t != null && t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                String str = (String)t.getTransferData(DataFlavor.stringFlavor);
                return str;
            }
        }
        catch (Exception e) {
            JFLog.log(e);
        }
        return null;
    }

    public static void writeString(String str) {
        StringSelection ss = new StringSelection(str);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, null);
    }

    public static FileList readFiles() {
        FileList fl = new FileList();
        if (useAWT) {
            Transferable t = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
            try {
                if (t != null && t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    List files = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                    fl.files.addAll(files);
                    fl.action = 0;
                    return fl;
                }
            }
            catch (Exception e) {
                JFLog.log(e);
            }
        } else {
            JComp c = new JComp();
            MyTransferHandler th = new MyTransferHandler();
            c.setTransferHandler(th);
            Action a = TransferHandler.getPasteAction();
            a.actionPerformed(new ActionEvent(c, 0, "paste"));
            fl.files = th.files;
            fl.action = th.action;
            return fl;
        }
        return null;
    }

    public static void writeFiles(final FileList fl) {
        if (useAWT) {
            Transferable t = new Transferable(){

                @Override
                public DataFlavor[] getTransferDataFlavors() {
                    return new DataFlavor[]{DataFlavor.javaFileListFlavor};
                }

                @Override
                public boolean isDataFlavorSupported(DataFlavor df) {
                    return df == DataFlavor.javaFileListFlavor;
                }

                @Override
                public Object getTransferData(DataFlavor df) throws UnsupportedFlavorException, IOException {
                    return fl.files;
                }
            };
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(t, null);
        } else {
            if (fl.action != 1 && fl.action != 2) {
                return;
            }
            JComp c = new JComp();
            MyTransferHandler th = new MyTransferHandler();
            th.files = fl.files;
            th.action = fl.action;
            c.setTransferHandler(th);
            Action a = fl.action == 1 ? TransferHandler.getCopyAction() : TransferHandler.getCutAction();
            a.actionPerformed(new ActionEvent(c, 0, fl.action == 1 ? "copy" : "cut"));
        }
    }

    public static void clearClipboard() {
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(null, null);
    }

    public static class ImageTransferable
    implements Transferable {
        private Image image;

        public ImageTransferable(Image image) {
            this.image = image;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (this.isDataFlavorSupported(flavor)) {
                return this.image;
            }
            throw new UnsupportedFlavorException(flavor);
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor == DataFlavor.imageFlavor;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.imageFlavor};
        }
    }

    public static class FileList {
        public List<File> files;
        public int action;
    }

    public static class JComp
    extends JComponent {
    }

    public static class MyTransferHandler
    extends TransferHandler {
        public List<File> files;
        public int action;

        @Override
        public boolean canImport(TransferHandler.TransferSupport info) {
            JFLog.log("canImport");
            if (!info.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                return false;
            }
            TransferHandler.DropLocation dl = info.getDropLocation();
            Point pt = dl.getDropPoint();
            return true;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport info) {
            JFLog.log("importData");
            if (!info.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                return false;
            }
            Transferable t = info.getTransferable();
            try {
                this.files = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
            }
            catch (Exception e) {
                return false;
            }
            this.action = 0;
            return true;
        }

        @Override
        public int getSourceActions(JComponent c) {
            JFLog.log("getSourceActions:" + this.action);
            return this.action;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            JFLog.log("createTransferable");
            return new Transferable(){

                @Override
                public DataFlavor[] getTransferDataFlavors() {
                    return new DataFlavor[]{DataFlavor.javaFileListFlavor};
                }

                @Override
                public boolean isDataFlavorSupported(DataFlavor df) {
                    return df == DataFlavor.javaFileListFlavor;
                }

                @Override
                public Object getTransferData(DataFlavor df) throws UnsupportedFlavorException, IOException {
                    return files;
                }
            };
        }

        @Override
        protected void exportDone(JComponent source, Transferable data, int action) {
            JFLog.log("exportDone:action=" + action);
        }
    }
}

