/*
 * Decompiled with CFR 0.152.
 */
package javaforce.awt;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Random;
import javaforce.awt.JFAWT;
import javaforce.awt.JFImage;
import javaforce.awt.VNCServer;
import javaforce.awt.ViewLog;
import javaforce.jbus.JBusClient;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;

public class VNCApp
extends JFrame {
    private JTextArea config;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JButton save;
    private JButton viewLog;
    public ViewLog viewer;
    public JBusClient busClient;

    public VNCApp() {
        this.initComponents();
        JFImage img = new JFImage();
        img.loadPNG(this.getClass().getResourceAsStream("/javaforce/icons/vnc.png"));
        new Thread(){

            @Override
            public void run() {
                Random r = new Random();
                VNCApp.this.busClient = new JBusClient("net.sf.jfvnc.client" + r.nextInt(), new JBusMethods());
                VNCApp.this.busClient.setPort(VNCServer.getBusPort());
                VNCApp.this.busClient.start();
                VNCApp.this.busClient.call("net.sf.jfvnc", "getConfig", "\"" + VNCApp.this.busClient.pack + "\"");
            }
        }.start();
        JFAWT.centerWindow(this);
    }

    public void writeConfig() {
        this.busClient.call("net.sf.jfvnc", "setConfig", JBusClient.quote(JBusClient.encodeString(this.config.getText())));
    }

    public void restart() {
        this.busClient.call("net.sf.jfvnc", "restart", "");
    }

    private void initComponents() {
        this.save = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.config = new JTextArea();
        this.jLabel1 = new JLabel();
        this.viewLog = new JButton();
        this.setDefaultCloseOperation(3);
        this.setTitle("VNC Server");
        this.save.setText("Save");
        this.save.setEnabled(false);
        this.save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VNCApp.this.saveActionPerformed(evt);
            }
        });
        this.config.setColumns(20);
        this.config.setRows(5);
        this.config.setText(" [ loading ... ]");
        this.config.setEnabled(false);
        this.jScrollPane1.setViewportView(this.config);
        this.jLabel1.setText("VNC Configuration:");
        this.viewLog.setText("View Log");
        this.viewLog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VNCApp.this.viewLogActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 583, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.viewLog).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.save)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 424, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.save).addComponent(this.viewLog)).addContainerGap()));
        this.pack();
    }

    private void saveActionPerformed(ActionEvent evt) {
        this.writeConfig();
        this.restart();
        JFAWT.showMessage("Notice", "Settings saved!");
    }

    private void viewLogActionPerformed(ActionEvent evt) {
        this.showViewLog();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new VNCApp().setVisible(true);
            }
        });
    }

    public void showViewLog() {
        if (this.viewer == null || this.viewer.isClosed) {
            this.viewer = new ViewLog(VNCServer.getLogFile());
            this.viewer.setTitle("VNC Log");
        }
        this.viewer.setVisible(true);
    }

    public class JBusMethods {
        public void getConfig(String cfg) {
            final String _cfg = cfg;
            EventQueue.invokeLater(new Runnable(){
                final /* synthetic */ JBusMethods this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public void run() {
                    this.this$1.VNCApp.this.config.setText(JBusClient.decodeString(_cfg));
                    this.this$1.VNCApp.this.config.setEnabled(true);
                    this.this$1.VNCApp.this.save.setEnabled(true);
                }
            });
        }
    }
}

