/*
 * Decompiled with CFR 0.152.
 */
package javaforce.codec.speex;

public class Lpc {
    public static float wld(float[] lpc, float[] ac, float[] ref, int p) {
        float error = ac[0];
        if (ac[0] == 0.0f) {
            for (int i = 0; i < p; ++i) {
                ref[i] = 0.0f;
            }
            return 0.0f;
        }
        for (int i = 0; i < p; ++i) {
            int j;
            float r = -ac[i + 1];
            for (j = 0; j < i; ++j) {
                r -= lpc[j] * ac[i - j];
            }
            ref[i] = r /= error;
            lpc[i] = r;
            for (j = 0; j < i / 2; ++j) {
                float tmp = lpc[j];
                int n = j;
                lpc[n] = lpc[n] + r * lpc[i - 1 - j];
                int n2 = i - 1 - j;
                lpc[n2] = lpc[n2] + r * tmp;
            }
            if (i % 2 != 0) {
                int n = j;
                lpc[n] = lpc[n] + lpc[j] * r;
            }
            error = (float)((double)error * (1.0 - (double)(r * r)));
        }
        return error;
    }

    public static void autocorr(float[] x, float[] ac, int lag, int n) {
        while (lag-- > 0) {
            float d = 0.0f;
            for (int i = lag; i < n; ++i) {
                d += x[i] * x[i - lag];
            }
            ac[lag] = d;
        }
    }
}

