/*
 * Decompiled with CFR 0.152.
 */
package javaforce.codec.speex;

import javaforce.codec.speex.Bits;
import javaforce.codec.speex.Encoder;
import javaforce.codec.speex.NbEncoder;
import javaforce.codec.speex.SbEncoder;
import javaforce.codec.speex.Stereo;

public class SpeexEncoder {
    public static final String VERSION = "Java Speex Encoder v0.9.7 ($Revision$)";
    private Encoder encoder;
    private final Bits bits = new Bits();
    private float[] rawData;
    private int sampleRate;
    private int channels;
    private int frameSize;

    public boolean init(int mode, int quality, int sampleRate, int channels) {
        switch (mode) {
            case 0: {
                this.encoder = new NbEncoder();
                ((NbEncoder)this.encoder).nbinit();
                break;
            }
            case 1: {
                this.encoder = new SbEncoder();
                ((SbEncoder)this.encoder).wbinit();
                break;
            }
            case 2: {
                this.encoder = new SbEncoder();
                ((SbEncoder)this.encoder).uwbinit();
                break;
            }
            default: {
                return false;
            }
        }
        this.encoder.setQuality(quality);
        this.frameSize = this.encoder.getFrameSize();
        this.sampleRate = sampleRate;
        this.channels = channels;
        this.rawData = new float[channels * this.frameSize];
        this.bits.init();
        return true;
    }

    public Encoder getEncoder() {
        return this.encoder;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public int getChannels() {
        return this.channels;
    }

    public int getFrameSize() {
        return this.frameSize;
    }

    public int getProcessedData(byte[] data, int offset) {
        int size = this.bits.getBufferSize();
        System.arraycopy(this.bits.getBuffer(), 0, data, offset, size);
        this.bits.init();
        return size;
    }

    public int getProcessedDataByteSize() {
        return this.bits.getBufferSize();
    }

    public boolean processData(byte[] data, int offset, int len) {
        SpeexEncoder.mapPcm16bitLittleEndian2Float(data, offset, this.rawData, 0, len / 2);
        return this.processData(this.rawData, len / 2);
    }

    public boolean processData(short[] data, int offset, int numShorts) {
        int numSamplesRequired = this.channels * this.frameSize;
        if (numShorts != numSamplesRequired) {
            throw new IllegalArgumentException("SpeexEncoder requires " + numSamplesRequired + " samples to process a Frame, not " + numShorts);
        }
        for (int i = 0; i < numShorts; ++i) {
            this.rawData[i] = data[offset + i];
        }
        return this.processData(this.rawData, numShorts);
    }

    public boolean processData(float[] data, int numSamples) {
        int numSamplesRequired = this.channels * this.frameSize;
        if (numSamples != numSamplesRequired) {
            throw new IllegalArgumentException("SpeexEncoder requires " + numSamplesRequired + " samples to process a Frame, not " + numSamples);
        }
        if (this.channels == 2) {
            Stereo.encode(this.bits, data, this.frameSize);
        }
        this.encoder.encode(this.bits, data);
        return true;
    }

    public static void mapPcm16bitLittleEndian2Float(byte[] pcm16bitBytes, int offsetInput, float[] samples, int offsetOutput, int length) {
        if (pcm16bitBytes.length - offsetInput < 2 * length) {
            throw new IllegalArgumentException("Insufficient Samples to convert to floats");
        }
        if (samples.length - offsetOutput < length) {
            throw new IllegalArgumentException("Insufficient float buffer to convert the samples");
        }
        for (int i = 0; i < length; ++i) {
            samples[offsetOutput + i] = pcm16bitBytes[offsetInput + 2 * i] & 0xFF | pcm16bitBytes[offsetInput + 2 * i + 1] << 8;
        }
    }
}

