/*
 * Decompiled with CFR 0.152.
 */
package javaforce.print;

import java.net.Socket;
import java.util.ArrayList;
import javaforce.JFLog;

public class IPL {
    private StringBuilder sb = new StringBuilder();
    private int field;
    private boolean done;
    private ArrayList<String> fields = new ArrayList();
    private boolean bin = true;
    private int program;

    private void start() {
        if (this.bin) {
            this.sb.append('\u0002');
        } else {
            this.sb.append("<STX>");
        }
    }

    private void end() {
        if (this.bin) {
            this.sb.append('\u0003');
        } else {
            this.sb.append("<ETX>");
        }
        this.sb.append("\r\r\n");
    }

    private void escape() {
        if (this.bin) {
            this.sb.append('\u001b');
        } else {
            this.sb.append("<ESC>");
        }
    }

    private void formfeed() {
        if (this.bin) {
            this.sb.append('\f');
        } else {
            this.sb.append("<FF>");
        }
    }

    private void can() {
        if (this.bin) {
            this.sb.append('\u0018');
        } else {
            this.sb.append("<CAN>");
        }
    }

    private void etb() {
        if (this.bin) {
            this.sb.append('\u0017');
        } else {
            this.sb.append("<ETB>");
        }
    }

    private void rs() {
        if (this.bin) {
            this.sb.append('\u001e');
        } else {
            this.sb.append("<RS>");
        }
    }

    private void lf() {
        if (this.bin) {
            this.sb.append('\n');
        } else {
            this.sb.append("<LF>");
        }
    }

    private void cr() {
        if (this.bin) {
            this.sb.append('\r');
        } else {
            this.sb.append("<CR>");
        }
    }

    public IPL(int program) {
        this.program = program;
        this.start();
        this.escape();
        this.sb.append("c");
        this.end();
        this.start();
        this.escape();
        this.sb.append("P");
        this.end();
        this.start();
        this.sb.append("E" + program + ";F" + program);
        this.end();
    }

    public void addBarCode(int x, int y, int scaleX, int scaleY, String code) {
        if (this.done) {
            return;
        }
        String str = String.format("B%d;o%d,%d;f0;h%d;w%d;r0;i0;c0,0;d3,%s;", this.field++, x, y, scaleY, scaleX, code);
        this.start();
        this.sb.append(str);
        this.end();
        this.fields.add(code);
    }

    public void addQRCode(int x, int y, int version, int scaleXY, String code) {
        if (this.done) {
            return;
        }
        String str = String.format("B%d;o%d,%d;f0;h%d;w%d;r0;i0;c18,0;d3,%s;", this.field++, x, y, version, scaleXY, code);
        this.start();
        this.sb.append(str);
        this.end();
        this.fields.add(code);
    }

    public void addText(int x, int y, int scaleX, int scaleY, String text) {
        if (this.done) {
            return;
        }
        String str = String.format("H%d;o%d,%d;f0;h%d;w%d;c0;d3,%s;", this.field++, x, y, scaleY, scaleX, text);
        this.start();
        this.sb.append(str);
        this.end();
        this.fields.add(text);
    }

    public void addLine(int x, int y, int width, int height) {
        if (this.done) {
            return;
        }
        String str = String.format("L%d;o%d,%d;f0;l%d;w%d;", this.field++, x, y, width, height);
        this.start();
        this.sb.append(str);
        this.end();
        this.fields.add("-@-");
    }

    public void addBox(int x, int y, int width, int height, int lineWidth) {
        if (this.done) {
            return;
        }
        String str = String.format("W%d;o%d,%d;f0;l%d;h%d;w%d;", this.field++, x, y, width, height, lineWidth);
        this.start();
        this.sb.append(str);
        this.end();
        this.fields.add("-@-");
    }

    public void finish() {
        if (this.done) {
            return;
        }
        this.start();
        this.sb.append("R");
        this.end();
        this.start();
        this.escape();
        this.sb.append("E" + this.program);
        this.end();
        this.start();
        this.can();
        this.end();
        for (int f = 0; f < this.fields.size(); ++f) {
            String str = this.fields.get(f);
            if (str.equals("-@-")) continue;
            this.start();
            this.sb.append(str);
            this.cr();
            this.end();
        }
        this.start();
        this.etb();
        this.formfeed();
        this.end();
        this.done = true;
    }

    public String generate() {
        if (!this.done) {
            this.finish();
        }
        return this.sb.toString();
    }

    public void print(String ip) {
        if (!this.done) {
            this.finish();
        }
        try {
            Socket s = new Socket(ip, 9100);
            String str = this.generate();
            s.getOutputStream().write(str.getBytes());
            s.close();
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }
}

