/*
 * Decompiled with CFR 0.152.
 */
package javaforce.service;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.zip.GZIPOutputStream;
import javaforce.service.WebRequest;
import javaforce.service.WebServer;

public class WebResponse
extends OutputStream {
    OutputStream os;
    private ByteArrayOutputStream buf = new ByteArrayOutputStream();
    private int statusCode = 200;
    private String statusString = "OK";
    private String contentType = "text/html; charset=UTF-8";
    private ArrayList<String> cookies = new ArrayList();
    private ArrayList<String> headers = new ArrayList();
    private PrintWriter writer = new PrintWriter(this);

    @Override
    public void write(int b) throws IOException {
        this.buf.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.buf.write(b, off, len);
    }

    void writeAll(WebRequest req) throws Exception {
        this.writer.flush();
        this.flush();
        byte[] data = this.buf.toByteArray();
        boolean gzip = false;
        if (data.length > 0) {
            String accept;
            if (WebServer.config_enable_gzip && (accept = req.getHeader("Accept-Encoding")) != null) {
                String[] encodings = accept.split(",");
                for (int a = 0; a < encodings.length; ++a) {
                    if (!encodings[a].trim().equals("gzip")) continue;
                    gzip = true;
                    break;
                }
            }
            if (gzip) {
                this.addHeader("Content-Encoding: gzip");
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                GZIPOutputStream gos = new GZIPOutputStream(baos);
                gos.write(data);
                gos.finish();
                data = baos.toByteArray();
            }
        }
        int size = data.length;
        this.writeHeaders(size, gzip);
        if (data.length > 0) {
            this.os.write(WebServer.chunkHeader(data));
            this.os.write(data);
            this.os.write("\r\n0\r\n\r\n".getBytes());
        }
    }

    void writeHeaders(int contentLength, boolean gzip) throws Exception {
        int a;
        StringBuilder res = new StringBuilder();
        res.append("HTTP/1.1 " + this.statusCode + " " + this.statusString + "\r\n");
        if (contentLength != -1) {
            res.append("Content-Length: " + contentLength + "\r\n");
        }
        res.append("Content-Type: " + this.contentType + "\r\n");
        if (contentLength != 0) {
            res.append("Transfer-Encoding: chunked\r\n");
        }
        for (a = 0; a < this.cookies.size(); ++a) {
            res.append("Set-Cookie: ");
            res.append(this.cookies.get(a));
            res.append("\r\n");
        }
        for (a = 0; a < this.headers.size(); ++a) {
            res.append(this.headers.get(a));
            res.append("\r\n");
        }
        res.append("\r\n");
        this.os.write(res.toString().getBytes());
    }

    public OutputStream getOutputStream() {
        return this;
    }

    public PrintWriter getWriter() {
        return this.writer;
    }

    public void setStatus(int sc, String msg) {
        this.statusCode = sc;
        this.statusString = msg;
    }

    public void setContentType(String type) {
        this.contentType = type;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentLength(int length) {
        this.addHeader("Content-Length: " + length);
    }

    public void addCookie(String name, String value) {
        this.cookies.add(name + "=" + value);
    }

    public void addHeader(String header) {
        this.headers.add(header);
    }

    public void sendRedirect(String url) {
        this.setStatus(301, "Moved");
        this.addHeader("Location: " + url);
    }

    public int getLength() {
        return this.buf.size();
    }

    @Override
    public void flush() {
        try {
            super.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public HashMap<String, Object> toHashMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ContentType", this.getContentType());
        map.put("OutputStream", this.getOutputStream());
        map.put("Writer", this.getWriter());
        return map;
    }

    public void fromHashMap(HashMap<String, Object> map) {
        this.setContentType((String)map.get("ContentType"));
        Integer length = (Integer)map.get("ContentLength");
        if (length != null) {
            System.out.println("WebResponse:length=" + length);
            this.setContentLength(length);
        }
    }
}

