/*
 * Decompiled with CFR 0.152.
 */
package javaforce.vm;

import java.io.File;
import java.io.Serializable;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.vm.Controller;
import javaforce.vm.Device;
import javaforce.vm.Disk;
import javaforce.vm.Hardware;
import javaforce.vm.MAC;
import javaforce.vm.Network;
import javaforce.vm.NetworkBridge;
import javaforce.vm.Size;
import javaforce.vm.Storage;
import javaforce.vm.VMProvider;
import javaforce.webui.tasks.Status;

public class VirtualMachine
implements Serializable {
    private static final long serialVersionUID = 1L;
    public String pool;
    public String name;
    private String uuid;
    private int vnc;
    public static final int STATE_OFF = 0;
    public static final int STATE_ON = 1;
    public static final int STATE_SUSPEND = 2;
    public static final int STATE_ERROR = 3;

    private VirtualMachine(String pool, String name, String uuid, int vnc) {
        this.pool = pool;
        this.name = name;
        this.uuid = uuid;
        this.vnc = vnc;
    }

    public VirtualMachine(Hardware hardware) {
        this.pool = hardware.pool;
        this.name = hardware.name;
        this.uuid = JF.generateUUID();
        this.vnc = -1;
    }

    public static native boolean init();

    public String getPool() {
        return this.pool;
    }

    public String getName() {
        return this.name;
    }

    public int getVNC() {
        return this.vnc;
    }

    public String getUUID() {
        return this.uuid;
    }

    public String getPath() {
        return "/volumes/" + this.pool + "/" + this.name;
    }

    public String getConfigFile() {
        return this.getPath() + "/" + this.name + ".jfvm";
    }

    public Hardware loadHardware() {
        return Hardware.load(this.getConfigFile());
    }

    public boolean saveHardware(Hardware hardware) {
        new File(this.getPath()).mkdirs();
        return hardware.save(this.getConfigFile());
    }

    public void create_stats_folder() {
        new File("/var/jfkvm/stats/" + this.uuid).mkdir();
    }

    private static native boolean nstart(String var0);

    public boolean start() {
        this.create_stats_folder();
        return VirtualMachine.nstart(this.name);
    }

    private static native boolean nstop(String var0);

    public boolean stop() {
        return VirtualMachine.nstop(this.name);
    }

    private static native boolean npoweroff(String var0);

    public boolean poweroff() {
        return VirtualMachine.npoweroff(this.name);
    }

    private static native boolean nrestart(String var0);

    public boolean restart() {
        return VirtualMachine.nrestart(this.name);
    }

    private static native boolean nsuspend(String var0);

    public boolean suspend() {
        return VirtualMachine.nsuspend(this.name);
    }

    private static native boolean nrestore(String var0);

    public boolean restore() {
        return VirtualMachine.nrestore(this.name);
    }

    private static native int ngetState(String var0);

    public int getState() {
        return VirtualMachine.ngetState(this.name);
    }

    public String getStateString() {
        int state = this.getState();
        switch (state) {
            case 0: {
                return "off";
            }
            case 1: {
                return "on";
            }
            case 2: {
                return "suspended";
            }
            case 3: {
                return "error";
            }
        }
        return "???";
    }

    public String[] getStates() {
        return new String[]{this.name, this.getStateString(), this.pool};
    }

    private static VirtualMachine getByDesc(String desc) {
        String[] fs = desc.split(";");
        String pool = null;
        String name = null;
        String uuid = null;
        int vnc = 0;
        block12: for (int a = 0; a < fs.length; ++a) {
            String f = fs[a];
            int i = f.indexOf(61);
            if (i == -1) continue;
            String key = f.substring(0, i).trim();
            String value = f.substring(i + 1).trim();
            switch (key) {
                case "pool": {
                    pool = value;
                    continue block12;
                }
                case "name": {
                    name = value;
                    continue block12;
                }
                case "uuid": {
                    uuid = value;
                    continue block12;
                }
                case "vnc": {
                    vnc = Integer.valueOf(value);
                }
            }
        }
        return new VirtualMachine(pool, name, uuid, vnc);
    }

    private static native String[] nlist();

    public static VirtualMachine[] list() {
        String[] list = VirtualMachine.nlist();
        if (list == null) {
            list = new String[]{};
        }
        VirtualMachine[] vms = new VirtualMachine[list.length];
        for (int idx = 0; idx < list.length; ++idx) {
            vms[idx] = VirtualMachine.getByDesc(list[idx]);
        }
        return vms;
    }

    private static native String nget(String var0);

    public static VirtualMachine get(String name) {
        String vm = VirtualMachine.nget(name);
        if (vm == null) {
            return null;
        }
        return VirtualMachine.getByDesc(vm);
    }

    private static native boolean nregister(String var0);

    public static boolean register(VirtualMachine vm, Hardware hardware, VMProvider provider) {
        String xml2 = VirtualMachine.createXML(vm, hardware, provider);
        JFLog.log("VirtualMachine.xml=" + xml2);
        return VirtualMachine.nregister(xml2);
    }

    public boolean reregister(Hardware hardware, VMProvider provider) {
        String xml2 = VirtualMachine.createXML(this, hardware, provider);
        JFLog.log("VirtualMachine.xml=" + xml2);
        return VirtualMachine.nregister(xml2);
    }

    private static native boolean nunregister(String var0);

    public boolean unregister() {
        return VirtualMachine.nunregister(this.name);
    }

    private static native boolean nmigrate(String var0, String var1, boolean var2, Status var3);

    public boolean migrateCompute(String desthost, boolean live, Status status) {
        return VirtualMachine.nmigrate(this.name, desthost, live, status);
    }

    public boolean migrateData(Storage dest_pool, Hardware hw, Status status, VMProvider provider) {
        if (status == null) {
            status = Status.null_status;
        }
        String _src_folder = "/volumes/" + this.pool + "/" + this.name;
        String _dest_folder = "/volumes/" + dest_pool.name + "/" + this.name;
        File src_folder = new File(_src_folder);
        if (!src_folder.exists()) {
            status.setStatus("Source folder not found");
            status.setResult(false);
            return false;
        }
        File dest_folder = new File(_dest_folder);
        if (dest_folder.exists()) {
            status.setStatus("Dest folder already exists");
            status.setResult(false);
            return false;
        }
        dest_folder.mkdir();
        if (!dest_folder.exists()) {
            status.setStatus("Unable to create Dest folder");
            status.setResult(false);
            return false;
        }
        File[] files = src_folder.listFiles();
        if (files == null || files.length == 0) {
            status.setStatus("No files found");
            status.setResult(false);
            return false;
        }
        int done = 0;
        int todo = files.length;
        status.setPercent(0);
        status.setStatus("Moving files...");
        for (File file : files) {
            if (file.isDirectory()) continue;
            String name = file.getName();
            Path src_path = file.toPath();
            Path dest_path = new File(_dest_folder + "/" + name).toPath();
            try {
                Files.move(src_path, dest_path, new CopyOption[0]);
            }
            catch (Exception e) {
                JFLog.log(e);
                status.setStatus("Move failed, see logs.");
                status.setResult(false);
                return false;
            }
            status.setPercent(done * 100 / todo);
        }
        src_folder.delete();
        String src_pool = this.pool;
        this.pool = dest_pool.name;
        hw.pool = dest_pool.name;
        for (Disk disk : hw.disks) {
            if (!disk.pool.equals(src_pool)) continue;
            disk.pool = dest_pool.name;
        }
        if (!this.saveHardware(hw)) {
            status.setStatus("Move failed, see logs.");
            status.setResult(false);
            return false;
        }
        if (!VirtualMachine.register(this, hw, provider)) {
            status.setStatus("Clone failed, see logs.");
            status.setResult(false);
            return false;
        }
        status.setPercent(100);
        status.setStatus("Completed");
        status.setResult(true);
        return true;
    }

    public boolean cloneData(Storage dest_pool, String new_name, Status status, VMProvider provider) {
        if (status == null) {
            status = Status.null_status;
        }
        String _src_folder = "/volumes/" + this.pool + "/" + this.name;
        String _dest_folder = "/volumes/" + dest_pool.name + "/" + new_name;
        File src_folder = new File(_src_folder);
        if (!src_folder.exists()) {
            status.setStatus("Source folder not found");
            status.setResult(false);
            return false;
        }
        File dest_folder = new File(_dest_folder);
        if (dest_folder.exists()) {
            status.setStatus("Dest folder already exists");
            status.setResult(false);
            return false;
        }
        dest_folder.mkdir();
        if (!dest_folder.exists()) {
            status.setStatus("Unable to create Dest folder");
            status.setResult(false);
            return false;
        }
        File[] files = src_folder.listFiles();
        if (files == null || files.length == 0) {
            status.setStatus("No files found");
            status.setResult(false);
            return false;
        }
        int done = 0;
        int todo = files.length;
        status.setPercent(0);
        status.setStatus("Copying files...");
        for (File file : files) {
            if (file.isDirectory()) continue;
            String name = file.getName();
            Path src_path = file.toPath();
            Path dest_path = new File(_dest_folder + "/" + name).toPath();
            try {
                Files.copy(src_path, dest_path, new CopyOption[0]);
            }
            catch (Exception e) {
                JFLog.log(e);
                status.setStatus("Clone failed, see logs.");
                status.setResult(false);
                return false;
            }
            status.setPercent(done * 100 / todo);
        }
        VirtualMachine clone = new VirtualMachine(dest_pool.name, new_name, null, -1);
        Hardware hw = clone.loadHardware();
        if (hw == null) {
            status.setStatus("Clone failed, see logs.");
            status.setResult(false);
            return false;
        }
        hw.name = new_name;
        if (!this.pool.equals(dest_pool.name)) {
            hw.pool = dest_pool.name;
            for (Disk disk : hw.disks) {
                if (!disk.pool.equals(this.pool)) continue;
                disk.pool = dest_pool.name;
            }
        }
        if (!clone.saveHardware(hw)) {
            status.setStatus("Clone failed, see logs.");
            status.setResult(false);
            return false;
        }
        if (!VirtualMachine.register(clone, hw, provider)) {
            status.setStatus("Clone failed, see logs.");
            status.setResult(false);
            return false;
        }
        status.setPercent(100);
        status.setStatus("Completed");
        status.setResult(true);
        return true;
    }

    private static String createXML(VirtualMachine vm, Hardware hardware, VMProvider provider) {
        vm.vnc = provider.getVNCPort(hardware.name);
        String hostname = provider.getServerHostname();
        StringBuilder xml2 = new StringBuilder();
        xml2.append("<domain type='kvm'>");
        xml2.append("<name>" + hardware.name + "</name>");
        xml2.append("<uuid>" + vm.uuid + "</uuid>");
        xml2.append("<genid>" + hardware.genid + "</genid>");
        xml2.append("<title>" + hardware.name + "</title>");
        xml2.append("<description>");
        xml2.append("pool=" + hardware.pool);
        xml2.append(";name=" + hardware.name);
        xml2.append(";uuid=" + vm.uuid);
        xml2.append(";vnc=" + vm.vnc);
        xml2.append("</description>");
        if (hardware.os == 1) {
            xml2.append("<clock offset='localtime'/>");
        } else {
            xml2.append("<clock offset='utc'/>");
        }
        xml2.append("<os");
        if (hardware.bios_efi) {
            xml2.append(" firmware='efi'");
        }
        xml2.append(">");
        xml2.append("<type arch='x86_64' machine='" + hardware.machine + "'>hvm</type>");
        if (hardware.bios_secure) {
            xml2.append("<loader secure='yes'/>");
        }
        if (hardware.bios_efi) {
            xml2.append("<nvram type='file'>");
            xml2.append("<source file='/volumes/" + hardware.pool + "/" + hardware.name + "/" + hardware.name + ".nvram'/>");
            xml2.append("</nvram>");
        }
        xml2.append("<bootmenu enable='yes' timeout='3000'/>");
        xml2.append("<smbios mode='emulate'/>");
        xml2.append("</os>");
        xml2.append("<vcpu>" + hardware.cores + "</vcpu>");
        xml2.append("<cpu>");
        xml2.append(" <topology sockets='1' dies='1' clusters='1' cores='" + hardware.cores + "' threads='1'/>");
        xml2.append("</cpu>");
        xml2.append(hardware.memory.toMemoryXML());
        xml2.append("<features>");
        xml2.append("<acpi/>");
        xml2.append("<apic/>");
        xml2.append("<pae/>");
        xml2.append("</features>");
        xml2.append("<devices>");
        if (hardware.tpm != 0) {
            xml2.append("<tpm model='tpm-tis'>");
            xml2.append(" <backend type='emulator' version='" + hardware.getTPMVersion() + "'/>");
            xml2.append("</tpm>");
        }
        for (Controller c : hardware.controllers) {
            xml2.append(c.toXML());
        }
        xml2.append("<input type='keyboard' bus='usb'/>");
        xml2.append("<input type='mouse' bus='usb'/>");
        xml2.append("<audio id='1' type='none'/>");
        xml2.append("<video>");
        xml2.append("<model type='" + hardware.video + "' vram='" + hardware.vram + "' heads='1'>");
        xml2.append("</model>");
        if (hardware.video_3d_accel) {
            xml2.append("<acceleration accel3d='yes'/>");
        }
        xml2.append("</video>");
        if (vm.vnc != -1) {
            xml2.append("<graphics type='vnc' port='" + vm.vnc + "' autoport='no' sharePolicy='allow-exclusive' passwd='" + provider.getVNCPassword() + "'>");
            xml2.append("<listen type='address' address='0.0.0.0'/>");
            xml2.append("</graphics>");
        }
        if (hardware.disks != null) {
            for (Disk drive : hardware.disks) {
                xml2.append(drive.getHardwareXML(hardware.os));
            }
        }
        if (hardware.networks != null) {
            for (Network nic : hardware.networks) {
                int vlan = provider.getVLAN(nic.network);
                NetworkBridge bridge = provider.getBridge(nic.network);
                xml2.append(nic.toXML(bridge, vlan));
            }
        }
        if (hardware.devices != null) {
            for (Device device : hardware.devices) {
                xml2.append(device.toXML());
            }
        }
        xml2.append("</devices>");
        xml2.append("</domain>");
        return xml2.toString();
    }

    public static void main(String[] args) {
        VirtualMachine vm = new VirtualMachine("pool", "example", JF.generateUUID(), 5901);
        Disk disk = new Disk();
        disk.pool = "pool";
        disk.folder = "example";
        disk.name = "disk";
        disk.type = 0;
        disk.target_dev = "sda";
        disk.target_bus = "scsi";
        Network nw = new Network("servers", "vmxnet3", MAC.generate());
        Hardware hw = new Hardware("pool", "example", 1, 4, new Size(4, 3));
        hw.disks.add(disk);
        hw.networks.add(nw);
        System.out.println(VirtualMachine.createXML(vm, hw, new VMProvider(){

            @Override
            public int getVLAN(String name) {
                return 1;
            }

            @Override
            public NetworkBridge getBridge(String name) {
                return new NetworkBridge("virbr0", "os", "eth0");
            }

            @Override
            public int getVNCPort(String name) {
                return 5901;
            }

            @Override
            public String getVNCPassword() {
                return "password";
            }

            @Override
            public String getServerHostname() {
                return "127.0.0.1";
            }
        }));
    }
}

